/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.InternalNameProvider;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.MeteredKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class KeyValueStoreMaterializerTest {
    private final String storePrefix = "prefix";
    @Mock(type=MockType.NICE)
    private InternalNameProvider nameProvider;

    @Test
    public void shouldCreateBuilderThatBuildsMeteredStoreWithCachingAndLoggingEnabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store"));
        materialized.generateStoreNameIfNeeded(this.nameProvider, "prefix");
        KeyValueStoreMaterializer materializer = new KeyValueStoreMaterializer(materialized);
        StoreBuilder builder = materializer.materialize();
        KeyValueStore store = (KeyValueStore)builder.build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrappedStore();
        StateStore logging = caching.wrappedStore();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredKeyValueBytesStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachedStateStore.class));
        MatcherAssert.assertThat((Object)logging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class));
    }

    @Test
    public void shouldCreateBuilderThatBuildsStoreWithCachingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store").withCachingDisabled());
        materialized.generateStoreNameIfNeeded(this.nameProvider, "prefix");
        KeyValueStoreMaterializer materializer = new KeyValueStoreMaterializer(materialized);
        StoreBuilder builder = materializer.materialize();
        KeyValueStore store = (KeyValueStore)builder.build();
        WrappedStateStore logging = (WrappedStateStore)((WrappedStateStore)store).wrappedStore();
        MatcherAssert.assertThat((Object)logging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class));
    }

    @Test
    public void shouldCreateBuilderThatBuildsStoreWithLoggingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store").withLoggingDisabled());
        materialized.generateStoreNameIfNeeded(this.nameProvider, "prefix");
        KeyValueStoreMaterializer materializer = new KeyValueStoreMaterializer(materialized);
        StoreBuilder builder = materializer.materialize();
        KeyValueStore store = (KeyValueStore)builder.build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrappedStore();
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachedStateStore.class));
        MatcherAssert.assertThat((Object)caching.wrappedStore(), (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class)));
    }

    @Test
    public void shouldCreateBuilderThatBuildsStoreWithCachingAndLoggingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store").withCachingDisabled().withLoggingDisabled());
        materialized.generateStoreNameIfNeeded(this.nameProvider, "prefix");
        KeyValueStoreMaterializer materializer = new KeyValueStoreMaterializer(materialized);
        StoreBuilder builder = materializer.materialize();
        KeyValueStore store = (KeyValueStore)builder.build();
        StateStore wrapped = ((WrappedStateStore)store).wrappedStore();
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(CachedStateStore.class)));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class)));
    }

    @Test
    public void shouldCreateKeyValueStoreWithTheProvidedInnerStore() {
        KeyValueBytesStoreSupplier supplier = (KeyValueBytesStoreSupplier)EasyMock.createNiceMock(KeyValueBytesStoreSupplier.class);
        InMemoryKeyValueStore store = new InMemoryKeyValueStore("name", Serdes.Bytes(), Serdes.ByteArray());
        EasyMock.expect((Object)supplier.name()).andReturn((Object)"name").anyTimes();
        EasyMock.expect((Object)supplier.get()).andReturn((Object)store);
        EasyMock.replay((Object[])new Object[]{supplier});
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)supplier));
        materialized.generateStoreNameIfNeeded(this.nameProvider, "prefix");
        KeyValueStoreMaterializer materializer = new KeyValueStoreMaterializer(materialized);
        StoreBuilder builder = materializer.materialize();
        KeyValueStore built = (KeyValueStore)builder.build();
        StateStore inner = ((WrappedStateStore)built).inner();
        MatcherAssert.assertThat((Object)inner, (Matcher)CoreMatchers.equalTo((Object)store));
    }
}

