/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.internals.KStreamPrint;
import org.apache.kafka.streams.kstream.internals.PrintForeachAction;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KStreamPrintTest {
    private ByteArrayOutputStream byteOutStream;
    private KeyValueMapper<Integer, String, String> mapper;
    private KStreamPrint kStreamPrint;
    private Processor printProcessor;

    @Before
    public void setUp() throws Exception {
        this.byteOutStream = new ByteArrayOutputStream();
        this.mapper = new KeyValueMapper<Integer, String, String>(){

            public String apply(Integer key, String value) {
                return String.format("%d, %s", key, value);
            }
        };
        this.kStreamPrint = new KStreamPrint((ForeachAction)new PrintForeachAction((OutputStream)this.byteOutStream, this.mapper, "test-stream"));
        this.printProcessor = this.kStreamPrint.get();
        ProcessorContext processorContext = (ProcessorContext)EasyMock.createNiceMock(ProcessorContext.class);
        EasyMock.replay((Object[])new Object[]{processorContext});
        this.printProcessor.init(processorContext);
    }

    @Test
    public void testPrintStreamWithProvidedKeyValueMapper() {
        List inputRecords = Arrays.asList(new KeyValue((Object)0, (Object)"zero"), new KeyValue((Object)1, (Object)"one"), new KeyValue((Object)2, (Object)"two"), new KeyValue((Object)3, (Object)"three"));
        String[] expectedResult = new String[]{"[test-stream]: 0, zero", "[test-stream]: 1, one", "[test-stream]: 2, two", "[test-stream]: 3, three"};
        this.doTest(inputRecords, expectedResult);
    }

    private void assertFlushData(String[] expectedResult, ByteArrayOutputStream byteOutStream) {
        String[] flushOutDatas = new String(byteOutStream.toByteArray(), Charset.forName("UTF-8")).split("\\r*\\n");
        for (int i = 0; i < flushOutDatas.length; ++i) {
            Assert.assertEquals((Object)expectedResult[i], (Object)flushOutDatas[i]);
        }
    }

    private <K, V> void doTest(List<KeyValue<K, V>> inputRecords, String[] expectedResult) {
        for (KeyValue<K, V> record : inputRecords) {
            this.printProcessor.process(record.key, record.value);
        }
        this.printProcessor.close();
        this.assertFlushData(expectedResult, this.byteOutStream);
    }
}

