/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.streams.kstream.UnlimitedWindows;
import org.apache.kafka.streams.kstream.internals.UnlimitedWindow;
import org.junit.Assert;
import org.junit.Test;

public class UnlimitedWindowsTest {
    private static long anyStartTime = 10L;

    @Test
    public void shouldSetWindowStartTime() {
        Assert.assertEquals((long)anyStartTime, (long)UnlimitedWindows.of().startOn((long)UnlimitedWindowsTest.anyStartTime).startMs);
    }

    @Test(expected=IllegalArgumentException.class)
    public void startTimeMustNotBeNegative() {
        UnlimitedWindows.of().startOn(-1L);
    }

    @Test
    public void shouldThrowOnUntil() {
        UnlimitedWindows windowSpec = UnlimitedWindows.of();
        try {
            windowSpec.until(42L);
            Assert.fail((String)"should not allow to set window retention time");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldIncludeRecordsThatHappenedOnWindowStart() {
        UnlimitedWindows w = UnlimitedWindows.of().startOn(anyStartTime);
        Map matchedWindows = w.windowsFor(w.startMs);
        Assert.assertEquals((long)1L, (long)matchedWindows.size());
        Assert.assertEquals((Object)new UnlimitedWindow(anyStartTime), matchedWindows.get(anyStartTime));
    }

    @Test
    public void shouldIncludeRecordsThatHappenedAfterWindowStart() {
        UnlimitedWindows w = UnlimitedWindows.of().startOn(anyStartTime);
        long timestamp = w.startMs + 1L;
        Map matchedWindows = w.windowsFor(timestamp);
        Assert.assertEquals((long)1L, (long)matchedWindows.size());
        Assert.assertEquals((Object)new UnlimitedWindow(anyStartTime), matchedWindows.get(anyStartTime));
    }

    @Test
    public void shouldExcludeRecordsThatHappenedBeforeWindowStart() {
        UnlimitedWindows w = UnlimitedWindows.of().startOn(anyStartTime);
        long timestamp = w.startMs - 1L;
        Map matchedWindows = w.windowsFor(timestamp);
        Assert.assertTrue((boolean)matchedWindows.isEmpty());
    }
}

