/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingWindowBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.test.NoOpRecordCollector;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class ChangeLoggingWindowBytesStoreTest {
    private final TaskId taskId = new TaskId(0, 0);
    private final Map sent = new HashMap();
    private final NoOpRecordCollector collector = new NoOpRecordCollector(){

        @Override
        public <K, V> void send(String topic, K key, V value, Headers headers, Integer partition, Long timestamp, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            ChangeLoggingWindowBytesStoreTest.this.sent.put(key, value);
        }
    };
    private final byte[] value1 = new byte[]{0};
    private final Bytes bytesKey = Bytes.wrap((byte[])this.value1);
    @Mock(type=MockType.NICE)
    private WindowStore<Bytes, byte[]> inner;
    @Mock(type=MockType.NICE)
    private ProcessorContextImpl context;
    private ChangeLoggingWindowBytesStore store;

    @Before
    public void setUp() {
        this.store = new ChangeLoggingWindowBytesStore(this.inner, false);
    }

    private void init() {
        EasyMock.expect((Object)this.context.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.context.recordCollector()).andReturn((Object)this.collector);
        this.inner.init((ProcessorContext)this.context, (StateStore)this.store);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.inner, this.context});
        this.store.init((ProcessorContext)this.context, (StateStore)this.store);
    }

    @Test
    public void shouldLogPuts() {
        this.inner.put((Object)this.bytesKey, (Object)this.value1, 0L);
        EasyMock.expectLastCall();
        this.init();
        this.store.put(this.bytesKey, this.value1);
        Assert.assertArrayEquals((byte[])this.value1, (byte[])((byte[])this.sent.get(WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)0))));
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFetching() {
        EasyMock.expect((Object)this.inner.fetch((Object)this.bytesKey, 0L, 10L)).andReturn((Object)KeyValueIterators.emptyWindowStoreIterator());
        this.init();
        this.store.fetch(this.bytesKey, 0L, 10L);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFetchingRange() {
        EasyMock.expect((Object)this.inner.fetch((Object)this.bytesKey, (Object)this.bytesKey, 0L, 1L)).andReturn((Object)KeyValueIterators.emptyIterator());
        this.init();
        this.store.fetch(this.bytesKey, this.bytesKey, 0L, 1L);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldRetainDuplicatesWhenSet() {
        this.store = new ChangeLoggingWindowBytesStore(this.inner, true);
        this.inner.put((Object)this.bytesKey, (Object)this.value1, 0L);
        EasyMock.expectLastCall().times(2);
        this.init();
        this.store.put(this.bytesKey, this.value1);
        this.store.put(this.bytesKey, this.value1);
        Assert.assertArrayEquals((byte[])this.value1, (byte[])((byte[])this.sent.get(WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)1))));
        Assert.assertArrayEquals((byte[])this.value1, (byte[])((byte[])this.sent.get(WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)2))));
        EasyMock.verify((Object[])new Object[]{this.inner});
    }
}

