/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ChangeLoggingKeyValueBytesStoreTest {
    private InternalMockProcessorContext context;
    private final InMemoryKeyValueStore<Bytes, byte[]> inner = new InMemoryKeyValueStore("kv", Serdes.Bytes(), Serdes.ByteArray());
    private final ChangeLoggingKeyValueBytesStore store = new ChangeLoggingKeyValueBytesStore(this.inner);
    private final Map sent = new HashMap();
    private final Bytes hi = Bytes.wrap((byte[])"hi".getBytes());
    private final Bytes hello = Bytes.wrap((byte[])"hello".getBytes());
    private final byte[] there = "there".getBytes();
    private final byte[] world = "world".getBytes();

    @Before
    public void before() {
        NoOpRecordCollector collector = new NoOpRecordCollector(){

            @Override
            public <K, V> void send(String topic, K key, V value, Headers headers, Integer partition, Long timestamp, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
                ChangeLoggingKeyValueBytesStoreTest.this.sent.put(key, value);
            }
        };
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), collector, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        this.context.setTime(0L);
        this.store.init((ProcessorContext)this.context, (StateStore)this.store);
    }

    @After
    public void after() {
        this.store.close();
    }

    @Test
    public void shouldWriteKeyValueBytesToInnerStoreOnPut() {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.inner.get((Object)this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldLogChangeOnPut() {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hi)), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldWriteAllKeyValueToInnerStoreOnPutAll() {
        this.store.putAll(Arrays.asList(KeyValue.pair((Object)this.hi, (Object)this.there), KeyValue.pair((Object)this.hello, (Object)this.world)));
        MatcherAssert.assertThat((Object)this.inner.get((Object)this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)this.inner.get((Object)this.hello), (Matcher)CoreMatchers.equalTo((Object)this.world));
    }

    @Test
    public void shouldLogChangesOnPutAll() {
        this.store.putAll(Arrays.asList(KeyValue.pair((Object)this.hi, (Object)this.there), KeyValue.pair((Object)this.hello, (Object)this.world)));
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hi)), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hello)), (Matcher)CoreMatchers.equalTo((Object)this.world));
    }

    @Test
    public void shouldPropagateDelete() {
        this.store.put(this.hi, this.there);
        this.store.delete(this.hi);
        MatcherAssert.assertThat((Object)this.inner.approximateNumEntries(), (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)this.inner.get((Object)this.hi), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldReturnOldValueOnDelete() {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.store.delete(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldLogKeyNullOnDelete() {
        this.store.put(this.hi, this.there);
        this.store.delete(this.hi);
        MatcherAssert.assertThat((Object)this.sent.containsKey(this.hi), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(this.sent.get(this.hi), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldWriteToInnerOnPutIfAbsentNoPreviousValue() {
        this.store.putIfAbsent(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.inner.get((Object)this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldNotWriteToInnerOnPutIfAbsentWhenValueForKeyExists() {
        this.store.put(this.hi, this.there);
        this.store.putIfAbsent(this.hi, this.world);
        MatcherAssert.assertThat((Object)this.inner.get((Object)this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldWriteToChangelogOnPutIfAbsentWhenNoPreviousValue() {
        this.store.putIfAbsent(this.hi, this.there);
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hi)), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldNotWriteToChangeLogOnPutIfAbsentWhenValueForKeyExists() {
        this.store.put(this.hi, this.there);
        this.store.putIfAbsent(this.hi, this.world);
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hi)), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldReturnCurrentValueOnPutIfAbsent() {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.store.putIfAbsent(this.hi, this.world), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldReturnNullOnPutIfAbsentWhenNoPreviousValue() {
        MatcherAssert.assertThat((Object)this.store.putIfAbsent(this.hi, this.there), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldReturnValueOnGetWhenExists() {
        this.store.put(this.hello, this.world);
        MatcherAssert.assertThat((Object)this.store.get(this.hello), (Matcher)CoreMatchers.equalTo((Object)this.world));
    }

    @Test
    public void shouldReturnNullOnGetWhenDoesntExist() {
        MatcherAssert.assertThat((Object)this.store.get(this.hello), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

