/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.RestoringTasks;
import org.apache.kafka.streams.processor.internals.StateRestorer;

public class MockChangelogReader
implements ChangelogReader {
    private final Set<TopicPartition> registered = new HashSet<TopicPartition>();

    public void register(StateRestorer restorer) {
        this.registered.add(restorer.partition());
    }

    public Collection<TopicPartition> restore(RestoringTasks active) {
        return this.registered;
    }

    public Map<TopicPartition, Long> restoredOffsets() {
        return Collections.emptyMap();
    }

    public void reset() {
        this.registered.clear();
    }

    public boolean wasRegistered(TopicPartition partition) {
        return this.registered.contains(partition);
    }
}

