/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.Serialized;
import org.apache.kafka.streams.kstream.SessionWindowedKStream;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockReducer;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class SessionWindowedKStreamImplTest {
    private static final String TOPIC = "input";
    private final StreamsBuilder builder = new StreamsBuilder();
    private final ConsumerRecordFactory<String, String> recordFactory = new ConsumerRecordFactory((Serializer)new StringSerializer(), (Serializer)new StringSerializer());
    private final Properties props = StreamsTestUtils.topologyTestConfig(Serdes.String(), Serdes.String());
    private final Merger<String, String> sessionMerger = new Merger<String, String>(){

        public String apply(String aggKey, String aggOne, String aggTwo) {
            return aggOne + "+" + aggTwo;
        }
    };
    private SessionWindowedKStream<String, String> stream;

    @Before
    public void before() {
        KStream stream = this.builder.stream(TOPIC, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.stream = stream.groupByKey(Serialized.with((Serde)Serdes.String(), (Serde)Serdes.String())).windowedBy(SessionWindows.with((long)500L));
    }

    @Test
    public void shouldCountSessionWindowed() {
        final HashMap results = new HashMap();
        this.stream.count().toStream().foreach((ForeachAction)new ForeachAction<Windowed<String>, Long>(){

            public void apply(Windowed<String> key, Long value) {
                results.put(key, value);
            }
        });
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props, 0L);){
            this.processData(driver);
        }
        MatcherAssert.assertThat(results.get(new Windowed((Object)"1", (Window)new SessionWindow(10L, 15L))), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat(results.get(new Windowed((Object)"2", (Window)new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat(results.get(new Windowed((Object)"1", (Window)new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldReduceWindowed() {
        final HashMap results = new HashMap();
        this.stream.reduce(MockReducer.STRING_ADDER).toStream().foreach((ForeachAction)new ForeachAction<Windowed<String>, String>(){

            public void apply(Windowed<String> key, String value) {
                results.put(key, value);
            }
        });
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props, 0L);){
            this.processData(driver);
        }
        MatcherAssert.assertThat(results.get(new Windowed((Object)"1", (Window)new SessionWindow(10L, 15L))), (Matcher)CoreMatchers.equalTo((Object)"1+2"));
        MatcherAssert.assertThat(results.get(new Windowed((Object)"2", (Window)new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)"1"));
        MatcherAssert.assertThat(results.get(new Windowed((Object)"1", (Window)new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)"3"));
    }

    @Test
    public void shouldAggregateSessionWindowed() {
        final HashMap results = new HashMap();
        this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, this.sessionMerger, Materialized.with((Serde)Serdes.String(), (Serde)Serdes.String())).toStream().foreach((ForeachAction)new ForeachAction<Windowed<String>, String>(){

            public void apply(Windowed<String> key, String value) {
                results.put(key, value);
            }
        });
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props, 0L);){
            this.processData(driver);
        }
        MatcherAssert.assertThat(results.get(new Windowed((Object)"1", (Window)new SessionWindow(10L, 15L))), (Matcher)CoreMatchers.equalTo((Object)"0+0+1+2"));
        MatcherAssert.assertThat(results.get(new Windowed((Object)"2", (Window)new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)"0+1"));
        MatcherAssert.assertThat(results.get(new Windowed((Object)"1", (Window)new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)"0+3"));
    }

    @Test
    public void shouldMaterializeCount() {
        this.stream.count(Materialized.as((String)"count-store"));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props, 0L);){
            this.processData(driver);
            SessionStore store = driver.getSessionStore("count-store");
            List data = StreamsTestUtils.toList(store.fetch((Object)"1", (Object)"2"));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new SessionWindow(10L, 15L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new SessionWindow(600L, 600L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new SessionWindow(600L, 600L)), (Object)1L))));
        }
    }

    @Test
    public void shouldMaterializeReduced() {
        this.stream.reduce(MockReducer.STRING_ADDER, Materialized.as((String)"reduced"));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props, 0L);){
            this.processData(driver);
            SessionStore sessionStore = driver.getSessionStore("reduced");
            List data = StreamsTestUtils.toList(sessionStore.fetch((Object)"1", (Object)"2"));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new SessionWindow(10L, 15L)), (Object)"1+2"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new SessionWindow(600L, 600L)), (Object)"3"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new SessionWindow(600L, 600L)), (Object)"1"))));
        }
    }

    @Test
    public void shouldMaterializeAggregated() {
        this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, this.sessionMerger, Materialized.as((String)"aggregated").withValueSerde(Serdes.String()));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props, 0L);){
            this.processData(driver);
            SessionStore sessionStore = driver.getSessionStore("aggregated");
            List data = StreamsTestUtils.toList(sessionStore.fetch((Object)"1", (Object)"2"));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new SessionWindow(10L, 15L)), (Object)"0+0+1+2"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new SessionWindow(600L, 600L)), (Object)"0+3"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new SessionWindow(600L, 600L)), (Object)"0+1"))));
        }
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateIfInitializerIsNull() {
        this.stream.aggregate(null, MockAggregator.TOSTRING_ADDER, this.sessionMerger);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateIfAggregatorIsNull() {
        this.stream.aggregate(MockInitializer.STRING_INIT, null, this.sessionMerger);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateIfMergerIsNull() {
        this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnReduceIfReducerIsNull() {
        this.stream.reduce(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnMaterializedAggregateIfInitializerIsNull() {
        this.stream.aggregate(null, MockAggregator.TOSTRING_ADDER, this.sessionMerger, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnMaterializedAggregateIfAggregatorIsNull() {
        this.stream.aggregate(MockInitializer.STRING_INIT, null, this.sessionMerger, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnMaterializedAggregateIfMergerIsNull() {
        this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnMaterializedAggregateIfMaterializedIsNull() {
        this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, this.sessionMerger, (Materialized)null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnMaterializedReduceIfReducerIsNull() {
        this.stream.reduce(null, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnMaterializedReduceIfMaterializedIsNull() {
        this.stream.reduce(MockReducer.STRING_ADDER, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnCountIfMaterializedIsNull() {
        this.stream.count(null);
    }

    private void processData(TopologyTestDriver driver) {
        driver.pipeInput(this.recordFactory.create(TOPIC, (Object)"1", (Object)"1", 10L));
        driver.pipeInput(this.recordFactory.create(TOPIC, (Object)"1", (Object)"2", 15L));
        driver.pipeInput(this.recordFactory.create(TOPIC, (Object)"1", (Object)"3", 600L));
        driver.pipeInput(this.recordFactory.create(TOPIC, (Object)"2", (Object)"1", 600L));
    }
}

