/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Printed;
import org.apache.kafka.streams.kstream.internals.PrintedInternal;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrintedTest {
    private final PrintStream originalSysOut = System.out;
    private final ByteArrayOutputStream sysOut = new ByteArrayOutputStream();
    private Printed<String, Integer> sysOutPrinter;

    @Before
    public void before() {
        System.setOut(new PrintStream(this.sysOut));
        this.sysOutPrinter = Printed.toSysOut();
    }

    @After
    public void after() {
        System.setOut(this.originalSysOut);
    }

    @Test
    public void shouldCreateProcessorThatPrintsToFile() throws IOException {
        File file = TestUtils.tempFile();
        ProcessorSupplier processorSupplier = new PrintedInternal(Printed.toFile((String)file.getPath())).build("processor");
        Processor processor = processorSupplier.get();
        processor.process((Object)"hi", (Object)1);
        processor.close();
        try (FileInputStream stream = new FileInputStream(file);){
            byte[] data = new byte[stream.available()];
            stream.read(data);
            Assert.assertThat((Object)new String(data, StandardCharsets.UTF_8.name()), (Matcher)CoreMatchers.equalTo((Object)"[processor]: hi, 1\n"));
        }
    }

    @Test
    public void shouldCreateProcessorThatPrintsToStdOut() throws UnsupportedEncodingException {
        ProcessorSupplier supplier = new PrintedInternal(this.sysOutPrinter).build("processor");
        Processor processor = supplier.get();
        processor.process((Object)"good", (Object)2);
        processor.close();
        Assert.assertThat((Object)this.sysOut.toString(StandardCharsets.UTF_8.name()), (Matcher)CoreMatchers.equalTo((Object)"[processor]: good, 2\n"));
    }

    @Test
    public void shouldPrintWithLabel() throws UnsupportedEncodingException {
        Processor processor = new PrintedInternal(this.sysOutPrinter.withLabel("label")).build("processor").get();
        processor.process((Object)"hello", (Object)3);
        processor.close();
        Assert.assertThat((Object)this.sysOut.toString(StandardCharsets.UTF_8.name()), (Matcher)CoreMatchers.equalTo((Object)"[label]: hello, 3\n"));
    }

    @Test
    public void shouldPrintWithKeyValueMapper() throws UnsupportedEncodingException {
        Processor processor = new PrintedInternal(this.sysOutPrinter.withKeyValueMapper((KeyValueMapper)new KeyValueMapper<String, Integer, String>(){

            public String apply(String key, Integer value) {
                return String.format("%s -> %d", key, value);
            }
        })).build("processor").get();
        processor.process((Object)"hello", (Object)1);
        processor.close();
        Assert.assertThat((Object)this.sysOut.toString(StandardCharsets.UTF_8.name()), (Matcher)CoreMatchers.equalTo((Object)"[processor]: hello -> 1\n"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionIfFilePathIsNull() {
        Printed.toFile(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionIfMapperIsNull() {
        this.sysOutPrinter.withKeyValueMapper(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionIfLabelIsNull() {
        this.sysOutPrinter.withLabel(null);
    }

    @Test(expected=TopologyException.class)
    public void shouldThrowTopologyExceptionIfFilePathIsEmpty() {
        Printed.toFile((String)"");
    }

    @Test(expected=TopologyException.class)
    public void shouldThrowTopologyExceptionIfFilePathDoesntExist() {
        Printed.toFile((String)"/this/should/not/exist");
    }
}

