/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;

public class KStreamWindowReduce<K, V, W extends Window>
implements KStreamAggProcessorSupplier<K, Windowed<K>, V, V> {
    private final String storeName;
    private final Windows<W> windows;
    private final Reducer<V> reducer;
    private boolean sendOldValues = false;

    public KStreamWindowReduce(Windows<W> windows, String storeName, Reducer<V> reducer) {
        this.windows = windows;
        this.storeName = storeName;
        this.reducer = reducer;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamWindowReduceProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<Windowed<K>, V> view() {
        return new KTableValueGetterSupplier<Windowed<K>, V>(){

            @Override
            public KTableValueGetter<Windowed<K>, V> get() {
                return new KStreamWindowReduceValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamWindowReduce.this.storeName};
            }
        };
    }

    private class KStreamWindowReduceValueGetter
    implements KTableValueGetter<Windowed<K>, V> {
        private WindowStore<K, V> windowStore;

        private KStreamWindowReduceValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.windowStore = (WindowStore)context.getStateStore(KStreamWindowReduce.this.storeName);
        }

        @Override
        public V get(Windowed<K> windowedKey) {
            Object key = windowedKey.key();
            Window window = windowedKey.window();
            try (WindowStoreIterator iter = this.windowStore.fetch(key, window.start(), window.start());){
                Object v = iter.hasNext() ? (Object)((KeyValue)iter.next()).value : null;
                return v;
            }
        }
    }

    private class KStreamWindowReduceProcessor
    extends AbstractProcessor<K, V> {
        private WindowStore<K, V> windowStore;
        private TupleForwarder<Windowed<K>, V> tupleForwarder;

        private KStreamWindowReduceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.windowStore = (WindowStore)context.getStateStore(KStreamWindowReduce.this.storeName);
            this.tupleForwarder = new TupleForwarder(this.windowStore, context, new ForwardingCacheFlushListener(context, KStreamWindowReduce.this.sendOldValues), KStreamWindowReduce.this.sendOldValues);
        }

        @Override
        public void process(K key, V value) {
            if (key == null) {
                return;
            }
            long timestamp = this.context().timestamp();
            Map matchedWindows = KStreamWindowReduce.this.windows.windowsFor(timestamp);
            long timeFrom = Long.MAX_VALUE;
            long timeTo = Long.MIN_VALUE;
            Iterator<Object> i$ = matchedWindows.keySet().iterator();
            while (i$.hasNext()) {
                long l = i$.next();
                timeFrom = l < timeFrom ? l : timeFrom;
                timeTo = l > timeTo ? l : timeTo;
            }
            Throwable throwable = null;
            try (WindowStoreIterator iter = this.windowStore.fetch(key, timeFrom, timeTo);){
                while (iter.hasNext()) {
                    KeyValue entry = (KeyValue)iter.next();
                    Window window = (Window)matchedWindows.get(entry.key);
                    if (window == null) continue;
                    Object oldAgg = entry.value;
                    Object newAgg = oldAgg;
                    newAgg = newAgg == null ? value : KStreamWindowReduce.this.reducer.apply(newAgg, value);
                    this.windowStore.put(key, newAgg, window.start());
                    this.tupleForwarder.maybeForward(new Windowed(key, window), newAgg, oldAgg);
                    matchedWindows.remove(entry.key);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (Map.Entry entry : matchedWindows.entrySet()) {
                this.windowStore.put(key, value, (Long)entry.getKey());
                this.tupleForwarder.maybeForward(new Windowed(key, (Window)entry.getValue()), value, null);
            }
        }
    }
}

