/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.util.Properties;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.tests.SmokeTestUtil;

public class StreamsUpgradeTest {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("StreamsUpgradeTest requires two argument (kafka-url, state-dir, [upgradeFrom: optional]) but only " + args.length + " provided: " + (args.length > 0 ? args[0] : ""));
        }
        String kafka = args[0];
        String stateDir = args[1];
        String upgradeFrom = args.length > 2 ? args[2] : null;
        System.out.println("StreamsTest instance started (StreamsUpgradeTest trunk)");
        System.out.println("kafka=" + kafka);
        System.out.println("stateDir=" + stateDir);
        System.out.println("upgradeFrom=" + upgradeFrom);
        StreamsBuilder builder = new StreamsBuilder();
        KStream dataStream = builder.stream("data");
        dataStream.process(SmokeTestUtil.printProcessorSupplier("data"), new String[0]);
        dataStream.to("echo");
        Properties config = new Properties();
        config.setProperty("application.id", "StreamsUpgradeTest");
        config.setProperty("bootstrap.servers", kafka);
        config.setProperty("state.dir", stateDir);
        config.put("commit.interval.ms", (Object)1000);
        if (upgradeFrom != null) {
            config.setProperty("upgrade.from", upgradeFrom);
        }
        final KafkaStreams streams = new KafkaStreams(builder.build(), config);
        streams.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("closing Kafka Streams instance");
                System.out.flush();
                streams.close();
                System.out.println("UPGRADE-TEST-CLIENT-CLOSED");
                System.out.flush();
            }
        });
    }
}

