/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.tests.ShutdownDeadlockTest;
import org.apache.kafka.streams.tests.SmokeTestClient;
import org.apache.kafka.streams.tests.SmokeTestDriver;

public class StreamsSmokeTest {
    public static void main(String[] args) throws InterruptedException {
        String kafka = args[0];
        String stateDir = args.length > 1 ? args[1] : null;
        String command = args.length > 2 ? args[2] : null;
        boolean disableAutoTerminate = args.length > 3;
        System.out.println("StreamsTest instance started (StreamsSmokeTest)");
        System.out.println("command=" + command);
        System.out.println("kafka=" + kafka);
        System.out.println("stateDir=" + stateDir);
        System.out.println("disableAutoTerminate=" + disableAutoTerminate);
        switch (command) {
            case "standalone": {
                SmokeTestDriver.main(args);
                break;
            }
            case "run": {
                int numKeys = 10;
                int maxRecordsPerKey = 500;
                if (disableAutoTerminate) {
                    SmokeTestDriver.generate(kafka, 10, 500, false);
                    break;
                }
                Map<String, Set<Integer>> allData = SmokeTestDriver.generate(kafka, 10, 500);
                SmokeTestDriver.verify(kafka, allData, 500);
                break;
            }
            case "process": {
                SmokeTestClient client = new SmokeTestClient(new File(stateDir), kafka);
                client.start();
                break;
            }
            case "close-deadlock-test": {
                ShutdownDeadlockTest test = new ShutdownDeadlockTest(kafka);
                test.start();
                break;
            }
            default: {
                System.out.println("unknown command: " + command);
            }
        }
    }
}

