/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.CachingSessionStore;
import org.apache.kafka.streams.state.internals.RocksDBSessionStoreSupplier;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class RocksDBSessionStoreSupplierTest {
    private static final String STORE_NAME = "name";
    private final List<ProducerRecord> logged = new ArrayList<ProducerRecord>();
    private final ThreadCache cache = new ThreadCache(new LogContext("test "), 1024L, (StreamsMetrics)new MockStreamsMetrics(new Metrics()));
    private final MockProcessorContext context = new MockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.String(), new NoOpRecordCollector(){

        @Override
        public <K, V> void send(String topic, K key, V value, Integer partition, Long timestamp, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            RocksDBSessionStoreSupplierTest.this.logged.add(new ProducerRecord(topic, partition, timestamp, key, value));
        }
    }, this.cache);
    private SessionStore<String, String> store;

    @After
    public void close() {
        this.context.close();
        this.store.close();
    }

    @Test
    public void shouldCreateLoggingEnabledStoreWhenStoreLogged() {
        this.store = this.createStore(true, false);
        this.context.setTime(1L);
        this.store.init((ProcessorContext)this.context, this.store);
        this.store.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 10L)), (Object)"b");
        Assert.assertFalse((boolean)this.logged.isEmpty());
    }

    @Test
    public void shouldNotBeLoggingEnabledStoreWhenLoggingNotEnabled() {
        this.store = this.createStore(false, false);
        this.context.setTime(1L);
        this.store.init((ProcessorContext)this.context, this.store);
        this.store.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 10L)), (Object)"b");
        Assert.assertTrue((boolean)this.logged.isEmpty());
    }

    @Test
    public void shouldReturnCachedSessionStoreWhenCachingEnabled() {
        this.store = this.createStore(false, true);
        this.store.init((ProcessorContext)this.context, this.store);
        this.context.setTime(1L);
        this.store.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 10L)), (Object)"b");
        this.store.put(new Windowed((Object)"b", (Window)new SessionWindow(0L, 10L)), (Object)"c");
        MatcherAssert.assertThat((Object)((WrappedStateStore)this.store).wrappedStore(), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(CachingSessionStore.class)));
        MatcherAssert.assertThat((Object)this.cache.size(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void shouldHaveMeteredStoreWhenCached() {
        this.store = this.createStore(false, true);
        this.store.init((ProcessorContext)this.context, this.store);
        StreamsMetrics metrics = this.context.metrics();
        Assert.assertFalse((boolean)metrics.metrics().isEmpty());
    }

    @Test
    public void shouldHaveMeteredStoreWhenLogged() {
        this.store = this.createStore(true, false);
        this.store.init((ProcessorContext)this.context, this.store);
        StreamsMetrics metrics = this.context.metrics();
        Assert.assertFalse((boolean)metrics.metrics().isEmpty());
    }

    @Test
    public void shouldHaveMeteredStoreWhenNotLoggedOrCached() {
        this.store = this.createStore(false, false);
        this.store.init((ProcessorContext)this.context, this.store);
        StreamsMetrics metrics = this.context.metrics();
        Assert.assertFalse((boolean)metrics.metrics().isEmpty());
    }

    private SessionStore<String, String> createStore(boolean logged, boolean cached) {
        return new RocksDBSessionStoreSupplier(STORE_NAME, 10L, Serdes.String(), Serdes.String(), logged, Collections.emptyMap(), cached).get();
    }
}

