/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheWindowStoreIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class MergedSortedCacheWrappedWindowStoreIteratorTest {
    private static final SegmentedCacheFunction SINGLE_SEGMENT_CACHE_FUNCTION = new SegmentedCacheFunction(null, -1L){

        public long segmentId(Bytes key) {
            return 0L;
        }
    };
    private final List<KeyValue<Long, byte[]>> windowStoreKvPairs = new ArrayList<KeyValue<Long, byte[]>>();
    private final ThreadCache cache = new ThreadCache(new LogContext("testCache "), 1000000L, (StreamsMetrics)new MockStreamsMetrics(new Metrics()));
    private final String namespace = "0.0-one";
    private final StateSerdes<String, String> stateSerdes = new StateSerdes("foo", Serdes.String(), Serdes.String());

    @Test
    public void shouldIterateOverValueFromBothIterators() {
        ArrayList<KeyValue> expectedKvPairs = new ArrayList<KeyValue>();
        for (long t = 0L; t < 100L; t += 20L) {
            byte[] v1Bytes = String.valueOf(t).getBytes();
            KeyValue v1 = KeyValue.pair((Object)t, (Object)v1Bytes);
            this.windowStoreKvPairs.add((KeyValue<Long, byte[]>)v1);
            expectedKvPairs.add(KeyValue.pair((Object)t, (Object)v1Bytes));
            Bytes keyBytes = WindowStoreUtils.toBinaryKey((Object)"a", (long)(t + 10L), (int)0, this.stateSerdes);
            byte[] valBytes = String.valueOf(t + 10L).getBytes();
            expectedKvPairs.add(KeyValue.pair((Object)(t + 10L), (Object)valBytes));
            this.cache.put("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(keyBytes), new LRUCacheEntry(valBytes));
        }
        Bytes fromBytes = WindowStoreUtils.toBinaryKey((Object)"a", (long)0L, (int)0, this.stateSerdes);
        Bytes toBytes = WindowStoreUtils.toBinaryKey((Object)"a", (long)100L, (int)0, this.stateSerdes);
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(this.windowStoreKvPairs.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(fromBytes), SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(toBytes));
        MergedSortedCacheWindowStoreIterator iterator = new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator);
        int index = 0;
        while (iterator.hasNext()) {
            KeyValue next = iterator.next();
            KeyValue expected = (KeyValue)expectedKvPairs.get(index++);
            Assert.assertArrayEquals((byte[])((byte[])expected.value), (byte[])((byte[])next.value));
            Assert.assertEquals((Object)expected.key, (Object)next.key);
        }
        iterator.close();
    }

    @Test
    public void shouldPeekNextStoreKey() {
        this.windowStoreKvPairs.add((KeyValue<Long, byte[]>)KeyValue.pair((Object)10L, (Object)"a".getBytes()));
        this.cache.put("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(WindowStoreUtils.toBinaryKey((Object)"a", (long)0L, (int)0, this.stateSerdes)), new LRUCacheEntry("b".getBytes()));
        Bytes fromBytes = WindowStoreUtils.toBinaryKey((Object)"a", (long)0L, (int)0, this.stateSerdes);
        Bytes toBytes = WindowStoreUtils.toBinaryKey((Object)"a", (long)100L, (int)0, this.stateSerdes);
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(this.windowStoreKvPairs.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(fromBytes), SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(toBytes));
        MergedSortedCacheWindowStoreIterator iterator = new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator);
        MatcherAssert.assertThat((Object)iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)0L));
        iterator.next();
        MatcherAssert.assertThat((Object)iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)10L));
        iterator.close();
    }

    @Test
    public void shouldPeekNextCacheKey() {
        this.windowStoreKvPairs.add((KeyValue<Long, byte[]>)KeyValue.pair((Object)0L, (Object)"a".getBytes()));
        this.cache.put("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(WindowStoreUtils.toBinaryKey((Object)"a", (long)10L, (int)0, this.stateSerdes)), new LRUCacheEntry("b".getBytes()));
        Bytes fromBytes = WindowStoreUtils.toBinaryKey((Object)"a", (long)0L, (int)0, this.stateSerdes);
        Bytes toBytes = WindowStoreUtils.toBinaryKey((Object)"a", (long)100L, (int)0, this.stateSerdes);
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(this.windowStoreKvPairs.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(fromBytes), SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(toBytes));
        MergedSortedCacheWindowStoreIterator iterator = new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator);
        MatcherAssert.assertThat((Object)iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)0L));
        iterator.next();
        MatcherAssert.assertThat((Object)iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)10L));
        iterator.close();
    }
}

