/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractKeyValueStoreTest;
import org.junit.Assert;
import org.junit.Test;

public class InMemoryKeyValueLoggedStoreTest
extends AbstractKeyValueStoreTest {
    @Override
    protected <K, V> KeyValueStore<K, V> createKeyValueStore(ProcessorContext context, Class<K> keyClass, Class<V> valueClass, boolean useContextSerdes) {
        StateStoreSupplier supplier = useContextSerdes ? Stores.create((String)"my-store").withKeys(context.keySerde()).withValues(context.valueSerde()).inMemory().enableLogging(Collections.singletonMap("retention.ms", "1000")).build() : Stores.create((String)"my-store").withKeys(keyClass).withValues(valueClass).inMemory().enableLogging(Collections.singletonMap("retention.ms", "1000")).build();
        KeyValueStore store = (KeyValueStore)supplier.get();
        store.init(context, (StateStore)store);
        return store;
    }

    @Test
    public void shouldPutAll() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)1, (Object)"1"));
        entries.add(new KeyValue((Object)2, (Object)"2"));
        this.store.putAll(entries);
        Assert.assertEquals((Object)this.store.get((Object)1), (Object)"1");
        Assert.assertEquals((Object)this.store.get((Object)2), (Object)"2");
    }
}

