/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeLoggingKeyValueStoreTest {
    private MockProcessorContext context;
    private final InMemoryKeyValueStore<Bytes, byte[]> inner = new InMemoryKeyValueStore("kv", Serdes.Bytes(), Serdes.ByteArray());
    private final Serde<String> keySerde = Serdes.String();
    private final Serde<String> valueSerde = Serdes.String();
    private final ChangeLoggingKeyValueStore<String, String> store = new ChangeLoggingKeyValueStore(this.inner, this.keySerde, this.valueSerde);
    private final Map sent = new HashMap();
    private final String hi = "hi";
    private final Bytes hiBytes = Bytes.wrap((byte[])"hi".getBytes());
    private final String there = "there";
    private final byte[] thereBytes = "there".getBytes();
    private final String hello = "hello";
    private final String world = "world";

    @Before
    public void before() {
        NoOpRecordCollector collector = new NoOpRecordCollector(){

            @Override
            public <K, V> void send(String topic, K key, V value, Integer partition, Long timestamp, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
                ChangeLoggingKeyValueStoreTest.this.sent.put(key, value);
            }
        };
        this.context = new MockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), collector, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetrics)new MockStreamsMetrics(new Metrics())));
        this.context.setTime(0L);
        this.store.init((ProcessorContext)this.context, this.store);
    }

    @After
    public void after() {
        this.context.close();
        this.store.close();
    }

    @Test
    public void shouldWriteKeyValueBytesToInnerStoreOnPut() {
        this.store.put((Object)"hi", (Object)"there");
        MatcherAssert.assertThat((Object)this.deserializedValueFromInner("hi"), (Matcher)CoreMatchers.equalTo((Object)"there"));
    }

    @Test
    public void shouldLogChangeOnPut() {
        this.store.put((Object)"hi", (Object)"there");
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hiBytes)), (Matcher)CoreMatchers.equalTo((Object)this.thereBytes));
    }

    @Test
    public void shouldWriteAllKeyValueToInnerStoreOnPutAll() {
        this.store.putAll(Arrays.asList(KeyValue.pair((Object)"hello", (Object)"world"), KeyValue.pair((Object)"hi", (Object)"there")));
        MatcherAssert.assertThat((Object)this.deserializedValueFromInner("hello"), (Matcher)CoreMatchers.equalTo((Object)"world"));
        MatcherAssert.assertThat((Object)this.deserializedValueFromInner("hi"), (Matcher)CoreMatchers.equalTo((Object)"there"));
    }

    @Test
    public void shouldLogChangesOnPutAll() {
        this.store.putAll(Arrays.asList(KeyValue.pair((Object)"hi", (Object)"there"), KeyValue.pair((Object)"hello", (Object)"world")));
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hiBytes)), (Matcher)CoreMatchers.equalTo((Object)this.thereBytes));
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(Bytes.wrap((byte[])"hello".getBytes()))), (Matcher)CoreMatchers.equalTo((Object)"world".getBytes()));
    }

    @Test
    public void shouldPutNullOnDelete() {
        this.store.put((Object)"hi", (Object)"there");
        this.store.delete((Object)"hi");
        MatcherAssert.assertThat((Object)this.inner.get((Object)this.hiBytes), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldReturnOldValueOnDelete() {
        this.store.put((Object)"hi", (Object)"there");
        MatcherAssert.assertThat((Object)this.store.delete((Object)"hi"), (Matcher)CoreMatchers.equalTo((Object)"there"));
    }

    @Test
    public void shouldReturnNullOnDeleteIfNoOldValue() {
        MatcherAssert.assertThat((Object)this.store.delete((Object)"hi"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldLogKeyNullOnDelete() {
        this.store.put((Object)"hi", (Object)"there");
        this.store.delete((Object)"hi");
        MatcherAssert.assertThat(this.sent.get("hi"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldWriteToInnerOnPutIfAbsentNoPreviousValue() {
        this.store.putIfAbsent((Object)"hi", (Object)"there");
        MatcherAssert.assertThat((Object)this.inner.get((Object)this.hiBytes), (Matcher)CoreMatchers.equalTo((Object)this.thereBytes));
    }

    @Test
    public void shouldNotWriteToInnerOnPutIfAbsentWhenValueForKeyExists() {
        this.store.put((Object)"hi", (Object)"there");
        this.store.putIfAbsent((Object)"hi", (Object)"world");
        MatcherAssert.assertThat((Object)this.inner.get((Object)this.hiBytes), (Matcher)CoreMatchers.equalTo((Object)this.thereBytes));
    }

    @Test
    public void shouldWriteToChangelogOnPutIfAbsentWhenNoPreviousValue() {
        this.store.putIfAbsent((Object)"hi", (Object)"there");
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hiBytes)), (Matcher)CoreMatchers.equalTo((Object)this.thereBytes));
    }

    @Test
    public void shouldNotWriteToChangeLogOnPutIfAbsentWhenValueForKeyExists() {
        this.store.put((Object)"hi", (Object)"there");
        this.store.putIfAbsent((Object)"hi", (Object)"world");
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hiBytes)), (Matcher)CoreMatchers.equalTo((Object)this.thereBytes));
    }

    @Test
    public void shouldReturnCurrentValueOnPutIfAbsent() {
        this.store.put((Object)"hi", (Object)"there");
        MatcherAssert.assertThat((Object)this.store.putIfAbsent((Object)"hi", (Object)"world"), (Matcher)CoreMatchers.equalTo((Object)"there"));
    }

    @Test
    public void shouldReturnNullOnPutIfAbsentWhenNoPreviousValue() {
        MatcherAssert.assertThat((Object)this.store.putIfAbsent((Object)"hi", (Object)"there"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldQueryRange() {
        this.store.put((Object)"hello", (Object)"world");
        this.store.put((Object)"hi", (Object)"there");
        this.store.put((Object)"zooom", (Object)"home");
        KeyValueIterator range = this.store.range((Object)"hello", (Object)"hi");
        MatcherAssert.assertThat((Object)range.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)"hello", (Object)"world")));
        MatcherAssert.assertThat((Object)range.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)"hi", (Object)"there")));
        Assert.assertFalse((boolean)range.hasNext());
    }

    @Test
    public void shouldReturnAllKeyValues() {
        this.store.put((Object)"hello", (Object)"world");
        this.store.put((Object)"hi", (Object)"there");
        String zooom = "zooom";
        String home = "home";
        this.store.put((Object)"zooom", (Object)"home");
        KeyValueIterator all = this.store.all();
        MatcherAssert.assertThat((Object)all.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)"hello", (Object)"world")));
        MatcherAssert.assertThat((Object)all.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)"hi", (Object)"there")));
        MatcherAssert.assertThat((Object)all.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)"zooom", (Object)"home")));
        Assert.assertFalse((boolean)all.hasNext());
    }

    @Test
    public void shouldReturnValueOnGetWhenExists() {
        this.store.put((Object)"hello", (Object)"world");
        MatcherAssert.assertThat((Object)this.store.get((Object)"hello"), (Matcher)CoreMatchers.equalTo((Object)"world"));
    }

    @Test
    public void shouldReturnNullOnGetWhenDoesntExist() {
        MatcherAssert.assertThat((Object)this.store.get((Object)"hello"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldReturnInnerStoreName() {
        MatcherAssert.assertThat((Object)this.store.name(), (Matcher)CoreMatchers.equalTo((Object)"kv"));
    }

    private String deserializedValueFromInner(String key) {
        return (String)this.valueSerde.deserializer().deserialize("blah", (byte[])this.inner.get((Object)Bytes.wrap((byte[])key.getBytes())));
    }
}

