/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.KeyValueStoreTestDriver;
import org.apache.kafka.test.MockProcessorContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractKeyValueStoreTest {
    protected MockProcessorContext context;
    protected KeyValueStore<Integer, String> store;
    protected KeyValueStoreTestDriver<Integer, String> driver;

    protected abstract <K, V> KeyValueStore<K, V> createKeyValueStore(ProcessorContext var1, Class<K> var2, Class<V> var3, boolean var4);

    @Before
    public void before() {
        this.driver = KeyValueStoreTestDriver.create(Integer.class, String.class);
        this.context = (MockProcessorContext)this.driver.context();
        this.context.setTime(10L);
        this.store = this.createKeyValueStore((ProcessorContext)this.context, Integer.class, String.class, false);
    }

    @After
    public void after() {
        this.store.close();
        this.context.close();
        this.driver.clear();
    }

    @Test
    public void testPutGetRange() {
        KeyValue entry;
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        Assert.assertEquals((long)5L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((Object)"zero", (Object)this.store.get((Object)0));
        Assert.assertEquals((Object)"one", (Object)this.store.get((Object)1));
        Assert.assertEquals((Object)"two", (Object)this.store.get((Object)2));
        Assert.assertNull((Object)this.store.get((Object)3));
        Assert.assertEquals((Object)"four", (Object)this.store.get((Object)4));
        Assert.assertEquals((Object)"five", (Object)this.store.get((Object)5));
        this.store.delete((Object)5);
        this.store.flush();
        Assert.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assert.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assert.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assert.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assert.assertEquals(null, (Object)this.driver.flushedEntryStored(5));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(0));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(1));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(2));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(4));
        Assert.assertEquals((Object)true, (Object)this.driver.flushedEntryRemoved(5));
        try (KeyValueIterator iter = this.store.range((Object)2, (Object)4);){
            while (iter.hasNext()) {
                entry = (KeyValue)iter.next();
                if (((Integer)entry.key).equals(2)) {
                    Assert.assertEquals((Object)"two", (Object)entry.value);
                    continue;
                }
                if (((Integer)entry.key).equals(4)) {
                    Assert.assertEquals((Object)"four", (Object)entry.value);
                    continue;
                }
                Assert.fail((String)("Unexpected entry: " + entry));
            }
        }
        iter = this.store.range((Object)2, (Object)6);
        var2_2 = null;
        try {
            while (iter.hasNext()) {
                entry = (KeyValue)iter.next();
                if (((Integer)entry.key).equals(2)) {
                    Assert.assertEquals((Object)"two", (Object)entry.value);
                    continue;
                }
                if (((Integer)entry.key).equals(4)) {
                    Assert.assertEquals((Object)"four", (Object)entry.value);
                    continue;
                }
                Assert.fail((String)("Unexpected entry: " + entry));
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iter != null) {
                if (var2_2 != null) {
                    try {
                        iter.close();
                    }
                    catch (Throwable x2) {
                        var2_2.addSuppressed(x2);
                    }
                } else {
                    iter.close();
                }
            }
        }
    }

    @Test
    public void testPutGetRangeWithDefaultSerdes() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        Assert.assertEquals((long)5L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((Object)"zero", (Object)this.store.get((Object)0));
        Assert.assertEquals((Object)"one", (Object)this.store.get((Object)1));
        Assert.assertEquals((Object)"two", (Object)this.store.get((Object)2));
        Assert.assertNull((Object)this.store.get((Object)3));
        Assert.assertEquals((Object)"four", (Object)this.store.get((Object)4));
        Assert.assertEquals((Object)"five", (Object)this.store.get((Object)5));
        this.store.delete((Object)5);
        this.store.flush();
        Assert.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assert.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assert.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assert.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assert.assertEquals(null, (Object)this.driver.flushedEntryStored(5));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(0));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(1));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(2));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(4));
        Assert.assertEquals((Object)true, (Object)this.driver.flushedEntryRemoved(5));
    }

    @Test
    public void testRestore() {
        this.store.close();
        this.driver.addEntryToRestoreLog(0, "zero");
        this.driver.addEntryToRestoreLog(1, "one");
        this.driver.addEntryToRestoreLog(2, "two");
        this.driver.addEntryToRestoreLog(3, "three");
        this.store = this.createKeyValueStore(this.driver.context(), Integer.class, String.class, false);
        this.context.restore(this.store.name(), this.driver.restoredEntries());
        Assert.assertEquals((long)0L, (long)this.driver.checkForRestoredEntries(this.store));
        Assert.assertEquals((long)4L, (long)this.driver.sizeOf(this.store));
    }

    @Test
    public void testRestoreWithDefaultSerdes() {
        this.store.close();
        this.driver.addEntryToRestoreLog(0, "zero");
        this.driver.addEntryToRestoreLog(1, "one");
        this.driver.addEntryToRestoreLog(2, "two");
        this.driver.addEntryToRestoreLog(3, "three");
        this.store = this.createKeyValueStore(this.driver.context(), Integer.class, String.class, true);
        this.context.restore(this.store.name(), this.driver.restoredEntries());
        Assert.assertEquals((long)0L, (long)this.driver.checkForRestoredEntries(this.store));
        Assert.assertEquals((long)4L, (long)this.driver.sizeOf(this.store));
    }

    @Test
    public void testPutIfAbsent() {
        Assert.assertNull((Object)this.store.putIfAbsent((Object)0, (Object)"zero"));
        Assert.assertNull((Object)this.store.putIfAbsent((Object)1, (Object)"one"));
        Assert.assertNull((Object)this.store.putIfAbsent((Object)2, (Object)"two"));
        Assert.assertNull((Object)this.store.putIfAbsent((Object)4, (Object)"four"));
        Assert.assertEquals((Object)"four", (Object)this.store.putIfAbsent((Object)4, (Object)"unexpected value"));
        Assert.assertEquals((long)4L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((Object)"zero", (Object)this.store.get((Object)0));
        Assert.assertEquals((Object)"one", (Object)this.store.get((Object)1));
        Assert.assertEquals((Object)"two", (Object)this.store.get((Object)2));
        Assert.assertNull((Object)this.store.get((Object)3));
        Assert.assertEquals((Object)"four", (Object)this.store.get((Object)4));
        this.store.flush();
        Assert.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assert.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assert.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assert.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(0));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(1));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(2));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(4));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnPutNullKey() {
        this.store.put(null, (Object)"anyValue");
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutNullValue() {
        this.store.put((Object)1, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnPutIfAbsentNullKey() {
        this.store.putIfAbsent(null, (Object)"anyValue");
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutIfAbsentNullValue() {
        this.store.putIfAbsent((Object)1, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnPutAllNullKey() {
        this.store.putAll(Collections.singletonList(new KeyValue(null, (Object)"anyValue")));
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutAllNullKey() {
        this.store.putAll(Collections.singletonList(new KeyValue((Object)1, null)));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnDeleteNullKey() {
        this.store.delete(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnGetNullKey() {
        this.store.get(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRangeNullFromKey() {
        this.store.range(null, (Object)2);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRangeNullToKey() {
        this.store.range((Object)2, null);
    }

    @Test
    public void testSize() {
        Assert.assertEquals((String)"A newly created store should have no entries", (long)0L, (long)this.store.approximateNumEntries());
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        this.store.flush();
        Assert.assertEquals((long)5L, (long)this.store.approximateNumEntries());
    }
}

