/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentInfo;
import org.junit.Assert;
import org.junit.Test;

public class AssignmentInfoTest {
    @Test
    public void testEncodeDecode() {
        List<TaskId> activeTasks = Arrays.asList(new TaskId(0, 0), new TaskId(0, 0), new TaskId(0, 1), new TaskId(1, 0));
        HashMap<TaskId, Set> standbyTasks = new HashMap<TaskId, Set>();
        standbyTasks.put(new TaskId(1, 1), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1", 1), new TopicPartition("t2", 1)}));
        standbyTasks.put(new TaskId(2, 0), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t3", 0), new TopicPartition("t3", 0)}));
        AssignmentInfo info = new AssignmentInfo(activeTasks, standbyTasks, new HashMap());
        AssignmentInfo decoded = AssignmentInfo.decode((ByteBuffer)info.encode());
        Assert.assertEquals((Object)info, (Object)decoded);
    }

    @Test
    public void shouldDecodePreviousVersion() throws IOException {
        List<TaskId> activeTasks = Arrays.asList(new TaskId(0, 0), new TaskId(0, 0), new TaskId(0, 1), new TaskId(1, 0));
        HashMap<TaskId, Set> standbyTasks = new HashMap<TaskId, Set>();
        standbyTasks.put(new TaskId(1, 1), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1", 1), new TopicPartition("t2", 1)}));
        standbyTasks.put(new TaskId(2, 0), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t3", 0), new TopicPartition("t3", 0)}));
        AssignmentInfo oldVersion = new AssignmentInfo(1, activeTasks, standbyTasks, null);
        AssignmentInfo decoded = AssignmentInfo.decode((ByteBuffer)this.encodeV1(oldVersion));
        Assert.assertEquals((Object)oldVersion.activeTasks, (Object)decoded.activeTasks);
        Assert.assertEquals((Object)oldVersion.standbyTasks, (Object)decoded.standbyTasks);
        Assert.assertEquals((long)0L, (long)decoded.partitionsByHost.size());
        Assert.assertEquals((long)1L, (long)decoded.version);
    }

    private ByteBuffer encodeV1(AssignmentInfo oldVersion) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(oldVersion.version);
        out.writeInt(oldVersion.activeTasks.size());
        for (TaskId taskId : oldVersion.activeTasks) {
            taskId.writeTo(out);
        }
        out.writeInt(oldVersion.standbyTasks.size());
        for (Map.Entry entry : oldVersion.standbyTasks.entrySet()) {
            TaskId id = (TaskId)entry.getKey();
            id.writeTo(out);
            Set partitions = (Set)entry.getValue();
            out.writeInt(partitions.size());
            for (TopicPartition partition : partitions) {
                out.writeUTF(partition.topic());
                out.writeInt(partition.partition());
            }
        }
        out.flush();
        out.close();
        return ByteBuffer.wrap(baos.toByteArray());
    }
}

