/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.StreamsMetricsImpl;
import org.junit.Assert;
import org.junit.Test;

public class StreamsMetricsImplTest {
    @Test(expected=NullPointerException.class)
    public void testNullMetrics() {
        String groupName = "doesNotMatter";
        HashMap tags = new HashMap();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(null, groupName, tags);
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveNullSensor() {
        String groupName = "doesNotMatter";
        HashMap tags = new HashMap();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), groupName, tags);
        streamsMetrics.removeSensor(null);
    }

    @Test
    public void testRemoveSensor() {
        String groupName = "doesNotMatter";
        String sensorName = "sensor1";
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        HashMap tags = new HashMap();
        Metrics metrics = new Metrics();
        Map initialMetrics = Collections.unmodifiableMap(new LinkedHashMap(metrics.metrics()));
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, groupName, tags);
        Sensor sensor1 = streamsMetrics.addSensor(sensorName, Sensor.RecordingLevel.DEBUG);
        streamsMetrics.removeSensor(sensor1);
        Assert.assertEquals(initialMetrics, (Object)metrics.metrics());
        Sensor sensor1a = streamsMetrics.addSensor(sensorName, Sensor.RecordingLevel.DEBUG, new Sensor[]{sensor1});
        streamsMetrics.removeSensor(sensor1a);
        Assert.assertEquals(initialMetrics, (Object)metrics.metrics());
        Sensor sensor2 = streamsMetrics.addLatencyAndThroughputSensor(scope, entity, operation, Sensor.RecordingLevel.DEBUG, new String[0]);
        streamsMetrics.removeSensor(sensor2);
        Assert.assertEquals(initialMetrics, (Object)metrics.metrics());
        Sensor sensor3 = streamsMetrics.addThroughputSensor(scope, entity, operation, Sensor.RecordingLevel.DEBUG, new String[0]);
        streamsMetrics.removeSensor(sensor3);
        Assert.assertEquals(initialMetrics, (Object)metrics.metrics());
        Assert.assertEquals(Collections.emptyMap(), (Object)streamsMetrics.parentSensors);
    }

    @Test
    public void testLatencyMetrics() {
        String groupName = "doesNotMatter";
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        HashMap tags = new HashMap();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), groupName, tags);
        Sensor sensor1 = streamsMetrics.addLatencyAndThroughputSensor(scope, entity, operation, Sensor.RecordingLevel.DEBUG, new String[0]);
        Map metrics = streamsMetrics.metrics();
        int meterMetricsCount = 2;
        int otherMetricsCount = 4;
        Assert.assertEquals((long)(meterMetricsCount * 2 + otherMetricsCount + 1), (long)metrics.size());
        streamsMetrics.removeSensor(sensor1);
        metrics = streamsMetrics.metrics();
        Assert.assertEquals((long)metrics.size(), (long)1L);
    }

    @Test
    public void testThroughputMetrics() {
        String groupName = "doesNotMatter";
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        HashMap tags = new HashMap();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), groupName, tags);
        Sensor sensor1 = streamsMetrics.addThroughputSensor(scope, entity, operation, Sensor.RecordingLevel.DEBUG, new String[0]);
        Map metrics = streamsMetrics.metrics();
        int meterMetricsCount = 2;
        Assert.assertEquals((long)(meterMetricsCount * 2 + 1), (long)metrics.size());
        streamsMetrics.removeSensor(sensor1);
        metrics = streamsMetrics.metrics();
        Assert.assertEquals((long)metrics.size(), (long)1L);
    }
}

