/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.StreamsKafkaClient;
import org.apache.kafka.test.MockTimestampExtractor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InternalTopicManagerTest {
    private final String topic = "test_topic";
    private final String userEndPoint = "localhost:2171";
    private MockStreamKafkaClient streamsKafkaClient;
    private final Time time = new MockTime();

    @Before
    public void init() {
        StreamsConfig config = new StreamsConfig((Map)this.configProps());
        this.streamsKafkaClient = new MockStreamKafkaClient(config);
    }

    @After
    public void shutdown() throws IOException {
        this.streamsKafkaClient.close();
    }

    @Test
    public void shouldReturnCorrectPartitionCounts() {
        InternalTopicManager internalTopicManager = new InternalTopicManager((StreamsKafkaClient)this.streamsKafkaClient, 1, InternalTopicManager.WINDOW_CHANGE_LOG_ADDITIONAL_RETENTION_DEFAULT.longValue(), this.time);
        Assert.assertEquals(Collections.singletonMap("test_topic", 1), (Object)internalTopicManager.getNumPartitions(Collections.singleton("test_topic")));
    }

    @Test
    public void shouldCreateRequiredTopics() {
        InternalTopicManager internalTopicManager = new InternalTopicManager((StreamsKafkaClient)this.streamsKafkaClient, 1, InternalTopicManager.WINDOW_CHANGE_LOG_ADDITIONAL_RETENTION_DEFAULT.longValue(), this.time);
        internalTopicManager.makeReady(Collections.singletonMap(new InternalTopicConfig("test_topic", Collections.singleton(InternalTopicConfig.CleanupPolicy.compact), null), 1));
    }

    @Test
    public void shouldNotCreateTopicIfExistsWithDifferentPartitions() {
        InternalTopicManager internalTopicManager = new InternalTopicManager((StreamsKafkaClient)this.streamsKafkaClient, 1, InternalTopicManager.WINDOW_CHANGE_LOG_ADDITIONAL_RETENTION_DEFAULT.longValue(), this.time);
        boolean exceptionWasThrown = false;
        try {
            internalTopicManager.makeReady(Collections.singletonMap(new InternalTopicConfig("test_topic", Collections.singleton(InternalTopicConfig.CleanupPolicy.compact), null), 2));
        }
        catch (StreamsException e) {
            exceptionWasThrown = true;
        }
        Assert.assertTrue((boolean)exceptionWasThrown);
    }

    @Test
    public void shouldNotThrowExceptionIfExistsWithDifferentReplication() {
        InternalTopicManager internalTopicManager = new InternalTopicManager((StreamsKafkaClient)this.streamsKafkaClient, 2, InternalTopicManager.WINDOW_CHANGE_LOG_ADDITIONAL_RETENTION_DEFAULT.longValue(), this.time);
        internalTopicManager.makeReady(Collections.singletonMap(new InternalTopicConfig("test_topic", Collections.singleton(InternalTopicConfig.CleanupPolicy.compact), null), 1));
        InternalTopicManager internalTopicManager2 = new InternalTopicManager((StreamsKafkaClient)this.streamsKafkaClient, 1, InternalTopicManager.WINDOW_CHANGE_LOG_ADDITIONAL_RETENTION_DEFAULT.longValue(), this.time);
        try {
            internalTopicManager2.makeReady(Collections.singletonMap(new InternalTopicConfig("test_topic", Collections.singleton(InternalTopicConfig.CleanupPolicy.compact), null), 1));
        }
        catch (StreamsException e) {
            Assert.fail((String)"did not expect an exception since topic is already there.");
        }
    }

    @Test
    public void shouldNotThrowExceptionForEmptyTopicMap() {
        InternalTopicManager internalTopicManager = new InternalTopicManager((StreamsKafkaClient)this.streamsKafkaClient, 1, InternalTopicManager.WINDOW_CHANGE_LOG_ADDITIONAL_RETENTION_DEFAULT.longValue(), this.time);
        internalTopicManager.makeReady(Collections.EMPTY_MAP);
    }

    private Properties configProps() {
        return new Properties(){
            {
                this.setProperty("application.id", "Internal-Topic-ManagerTest");
                this.setProperty("bootstrap.servers", "localhost:2171");
                this.setProperty("buffered.records.per.partition", "3");
                this.setProperty("default.timestamp.extractor", MockTimestampExtractor.class.getName());
            }
        };
    }

    private class MockStreamKafkaClient
    extends StreamsKafkaClient {
        MockStreamKafkaClient(StreamsConfig streamsConfig) {
            super(StreamsKafkaClient.Config.fromStreamsConfig((StreamsConfig)streamsConfig), (KafkaClient)new MockClient((Time)new MockTime()), Collections.EMPTY_LIST);
        }

        public void createTopics(Map<InternalTopicConfig, Integer> topicsMap, int replicationFactor, long windowChangeLogAdditionalRetention, MetadataResponse metadata) {
        }

        public MetadataResponse fetchMetadata() {
            Node node = new Node(1, "host1", 1001);
            MetadataResponse.PartitionMetadata partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, 1, node, new ArrayList(), new ArrayList(), new ArrayList());
            MetadataResponse.TopicMetadata topicMetadata = new MetadataResponse.TopicMetadata(Errors.NONE, "test_topic", true, Collections.singletonList(partitionMetadata));
            MetadataResponse response = new MetadataResponse(Collections.singletonList(node), null, -1, Collections.singletonList(topicMetadata));
            return response;
        }
    }
}

