/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.internals.KStreamTransformValues;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KStreamTransformValuesTest {
    private String topicName = "topic";
    private final Serde<Integer> intSerde = Serdes.Integer();
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Test
    public void testTransform() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueTransformerSupplier<Number, Integer> valueTransformerSupplier = new ValueTransformerSupplier<Number, Integer>(){

            public ValueTransformer<Number, Integer> get() {
                return new ValueTransformer<Number, Integer>(){
                    private int total = 0;

                    public void init(ProcessorContext context) {
                    }

                    public Integer transform(Number value) {
                        this.total += value.intValue();
                        return this.total;
                    }

                    public Integer punctuate(long timestamp) {
                        return null;
                    }

                    public void close() {
                    }
                };
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream stream = builder.stream(this.topicName, Consumed.with(this.intSerde, this.intSerde));
        stream.transformValues((ValueTransformerSupplier)valueTransformerSupplier, new String[0]).process(processor, new String[0]);
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, expectedKey * 10);
        }
        Assert.assertEquals((long)4L, (long)processor.processed.size());
        String[] expected = new String[]{"1:10", "10:110", "100:1110", "1000:11110"};
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.processed.get(i));
        }
    }

    @Test
    public void shouldNotAllowValueTransformerToCallInternalProcessorContextMethods() {
        KStreamTransformValues transformValue = new KStreamTransformValues((ValueTransformerSupplier)new ValueTransformerSupplier<Integer, Integer>(){

            public ValueTransformer<Integer, Integer> get() {
                return new BadValueTransformer();
            }
        });
        Processor transformValueProcessor = transformValue.get();
        transformValueProcessor.init(null);
        try {
            transformValueProcessor.process(null, (Object)0);
            Assert.fail((String)"should not allow call to context.forward() within ValueTransformer");
        }
        catch (StreamsException e) {
            // empty catch block
        }
        try {
            transformValueProcessor.process(null, (Object)1);
            Assert.fail((String)"should not allow call to context.forward() within ValueTransformer");
        }
        catch (StreamsException e) {
            // empty catch block
        }
        try {
            transformValueProcessor.process(null, (Object)2);
            Assert.fail((String)"should not allow call to context.forward() within ValueTransformer");
        }
        catch (StreamsException e) {
            // empty catch block
        }
        try {
            transformValueProcessor.punctuate(0L);
            Assert.fail((String)"should not allow ValueTransformer#puntuate() to return not-null value");
        }
        catch (StreamsException streamsException) {
            // empty catch block
        }
    }

    private static final class BadValueTransformer
    implements ValueTransformer<Integer, Integer> {
        private ProcessorContext context;

        private BadValueTransformer() {
        }

        public void init(ProcessorContext context) {
            this.context = context;
        }

        public Integer transform(Integer value) {
            if (value == 0) {
                this.context.forward(null, null);
            }
            if (value == 1) {
                this.context.forward(null, null, null);
            }
            if (value == 2) {
                this.context.forward(null, null, 0);
            }
            throw new RuntimeException("Should never happen in this test");
        }

        public Integer punctuate(long timestamp) {
            return 1;
        }

        public void close() {
        }
    }
}

