/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KStreamMapTest {
    private String topicName = "topic";
    private final Serde<Integer> intSerde = Serdes.Integer();
    private final Serde<String> stringSerde = Serdes.String();
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Test
    public void testMap() {
        StreamsBuilder builder = new StreamsBuilder();
        KeyValueMapper<Integer, String, KeyValue<String, Integer>> mapper = new KeyValueMapper<Integer, String, KeyValue<String, Integer>>(){

            public KeyValue<String, Integer> apply(Integer key, String value) {
                return KeyValue.pair((Object)value, (Object)key);
            }
        };
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KStream stream = builder.stream(this.topicName, Consumed.with(this.intSerde, this.stringSerde));
        MockProcessorSupplier processor = new MockProcessorSupplier();
        stream.map((KeyValueMapper)mapper).process(processor, new String[0]);
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, "V" + expectedKey);
        }
        Assert.assertEquals((long)4L, (long)processor.processed.size());
        String[] expected = new String[]{"V0:0", "V1:1", "V2:2", "V3:3"};
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.processed.get(i));
        }
    }

    @Test
    public void testTypeVariance() {
        KeyValueMapper<Number, Object, KeyValue<Number, String>> stringify = new KeyValueMapper<Number, Object, KeyValue<Number, String>>(){

            public KeyValue<Number, String> apply(Number key, Object value) {
                return KeyValue.pair((Object)key, (Object)(key + ":" + value));
            }
        };
        new StreamsBuilder().stream("numbers").map((KeyValueMapper)stringify).to("strings");
    }
}

