/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.test.KStreamTestDriver;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KStreamForeachTest {
    private final String topicName = "topic";
    private final Serde<Integer> intSerde = Serdes.Integer();
    private final Serde<String> stringSerde = Serdes.String();
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Test
    public void testForeach() {
        List<KeyValue> inputRecords = Arrays.asList(new KeyValue((Object)0, (Object)"zero"), new KeyValue((Object)1, (Object)"one"), new KeyValue((Object)2, (Object)"two"), new KeyValue((Object)3, (Object)"three"));
        List<KeyValue> expectedRecords = Arrays.asList(new KeyValue((Object)0, (Object)"ZERO"), new KeyValue((Object)2, (Object)"ONE"), new KeyValue((Object)4, (Object)"TWO"), new KeyValue((Object)6, (Object)"THREE"));
        final ArrayList actualRecords = new ArrayList();
        ForeachAction<Integer, String> action = new ForeachAction<Integer, String>(){

            public void apply(Integer key, String value) {
                actualRecords.add(new KeyValue((Object)(key * 2), (Object)value.toUpperCase(Locale.ROOT)));
            }
        };
        StreamsBuilder builder = new StreamsBuilder();
        KStream stream = builder.stream("topic", Consumed.with(this.intSerde, this.stringSerde));
        stream.foreach((ForeachAction)action);
        this.driver.setUp(builder);
        for (KeyValue record : inputRecords) {
            this.driver.process("topic", record.key, record.value);
        }
        Assert.assertEquals((long)expectedRecords.size(), (long)actualRecords.size());
        for (int i = 0; i < expectedRecords.size(); ++i) {
            KeyValue expectedRecord = expectedRecords.get(i);
            KeyValue actualRecord = (KeyValue)actualRecords.get(i);
            Assert.assertEquals((Object)expectedRecord, (Object)actualRecord);
        }
    }

    @Test
    public void testTypeVariance() {
        ForeachAction<Number, Object> consume = new ForeachAction<Number, Object>(){

            public void apply(Number key, Object value) {
            }
        };
        new StreamsBuilder().stream("emptyTopic").foreach((ForeachAction)consume);
    }
}

