/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.streams.kstream.SessionWindows;
import org.junit.Assert;
import org.junit.Test;

public class SessionWindowsTest {
    @Test
    public void shouldSetWindowGap() {
        long anyGap = 42L;
        Assert.assertEquals((long)42L, (long)SessionWindows.with((long)42L).inactivityGap());
    }

    @Test
    public void shouldSetWindowRetentionTime() {
        long anyRetentionTime = 42L;
        Assert.assertEquals((long)42L, (long)SessionWindows.with((long)1L).until(42L).maintainMs());
    }

    @Test(expected=IllegalArgumentException.class)
    public void windowSizeMustNotBeNegative() {
        SessionWindows.with((long)-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void windowSizeMustNotBeZero() {
        SessionWindows.with((long)0L);
    }

    @Test
    public void retentionTimeShouldBeGapIfGapIsLargerThanDefaultRetentionTime() {
        long windowGap = 172800000L;
        Assert.assertEquals((long)172800000L, (long)SessionWindows.with((long)172800000L).maintainMs());
    }

    @Test
    public void retentionTimeMustNotBeNegative() {
        SessionWindows windowSpec = SessionWindows.with((long)42L);
        try {
            windowSpec.until(41L);
            Assert.fail((String)"should not accept retention time smaller than gap");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

