/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.streams.integration.AbstractResetIntegrationTest;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTest.class})
public class ResetIntegrationWithSslTest
extends AbstractResetIntegrationTest {
    private static Map<String, Object> sslConfig;
    @ClassRule
    public static final EmbeddedKafkaCluster CLUSTER;

    @AfterClass
    public static void globalCleanup() {
        ResetIntegrationWithSslTest.afterClassGlobalCleanup();
    }

    @Before
    public void before() throws Exception {
        this.beforePrepareTest();
    }

    @Override
    Properties getClientSslConfig() {
        Properties props = new Properties();
        props.put("bootstrap.servers", CLUSTER.bootstrapServers());
        props.put("ssl.truststore.location", sslConfig.get("ssl.truststore.location"));
        props.put("ssl.truststore.password", ((Password)sslConfig.get("ssl.truststore.password")).value());
        props.put("security.protocol", "SSL");
        return props;
    }

    @Override
    @Test
    public void testReprocessingFromScratchAfterResetWithoutIntermediateUserTopic() throws Exception {
        super.testReprocessingFromScratchAfterResetWithoutIntermediateUserTopic();
    }

    static {
        try {
            sslConfig = TestSslUtils.createSslConfig((boolean)false, (boolean)true, (Mode)Mode.SERVER, (File)TestUtils.tempFile(), (String)"testCert");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp(), (Object)-1L);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:0");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "SSL");
        props.putAll(sslConfig);
        cluster = CLUSTER = new EmbeddedKafkaCluster(1, props);
    }
}

