/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StreamsConfigTest {
    private final Properties props = new Properties();
    private StreamsConfig streamsConfig;

    @Before
    public void setUp() {
        this.props.put("application.id", "streams-config-test");
        this.props.put("bootstrap.servers", "localhost:9092");
        this.props.put("default.key.serde", Serdes.String().getClass().getName());
        this.props.put("default.value.serde", Serdes.String().getClass().getName());
        this.props.put("key.deserializer.encoding", "UTF8");
        this.props.put("value.deserializer.encoding", "UTF-16");
        this.streamsConfig = new StreamsConfig((Map)this.props);
    }

    @Test(expected=ConfigException.class)
    public void shouldThrowExceptionIfApplicationIdIsNotSet() {
        this.props.remove("application.id");
        new StreamsConfig((Map)this.props);
    }

    @Test(expected=ConfigException.class)
    public void shouldThrowExceptionIfBootstrapServersIsNotSet() {
        this.props.remove("bootstrap.servers");
        new StreamsConfig((Map)this.props);
    }

    @Test
    public void testGetProducerConfigs() {
        String clientId = "client";
        Map returnedProps = this.streamsConfig.getProducerConfigs("client");
        Assert.assertEquals(returnedProps.get("client.id"), (Object)"client-producer");
        Assert.assertEquals(returnedProps.get("linger.ms"), (Object)"100");
    }

    @Test
    public void testGetConsumerConfigs() {
        String groupId = "example-application";
        String clientId = "client";
        Map returnedProps = this.streamsConfig.getConsumerConfigs(null, "example-application", "client");
        Assert.assertEquals(returnedProps.get("client.id"), (Object)"client-consumer");
        Assert.assertEquals(returnedProps.get("group.id"), (Object)"example-application");
        Assert.assertEquals(returnedProps.get("max.poll.records"), (Object)"1000");
    }

    @Test
    public void testGetRestoreConsumerConfigs() {
        String clientId = "client";
        Map returnedProps = this.streamsConfig.getRestoreConsumerConfigs("client");
        Assert.assertEquals(returnedProps.get("client.id"), (Object)"client-restore-consumer");
        Assert.assertNull(returnedProps.get("group.id"));
    }

    @Test
    public void defaultSerdeShouldBeConfigured() {
        HashMap<String, String> serializerConfigs = new HashMap<String, String>();
        serializerConfigs.put("key.serializer.encoding", "UTF8");
        serializerConfigs.put("value.serializer.encoding", "UTF-16");
        Serializer serializer = Serdes.String().serializer();
        String str = "my string for testing";
        String topic = "my topic";
        serializer.configure(serializerConfigs, true);
        Assert.assertEquals((String)"Should get the original string after serialization and deserialization with the configured encoding", (Object)"my string for testing", (Object)this.streamsConfig.defaultKeySerde().deserializer().deserialize("my topic", serializer.serialize("my topic", (Object)"my string for testing")));
        serializer.configure(serializerConfigs, false);
        Assert.assertEquals((String)"Should get the original string after serialization and deserialization with the configured encoding", (Object)"my string for testing", (Object)this.streamsConfig.defaultValueSerde().deserializer().deserialize("my topic", serializer.serialize("my topic", (Object)"my string for testing")));
    }

    @Test
    public void shouldSupportMultipleBootstrapServers() {
        List<String> expectedBootstrapServers = Arrays.asList("broker1:9092", "broker2:9092");
        String bootstrapServersString = Utils.join(expectedBootstrapServers, (String)",");
        Properties props = new Properties();
        props.put("application.id", "irrelevant");
        props.put("bootstrap.servers", bootstrapServersString);
        StreamsConfig config = new StreamsConfig((Map)props);
        List actualBootstrapServers = config.getList("bootstrap.servers");
        Assert.assertEquals(expectedBootstrapServers, (Object)actualBootstrapServers);
    }

    @Test
    public void shouldSupportPrefixedConsumerConfigs() {
        this.props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "earliest");
        this.props.put(StreamsConfig.consumerPrefix((String)"metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Assert.assertEquals((Object)"earliest", consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportPrefixedRestoreConsumerConfigs() {
        this.props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "earliest");
        this.props.put(StreamsConfig.consumerPrefix((String)"metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("clientId");
        Assert.assertEquals((Object)"earliest", consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfConsumerConfig() {
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        this.props.put(StreamsConfig.consumerPrefix((String)"interceptor.statsd.host"), "host");
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Assert.assertEquals((Object)"host", consumerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfRestoreConsumerConfig() {
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        this.props.put(StreamsConfig.consumerPrefix((String)"interceptor.statsd.host"), "host");
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("clientId");
        Assert.assertEquals((Object)"host", consumerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfProducerConfig() {
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        this.props.put(StreamsConfig.producerPrefix((String)"interceptor.statsd.host"), "host");
        Map producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertEquals((Object)"host", producerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldSupportPrefixedProducerConfigs() {
        this.props.put(StreamsConfig.producerPrefix((String)"buffer.memory"), (Object)10);
        this.props.put(StreamsConfig.producerPrefix((String)"metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map configs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertEquals((Object)10, configs.get("buffer.memory"));
        Assert.assertEquals((Object)1, configs.get("metrics.num.samples"));
    }

    @Test
    public void shouldBeSupportNonPrefixedConsumerConfigs() {
        this.props.put("auto.offset.reset", "earliest");
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Assert.assertEquals((Object)"earliest", consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldBeSupportNonPrefixedRestoreConsumerConfigs() {
        this.props.put("auto.offset.reset", "earliest");
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("groupId");
        Assert.assertEquals((Object)"earliest", consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportNonPrefixedProducerConfigs() {
        this.props.put("buffer.memory", (Object)10);
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map configs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertEquals((Object)10, configs.get("buffer.memory"));
        Assert.assertEquals((Object)1, configs.get("metrics.num.samples"));
    }

    @Test
    public void shouldForwardCustomConfigsWithNoPrefixToAllClients() {
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        this.props.put("custom.property.host", "host");
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Map restoreConsumerConfigs = streamsConfig.getRestoreConsumerConfigs("clientId");
        Map producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertEquals((Object)"host", consumerConfigs.get("custom.property.host"));
        Assert.assertEquals((Object)"host", restoreConsumerConfigs.get("custom.property.host"));
        Assert.assertEquals((Object)"host", producerConfigs.get("custom.property.host"));
    }

    @Test
    public void shouldOverrideNonPrefixedCustomConfigsWithPrefixedConfigs() {
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        this.props.put("custom.property.host", "host0");
        this.props.put(StreamsConfig.consumerPrefix((String)"custom.property.host"), "host1");
        this.props.put(StreamsConfig.producerPrefix((String)"custom.property.host"), "host2");
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Map restoreConsumerConfigs = streamsConfig.getRestoreConsumerConfigs("clientId");
        Map producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertEquals((Object)"host1", consumerConfigs.get("custom.property.host"));
        Assert.assertEquals((Object)"host1", restoreConsumerConfigs.get("custom.property.host"));
        Assert.assertEquals((Object)"host2", producerConfigs.get("custom.property.host"));
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfKeySerdeConfigFails() {
        this.props.put("default.key.serde", MisconfiguredSerde.class);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        streamsConfig.defaultKeySerde();
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfValueSerdeConfigFails() {
        this.props.put("default.value.serde", MisconfiguredSerde.class);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        streamsConfig.defaultValueSerde();
    }

    @Test
    public void shouldOverrideStreamsDefaultConsumerConfigs() {
        this.props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "latest");
        this.props.put(StreamsConfig.consumerPrefix((String)"max.poll.records"), "10");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Assert.assertEquals((Object)"latest", consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)"10", consumerConfigs.get("max.poll.records"));
    }

    @Test
    public void shouldOverrideStreamsDefaultProducerConfigs() {
        this.props.put(StreamsConfig.producerPrefix((String)"linger.ms"), "10000");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertEquals((Object)"10000", producerConfigs.get("linger.ms"));
    }

    @Test
    public void shouldOverrideStreamsDefaultConsumerConifgsOnRestoreConsumer() {
        this.props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "latest");
        this.props.put(StreamsConfig.consumerPrefix((String)"max.poll.records"), "10");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("clientId");
        Assert.assertEquals((Object)"latest", consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)"10", consumerConfigs.get("max.poll.records"));
    }

    @Test
    public void shouldResetToDefaultIfConsumerAutoCommitIsOverridden() {
        this.props.put(StreamsConfig.consumerPrefix((String)"enable.auto.commit"), "true");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "a", "b");
        Assert.assertEquals((Object)"false", consumerConfigs.get("enable.auto.commit"));
    }

    @Test
    public void shouldResetToDefaultIfRestoreConsumerAutoCommitIsOverridden() {
        this.props.put(StreamsConfig.consumerPrefix((String)"enable.auto.commit"), "true");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("client");
        Assert.assertEquals((Object)"false", consumerConfigs.get("enable.auto.commit"));
    }

    @Test
    public void shouldSetInternalLeaveGroupOnCloseConfigToFalseInConsumer() {
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Assert.assertThat(consumerConfigs.get("internal.leave.group.on.close"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldAcceptAtLeastOnce() {
        this.props.put("processing.guarantee", "at_least_once");
        new StreamsConfig((Map)this.props);
    }

    @Test
    public void shouldAcceptExactlyOnce() {
        this.props.put("processing.guarantee", "exactly_once");
        new StreamsConfig((Map)this.props);
    }

    @Test(expected=ConfigException.class)
    public void shouldThrowExceptionIfNotAtLestOnceOrExactlyOnce() {
        this.props.put("processing.guarantee", "bad_value");
        new StreamsConfig((Map)this.props);
    }

    @Test
    public void shouldResetToDefaultIfConsumerIsolationLevelIsOverriddenIfEosEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.props.put("isolation.level", "anyValue");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Assert.assertThat((Object)((String)consumerConfigs.get("isolation.level")), (Matcher)IsEqual.equalTo((Object)IsolationLevel.READ_COMMITTED.name().toLowerCase(Locale.ROOT)));
    }

    @Test
    public void shouldAllowSettingConsumerIsolationLevelIfEosDisabled() {
        this.props.put("isolation.level", IsolationLevel.READ_UNCOMMITTED.name().toLowerCase(Locale.ROOT));
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientrId");
        Assert.assertThat((Object)((String)consumerConfigs.get("isolation.level")), (Matcher)IsEqual.equalTo((Object)IsolationLevel.READ_UNCOMMITTED.name().toLowerCase(Locale.ROOT)));
    }

    @Test
    public void shouldResetToDefaultIfProducerEnableIdempotenceIsOverriddenIfEosEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.props.put("enable.idempotence", "anyValue");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertTrue((boolean)((Boolean)producerConfigs.get("enable.idempotence")));
    }

    @Test
    public void shouldAllowSettingProducerEnableIdempotenceIfEosDisabled() {
        this.props.put("enable.idempotence", (Object)false);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertThat((Object)((Boolean)producerConfigs.get("enable.idempotence")), (Matcher)IsEqual.equalTo((Object)false));
    }

    @Test
    public void shouldResetToDefaultIfProducerMaxInFlightRequestPerConnectionsIsOverriddenIfEosEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.props.put("max.in.flight.requests.per.connection", "anyValue");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertThat((Object)((Integer)producerConfigs.get("max.in.flight.requests.per.connection")), (Matcher)IsEqual.equalTo((Object)1));
    }

    @Test
    public void shouldAllowSettingProducerMaxInFlightRequestPerConnectionsWhenEosDisabled() {
        this.props.put("max.in.flight.requests.per.connection", (Object)2);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertThat((Object)((Integer)producerConfigs.get("max.in.flight.requests.per.connection")), (Matcher)IsEqual.equalTo((Object)2));
    }

    @Test
    public void shouldSetDifferentDefaultsIfEosEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getConsumerConfigs(null, "groupId", "clientId");
        Map producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertThat((Object)((String)consumerConfigs.get("isolation.level")), (Matcher)IsEqual.equalTo((Object)IsolationLevel.READ_COMMITTED.name().toLowerCase(Locale.ROOT)));
        Assert.assertTrue((boolean)((Boolean)producerConfigs.get("enable.idempotence")));
        Assert.assertThat((Object)((Integer)producerConfigs.get("retries")), (Matcher)IsEqual.equalTo((Object)Integer.MAX_VALUE));
        Assert.assertThat((Object)((Integer)producerConfigs.get("max.in.flight.requests.per.connection")), (Matcher)IsEqual.equalTo((Object)1));
        Assert.assertThat((Object)streamsConfig.getLong("commit.interval.ms"), (Matcher)IsEqual.equalTo((Object)100L));
    }

    @Test
    public void shouldNotOverrideUserConfigRetriesIfExactlyOnceEnabled() {
        int numberOfRetries = 42;
        this.props.put("processing.guarantee", "exactly_once");
        this.props.put("retries", (Object)42);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertThat((Object)((Integer)producerConfigs.get("retries")), (Matcher)IsEqual.equalTo((Object)42));
    }

    @Test
    public void shouldNotOverrideUserConfigCommitIntervalMsIfExactlyOnceEnabled() {
        long commitIntervalMs = 73L;
        this.props.put("processing.guarantee", "exactly_once");
        this.props.put("commit.interval.ms", (Object)73L);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Assert.assertThat((Object)streamsConfig.getLong("commit.interval.ms"), (Matcher)IsEqual.equalTo((Object)73L));
    }

    @Test
    public void shouldBeBackwardsCompatibleWithDeprecatedConfigs() {
        Properties props = StreamsTestUtils.minimalStreamsConfig();
        props.put("key.serde", Serdes.Double().getClass());
        props.put("value.serde", Serdes.Double().getClass());
        props.put("timestamp.extractor", MockTimestampExtractor.class);
        StreamsConfig config = new StreamsConfig((Map)props);
        Assert.assertTrue((boolean)(config.defaultKeySerde() instanceof Serdes.DoubleSerde));
        Assert.assertTrue((boolean)(config.defaultValueSerde() instanceof Serdes.DoubleSerde));
        Assert.assertTrue((boolean)(config.defaultTimestampExtractor() instanceof MockTimestampExtractor));
    }

    @Test
    public void shouldUseNewConfigsWhenPresent() {
        Properties props = StreamsTestUtils.minimalStreamsConfig();
        props.put("default.key.serde", Serdes.Long().getClass());
        props.put("default.value.serde", Serdes.Long().getClass());
        props.put("default.timestamp.extractor", MockTimestampExtractor.class);
        StreamsConfig config = new StreamsConfig((Map)props);
        Assert.assertTrue((boolean)(config.defaultKeySerde() instanceof Serdes.LongSerde));
        Assert.assertTrue((boolean)(config.defaultValueSerde() instanceof Serdes.LongSerde));
        Assert.assertTrue((boolean)(config.defaultTimestampExtractor() instanceof MockTimestampExtractor));
    }

    @Test
    public void shouldUseCorrectDefaultsWhenNoneSpecified() {
        StreamsConfig config = new StreamsConfig((Map)StreamsTestUtils.minimalStreamsConfig());
        Assert.assertTrue((boolean)(config.defaultKeySerde() instanceof Serdes.ByteArraySerde));
        Assert.assertTrue((boolean)(config.defaultValueSerde() instanceof Serdes.ByteArraySerde));
        Assert.assertTrue((boolean)(config.defaultTimestampExtractor() instanceof FailOnInvalidTimestamp));
    }

    @Test
    public void shouldSpecifyCorrectKeySerdeClassOnErrorUsingDeprecatedConfigs() {
        Properties props = StreamsTestUtils.minimalStreamsConfig();
        props.put("key.serde", MisconfiguredSerde.class);
        StreamsConfig config = new StreamsConfig((Map)props);
        try {
            config.keySerde();
            Assert.fail((String)"Test should throw a StreamsException");
        }
        catch (StreamsException e) {
            Assert.assertEquals((Object)"Failed to configure key serde class org.apache.kafka.streams.StreamsConfigTest$MisconfiguredSerde", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldSpecifyCorrectKeySerdeClassOnError() {
        Properties props = StreamsTestUtils.minimalStreamsConfig();
        props.put("default.key.serde", MisconfiguredSerde.class);
        StreamsConfig config = new StreamsConfig((Map)props);
        try {
            config.keySerde();
            Assert.fail((String)"Test should throw a StreamsException");
        }
        catch (StreamsException e) {
            Assert.assertEquals((Object)"Failed to configure key serde class org.apache.kafka.streams.StreamsConfigTest$MisconfiguredSerde", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldSpecifyCorrectValueSerdeClassOnErrorUsingDeprecatedConfigs() {
        Properties props = StreamsTestUtils.minimalStreamsConfig();
        props.put("value.serde", MisconfiguredSerde.class);
        StreamsConfig config = new StreamsConfig((Map)props);
        try {
            config.valueSerde();
            Assert.fail((String)"Test should throw a StreamsException");
        }
        catch (StreamsException e) {
            Assert.assertEquals((Object)"Failed to configure value serde class org.apache.kafka.streams.StreamsConfigTest$MisconfiguredSerde", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldSpecifyCorrectValueSerdeClassOnError() {
        Properties props = StreamsTestUtils.minimalStreamsConfig();
        props.put("default.value.serde", MisconfiguredSerde.class);
        StreamsConfig config = new StreamsConfig((Map)props);
        try {
            config.valueSerde();
            Assert.fail((String)"Test should throw a StreamsException");
        }
        catch (StreamsException e) {
            Assert.assertEquals((Object)"Failed to configure value serde class org.apache.kafka.streams.StreamsConfigTest$MisconfiguredSerde", (Object)e.getMessage());
        }
    }

    public static class MockTimestampExtractor
    implements TimestampExtractor {
        public long extract(ConsumerRecord<Object, Object> record, long previousTimestamp) {
            return 0L;
        }
    }

    static class MisconfiguredSerde
    implements Serde {
        MisconfiguredSerde() {
        }

        public void configure(Map configs, boolean isKey) {
            throw new RuntimeException("boom");
        }

        public void close() {
        }

        public Serializer serializer() {
            return null;
        }

        public Deserializer deserializer() {
            return null;
        }
    }
}

