/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;

class SerializedKeyValueIterator<K, V>
implements KeyValueIterator<K, V> {
    private final KeyValueIterator<Bytes, byte[]> bytesIterator;
    private final StateSerdes<K, V> serdes;

    SerializedKeyValueIterator(KeyValueIterator<Bytes, byte[]> bytesIterator, StateSerdes<K, V> serdes) {
        this.bytesIterator = bytesIterator;
        this.serdes = serdes;
    }

    @Override
    public void close() {
        this.bytesIterator.close();
    }

    @Override
    public K peekNextKey() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Bytes bytes = this.bytesIterator.peekNextKey();
        return this.serdes.keyFrom(bytes.get());
    }

    @Override
    public boolean hasNext() {
        return this.bytesIterator.hasNext();
    }

    @Override
    public KeyValue<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        KeyValue next = (KeyValue)this.bytesIterator.next();
        return KeyValue.pair(this.serdes.keyFrom(((Bytes)next.key).get()), this.serdes.valueFrom((byte[])next.value));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported by SerializedKeyValueIterator");
    }
}

