/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;

class RocksDBWindowStore<K, V>
implements WindowStore<K, V> {
    private final SegmentedBytesStore bytesStore;
    private final boolean retainDuplicates;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private ProcessorContext context;
    private int seqnum = 0;
    private StateSerdes<K, V> serdes;

    static RocksDBWindowStore<Bytes, byte[]> bytesStore(SegmentedBytesStore inner, boolean retainDuplicates) {
        return new RocksDBWindowStore<Bytes, byte[]>(inner, Serdes.Bytes(), Serdes.ByteArray(), retainDuplicates);
    }

    RocksDBWindowStore(SegmentedBytesStore bytesStore, Serde<K> keySerde, Serde<V> valueSerde, boolean retainDuplicates) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.retainDuplicates = retainDuplicates;
        this.bytesStore = bytesStore;
    }

    @Override
    public String name() {
        return this.bytesStore.name();
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.context = context;
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.bytesStore.name()), (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.valueSerde == null ? context.valueSerde() : this.valueSerde));
        this.bytesStore.init(context, root);
    }

    @Override
    public boolean persistent() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.bytesStore.isOpen();
    }

    @Override
    public void flush() {
        this.bytesStore.flush();
    }

    @Override
    public void close() {
        this.bytesStore.close();
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, this.context.timestamp());
    }

    @Override
    public void put(K key, V value, long timestamp) {
        if (this.retainDuplicates) {
            this.seqnum = this.seqnum + 1 & Integer.MAX_VALUE;
        }
        this.bytesStore.put(Bytes.wrap((byte[])WindowStoreUtils.toBinaryKey(key, timestamp, this.seqnum, this.serdes)), this.serdes.rawValue(value));
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = this.bytesStore.fetch(Bytes.wrap((byte[])this.serdes.rawKey(key)), timeFrom, timeTo);
        return new TheWindowStoreIterator<V>(bytesIterator, this.serdes);
    }

    private static class TheWindowStoreIterator<V>
    implements WindowStoreIterator<V> {
        private final KeyValueIterator<Bytes, byte[]> actual;
        private final StateSerdes<?, V> serdes;

        TheWindowStoreIterator(KeyValueIterator<Bytes, byte[]> actual, StateSerdes<?, V> serdes) {
            this.actual = actual;
            this.serdes = serdes;
        }

        @Override
        public boolean hasNext() {
            return this.actual.hasNext();
        }

        @Override
        public KeyValue<Long, V> next() {
            if (!this.actual.hasNext()) {
                throw new NoSuchElementException();
            }
            KeyValue next = (KeyValue)this.actual.next();
            long timestamp = WindowStoreUtils.timestampFromBinaryKey(((Bytes)next.key).get());
            V value = this.serdes.valueFrom((byte[])next.value);
            return KeyValue.pair(timestamp, value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            this.actual.close();
        }

        @Override
        public Long peekNextKey() {
            if (!this.actual.hasNext()) {
                throw new NoSuchElementException();
            }
            return WindowStoreUtils.timestampFromBinaryKey(this.actual.peekNextKey().get());
        }
    }
}

