/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.SerializedKeyValueIterator;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class ChangeLoggingKeyValueStore<K, V>
extends WrappedStateStore.AbstractWrappedStateStore
implements KeyValueStore<K, V> {
    private final ChangeLoggingKeyValueBytesStore innerBytes;
    private final Serde keySerde;
    private final Serde valueSerde;
    private StateSerdes<K, V> serdes;

    ChangeLoggingKeyValueStore(KeyValueStore<Bytes, byte[]> bytesStore, Serde keySerde, Serde valueSerde) {
        this(new ChangeLoggingKeyValueBytesStore(bytesStore), keySerde, valueSerde);
    }

    private ChangeLoggingKeyValueStore(ChangeLoggingKeyValueBytesStore bytesStore, Serde keySerde, Serde valueSerde) {
        super(bytesStore);
        this.innerBytes = bytesStore;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.innerBytes.init(context, root);
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.innerBytes.name()), this.keySerde == null ? context.keySerde() : this.keySerde, this.valueSerde == null ? context.valueSerde() : this.valueSerde);
    }

    @Override
    public void put(K key, V value) {
        Bytes bytesKey = Bytes.wrap((byte[])this.serdes.rawKey(key));
        byte[] bytesValue = this.serdes.rawValue(value);
        this.innerBytes.put(bytesKey, bytesValue);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V v = this.get(key);
        if (v == null) {
            this.put(key, value);
        }
        return v;
    }

    @Override
    public void putAll(List<KeyValue<K, V>> entries) {
        ArrayList<KeyValue<Bytes, byte[]>> keyValues = new ArrayList<KeyValue<Bytes, byte[]>>();
        for (KeyValue<K, V> entry : entries) {
            keyValues.add(KeyValue.pair(Bytes.wrap((byte[])this.serdes.rawKey(entry.key)), this.serdes.rawValue(entry.value)));
        }
        this.innerBytes.putAll((List<KeyValue<Bytes, byte[]>>)keyValues);
    }

    @Override
    public V delete(K key) {
        byte[] oldValue = this.innerBytes.delete(Bytes.wrap((byte[])this.serdes.rawKey(key)));
        if (oldValue == null) {
            return null;
        }
        return this.serdes.valueFrom(oldValue);
    }

    @Override
    public V get(K key) {
        byte[] rawValue = this.innerBytes.get(Bytes.wrap((byte[])this.serdes.rawKey(key)));
        if (rawValue == null) {
            return null;
        }
        return this.serdes.valueFrom(rawValue);
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        return new SerializedKeyValueIterator<K, V>(this.innerBytes.range(Bytes.wrap((byte[])this.serdes.rawKey(from)), Bytes.wrap((byte[])this.serdes.rawKey(to))), this.serdes);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return new SerializedKeyValueIterator<K, V>(this.innerBytes.all(), this.serdes);
    }

    @Override
    public long approximateNumEntries() {
        return this.innerBytes.approximateNumEntries();
    }
}

