/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.state.internals.OffsetCheckpoint;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class OffsetCheckpointTest {
    private final String topic = "topic";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWrite() throws IOException {
        File f = TestUtils.tempFile();
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(f);
        try {
            HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
            offsets.put(new TopicPartition("topic", 0), 0L);
            offsets.put(new TopicPartition("topic", 1), 1L);
            offsets.put(new TopicPartition("topic", 2), 2L);
            checkpoint.write(offsets);
            Assert.assertEquals(offsets, (Object)checkpoint.read());
            checkpoint.delete();
            Assert.assertFalse((boolean)f.exists());
            offsets.put(new TopicPartition("topic", 3), 3L);
            checkpoint.write(offsets);
            Assert.assertEquals(offsets, (Object)checkpoint.read());
        }
        finally {
            checkpoint.delete();
        }
    }
}

