/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.streams.processor.internals.SourceNodeRecordDeserializer;
import org.junit.Assert;
import org.junit.Test;

public class SourceNodeRecordDeserializerTest {
    private final ConsumerRecord<byte[], byte[]> rawRecord = new ConsumerRecord("topic", 1, 1L, 10L, TimestampType.LOG_APPEND_TIME, 5L, 3, 5, (Object)new byte[0], (Object)new byte[0]);

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfKeyFailsToDeserialize() throws Exception {
        SourceNodeRecordDeserializer recordDeserializer = new SourceNodeRecordDeserializer((SourceNode)new TheSourceNode(true, false));
        recordDeserializer.deserialize(this.rawRecord);
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfKeyValueFailsToDeserialize() throws Exception {
        SourceNodeRecordDeserializer recordDeserializer = new SourceNodeRecordDeserializer((SourceNode)new TheSourceNode(false, true));
        recordDeserializer.deserialize(this.rawRecord);
    }

    @Test
    public void shouldReturnNewConsumerRecordWithDeserializedValueWhenNoExceptions() throws Exception {
        SourceNodeRecordDeserializer recordDeserializer = new SourceNodeRecordDeserializer((SourceNode)new TheSourceNode(false, false, "key", "value"));
        ConsumerRecord record = recordDeserializer.deserialize(this.rawRecord);
        Assert.assertEquals((Object)this.rawRecord.topic(), (Object)record.topic());
        Assert.assertEquals((long)this.rawRecord.partition(), (long)record.partition());
        Assert.assertEquals((long)this.rawRecord.offset(), (long)record.offset());
        Assert.assertEquals((long)this.rawRecord.checksum(), (long)record.checksum());
        Assert.assertEquals((Object)"key", (Object)record.key());
        Assert.assertEquals((Object)"value", (Object)record.value());
        Assert.assertEquals((long)this.rawRecord.timestamp(), (long)record.timestamp());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)record.timestampType());
    }

    static class TheSourceNode
    extends SourceNode {
        private final boolean keyThrowsException;
        private final boolean valueThrowsException;
        private final Object key;
        private final Object value;

        TheSourceNode(boolean keyThrowsException, boolean valueThrowsException) {
            this(keyThrowsException, valueThrowsException, null, null);
        }

        TheSourceNode(boolean keyThrowsException, boolean valueThrowsException, Object key, Object value) {
            super("", Collections.EMPTY_LIST, null, null);
            this.keyThrowsException = keyThrowsException;
            this.valueThrowsException = valueThrowsException;
            this.key = key;
            this.value = value;
        }

        public Object deserializeKey(String topic, byte[] data) {
            if (this.keyThrowsException) {
                throw new RuntimeException();
            }
            return this.key;
        }

        public Object deserializeValue(String topic, byte[] data) {
            if (this.valueThrowsException) {
                throw new RuntimeException();
            }
            return this.value;
        }
    }
}

