/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashMap;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class KStreamSelectKeyTest {
    private String topicName = "topic_key_select";
    private final Serde<Integer> integerSerde = Serdes.Integer();
    private final Serde<String> stringSerde = Serdes.String();
    private KStreamTestDriver driver;

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test
    public void testSelectKey() {
        KStreamBuilder builder = new KStreamBuilder();
        final HashMap<Integer, String> keyMap = new HashMap<Integer, String>();
        keyMap.put(1, "ONE");
        keyMap.put(2, "TWO");
        keyMap.put(3, "THREE");
        KeyValueMapper<Object, Number, String> selector = new KeyValueMapper<Object, Number, String>(){

            public String apply(Object key, Number value) {
                return (String)keyMap.get(value);
            }
        };
        String[] expected = new String[]{"ONE:1", "TWO:2", "THREE:3"};
        int[] expectedValues = new int[]{1, 2, 3};
        KStream stream = builder.stream(this.stringSerde, this.integerSerde, new String[]{this.topicName});
        MockProcessorSupplier processor = new MockProcessorSupplier();
        stream.selectKey((KeyValueMapper)selector).process(processor, new String[0]);
        this.driver = new KStreamTestDriver(builder);
        for (int expectedValue : expectedValues) {
            this.driver.process(this.topicName, null, expectedValue);
        }
        Assert.assertEquals((long)3L, (long)processor.processed.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.processed.get(i));
        }
    }

    @Test
    public void testTypeVariance() throws Exception {
        ForeachAction<Number, Object> consume = new ForeachAction<Number, Object>(){

            public void apply(Number key, Object value) {
            }
        };
        new KStreamBuilder().stream(new String[]{"empty"}).foreach((ForeachAction)consume);
    }
}

