/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import kafka.raft.KafkaRaftManager;
import kafka.tools.TerseFailure;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.shell.Commands;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.MetadataNodeManager;
import org.apache.kafka.shell.SnapshotFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataShell {
    private static final Logger log = LoggerFactory.getLogger(MetadataShell.class);
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private final SnapshotFileReader snapshotFileReader;
    private final MetadataNodeManager nodeManager;

    public MetadataShell(KafkaRaftManager<ApiMessageAndVersion> raftManager, SnapshotFileReader snapshotFileReader, MetadataNodeManager nodeManager) {
        this.raftManager = raftManager;
        this.snapshotFileReader = snapshotFileReader;
        this.nodeManager = nodeManager;
    }

    public void run(List<String> args) throws Exception {
        this.nodeManager.setup();
        if (this.raftManager != null) {
            this.raftManager.startup();
            this.raftManager.register((RaftClient.Listener)this.nodeManager.logListener());
        } else if (this.snapshotFileReader != null) {
            this.snapshotFileReader.startup();
        } else {
            throw new RuntimeException("Expected either a raft manager or snapshot reader");
        }
        if (args == null || args.isEmpty()) {
            System.out.println("Loading...");
            this.waitUntilCaughtUp();
            System.out.println("Starting...");
            try (InteractiveShell shell = new InteractiveShell(this.nodeManager);){
                shell.runMainLoop();
            }
        }
        this.waitUntilCaughtUp();
        Commands commands = new Commands(false);
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));){
            Commands.Handler handler = commands.parseCommand(args);
            handler.run(Optional.empty(), writer, this.nodeManager);
            writer.flush();
        }
    }

    public void close() throws Exception {
        if (this.raftManager != null) {
            this.raftManager.shutdown();
        }
        if (this.snapshotFileReader != null) {
            this.snapshotFileReader.close();
        }
        this.nodeManager.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"metadata-tool").defaultHelp(true).description("The Apache Kafka metadata tool");
        parser.addArgument(new String[]{"--snapshot", "-s"}).type(String.class).help("The snapshot file to read.");
        parser.addArgument(new String[]{"command"}).nargs("*").help("The command to run.");
        Namespace res = parser.parseArgsOrFail(args);
        try {
            Builder builder = new Builder();
            builder.setSnapshotPath(res.getString("snapshot"));
            Path tempDir = Files.createTempDirectory("MetadataShell", new FileAttribute[0]);
            Exit.addShutdownHook((String)"agent-shutdown-hook", () -> {
                log.debug("Removing temporary directory " + tempDir.toAbsolutePath().toString());
                try {
                    Utils.delete((File)tempDir.toFile());
                }
                catch (Exception e) {
                    log.error("Got exception while removing temporary directory " + tempDir.toAbsolutePath().toString());
                }
            });
            try (MetadataShell shell = builder.build();){
                shell.run(res.getList("command"));
            }
            Exit.exit((int)0);
        }
        catch (TerseFailure e) {
            System.err.println("Error: " + e.getMessage());
            Exit.exit((int)1);
        }
        catch (Throwable e) {
            System.err.println("Unexpected error: " + (e.getMessage() == null ? "" : e.getMessage()));
            e.printStackTrace(System.err);
            Exit.exit((int)1);
        }
    }

    void waitUntilCaughtUp() throws ExecutionException, InterruptedException {
        this.snapshotFileReader.caughtUpFuture().get();
    }

    public static class Builder {
        private String snapshotPath;

        public Builder setSnapshotPath(String snapshotPath) {
            this.snapshotPath = snapshotPath;
            return this;
        }

        public MetadataShell build() throws Exception {
            if (this.snapshotPath == null) {
                throw new RuntimeException("You must supply the log path via --snapshot");
            }
            MetadataNodeManager nodeManager = null;
            SnapshotFileReader reader = null;
            try {
                nodeManager = new MetadataNodeManager();
                reader = new SnapshotFileReader(this.snapshotPath, nodeManager.logListener());
                return new MetadataShell(null, reader, nodeManager);
            }
            catch (Throwable e) {
                log.error("Initialization error", e);
                if (reader != null) {
                    reader.close();
                }
                if (nodeManager != null) {
                    nodeManager.close();
                }
                throw e;
            }
        }
    }
}

