/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Objects;

public class ProducerIdsBlock {
    public static final int PRODUCER_ID_BLOCK_SIZE = 1000;
    public static final ProducerIdsBlock EMPTY = new ProducerIdsBlock(-1, 0L, 0);
    private final int brokerId;
    private final long producerIdStart;
    private final int producerIdLen;

    public ProducerIdsBlock(int brokerId, long producerIdStart, int producerIdLen) {
        this.brokerId = brokerId;
        this.producerIdStart = producerIdStart;
        this.producerIdLen = producerIdLen;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long producerIdStart() {
        return this.producerIdStart;
    }

    public int producerIdLen() {
        return this.producerIdLen;
    }

    public long producerIdEnd() {
        return this.producerIdStart + (long)this.producerIdLen - 1L;
    }

    public String toString() {
        return "ProducerIdsBlock{brokerId=" + this.brokerId + ", producerIdStart=" + this.producerIdStart + ", producerIdLen=" + this.producerIdLen + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProducerIdsBlock that = (ProducerIdsBlock)o;
        return this.brokerId == that.brokerId && this.producerIdStart == that.producerIdStart && this.producerIdLen == that.producerIdLen;
    }

    public int hashCode() {
        return Objects.hash(this.brokerId, this.producerIdStart, this.producerIdLen);
    }
}

