/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class ProducerIdsImage {
    public static final ProducerIdsImage EMPTY = new ProducerIdsImage(-1L);
    private final long nextProducerId;

    public ProducerIdsImage(long nextProducerId) {
        this.nextProducerId = nextProducerId;
    }

    public long highestSeenProducerId() {
        return this.nextProducerId;
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out) {
        if (this.nextProducerId >= 0L) {
            out.accept(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerId(-1).setBrokerEpoch(-1L).setNextProducerId(this.nextProducerId), 0)));
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProducerIdsImage)) {
            return false;
        }
        ProducerIdsImage other = (ProducerIdsImage)o;
        return this.nextProducerId == other.nextProducerId;
    }

    public int hashCode() {
        return Objects.hash(this.nextProducerId);
    }

    public String toString() {
        return "ProducerIdsImage(highestSeenProducerId=" + this.nextProducerId + ")";
    }

    public boolean isEmpty() {
        return this.nextProducerId < 0L;
    }
}

