/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.controller.ControllerMetrics;

public final class QuorumControllerMetrics
implements ControllerMetrics {
    private static final MetricName ACTIVE_CONTROLLER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "ActiveControllerCount");
    private static final MetricName EVENT_QUEUE_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueTimeMs");
    private static final MetricName EVENT_QUEUE_PROCESSING_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueProcessingTimeMs");
    private static final MetricName FENCED_BROKER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "FencedBrokerCount");
    private static final MetricName ACTIVE_BROKER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "ActiveBrokerCount");
    private static final MetricName GLOBAL_TOPIC_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "GlobalTopicCount");
    private static final MetricName GLOBAL_PARTITION_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "GlobalPartitionCount");
    private static final MetricName OFFLINE_PARTITION_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "OfflinePartitionsCount");
    private static final MetricName PREFERRED_REPLICA_IMBALANCE_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "PreferredReplicaImbalanceCount");
    private final MetricsRegistry registry;
    private volatile boolean active;
    private volatile int fencedBrokerCount;
    private volatile int activeBrokerCount;
    private volatile int globalTopicCount;
    private volatile int globalPartitionCount;
    private volatile int offlinePartitionCount;
    private volatile int preferredReplicaImbalanceCount;
    private final Gauge<Integer> activeControllerCount;
    private final Gauge<Integer> fencedBrokerCountGauge;
    private final Gauge<Integer> activeBrokerCountGauge;
    private final Gauge<Integer> globalPartitionCountGauge;
    private final Gauge<Integer> globalTopicCountGauge;
    private final Gauge<Integer> offlinePartitionCountGauge;
    private final Gauge<Integer> preferredReplicaImbalanceCountGauge;
    private final Histogram eventQueueTime;
    private final Histogram eventQueueProcessingTime;

    public QuorumControllerMetrics(MetricsRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
        this.active = false;
        this.fencedBrokerCount = 0;
        this.activeBrokerCount = 0;
        this.globalTopicCount = 0;
        this.globalPartitionCount = 0;
        this.offlinePartitionCount = 0;
        this.preferredReplicaImbalanceCount = 0;
        this.activeControllerCount = registry.newGauge(ACTIVE_CONTROLLER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.active ? 1 : 0;
            }
        });
        this.eventQueueTime = registry.newHistogram(EVENT_QUEUE_TIME_MS, true);
        this.eventQueueProcessingTime = registry.newHistogram(EVENT_QUEUE_PROCESSING_TIME_MS, true);
        this.fencedBrokerCountGauge = registry.newGauge(FENCED_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.fencedBrokerCount;
            }
        });
        this.activeBrokerCountGauge = registry.newGauge(ACTIVE_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.activeBrokerCount;
            }
        });
        this.globalTopicCountGauge = registry.newGauge(GLOBAL_TOPIC_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.globalTopicCount;
            }
        });
        this.globalPartitionCountGauge = registry.newGauge(GLOBAL_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.globalPartitionCount;
            }
        });
        this.offlinePartitionCountGauge = registry.newGauge(OFFLINE_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.offlinePartitionCount;
            }
        });
        this.preferredReplicaImbalanceCountGauge = registry.newGauge(PREFERRED_REPLICA_IMBALANCE_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.preferredReplicaImbalanceCount;
            }
        });
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean active() {
        return this.active;
    }

    @Override
    public void updateEventQueueTime(long durationMs) {
        this.eventQueueTime.update(durationMs);
    }

    @Override
    public void updateEventQueueProcessingTime(long durationMs) {
        this.eventQueueProcessingTime.update(durationMs);
    }

    @Override
    public void setFencedBrokerCount(int brokerCount) {
        this.fencedBrokerCount = brokerCount;
    }

    @Override
    public int fencedBrokerCount() {
        return this.fencedBrokerCount;
    }

    @Override
    public void setActiveBrokerCount(int brokerCount) {
        this.activeBrokerCount = brokerCount;
    }

    @Override
    public int activeBrokerCount() {
        return this.activeBrokerCount;
    }

    @Override
    public void setGlobalTopicsCount(int topicCount) {
        this.globalTopicCount = topicCount;
    }

    @Override
    public int globalTopicsCount() {
        return this.globalTopicCount;
    }

    @Override
    public void setGlobalPartitionCount(int partitionCount) {
        this.globalPartitionCount = partitionCount;
    }

    @Override
    public int globalPartitionCount() {
        return this.globalPartitionCount;
    }

    @Override
    public void setOfflinePartitionCount(int offlinePartitions) {
        this.offlinePartitionCount = offlinePartitions;
    }

    @Override
    public int offlinePartitionCount() {
        return this.offlinePartitionCount;
    }

    @Override
    public void setPreferredReplicaImbalanceCount(int replicaImbalances) {
        this.preferredReplicaImbalanceCount = replicaImbalances;
    }

    @Override
    public int preferredReplicaImbalanceCount() {
        return this.preferredReplicaImbalanceCount;
    }

    @Override
    public void close() {
        Arrays.asList(ACTIVE_CONTROLLER_COUNT, EVENT_QUEUE_TIME_MS, EVENT_QUEUE_PROCESSING_TIME_MS, GLOBAL_TOPIC_COUNT, GLOBAL_PARTITION_COUNT, OFFLINE_PARTITION_COUNT, PREFERRED_REPLICA_IMBALANCE_COUNT).forEach(arg_0 -> ((MetricsRegistry)this.registry).removeMetric(arg_0));
    }

    private static MetricName getMetricName(String type, String name) {
        String group = "kafka.controller";
        StringBuilder mbeanNameBuilder = new StringBuilder();
        mbeanNameBuilder.append("kafka.controller").append(":type=").append(type).append(",name=").append(name);
        return new MetricName("kafka.controller", type, name, null, mbeanNameBuilder.toString());
    }
}

