/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.SnapshottableHashTable;

public class TimelineHashMap<K, V>
extends SnapshottableHashTable<TimelineHashMapEntry<K, V>>
implements Map<K, V> {
    public TimelineHashMap(SnapshotRegistry snapshotRegistry, int expectedSize) {
        super(snapshotRegistry, expectedSize);
    }

    @Override
    public int size() {
        return this.size(Long.MAX_VALUE);
    }

    public int size(long epoch) {
        return this.snapshottableSize(epoch);
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty(Long.MAX_VALUE);
    }

    public boolean isEmpty(long epoch) {
        return this.snapshottableSize(epoch) == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(key, Long.MAX_VALUE);
    }

    public boolean containsKey(Object key, long epoch) {
        return this.snapshottableGet(new TimelineHashMapEntry<Object, Object>(key, null), epoch) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, V> e : this.entrySet()) {
            if (!value.equals(e.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.get(key, Long.MAX_VALUE);
    }

    public V get(Object key, long epoch) {
        Map.Entry entry = (Map.Entry)this.snapshottableGet(new TimelineHashMapEntry<Object, Object>(key, null), epoch);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        TimelineHashMapEntry<K, V> entry = new TimelineHashMapEntry<K, V>(key, value);
        TimelineHashMapEntry<K, V> prev = this.snapshottableAddOrReplace(entry);
        if (prev == null) {
            return null;
        }
        return prev.getValue();
    }

    @Override
    public V remove(Object key) {
        TimelineHashMapEntry result = (TimelineHashMapEntry)this.snapshottableRemove(new TimelineHashMapEntry<Object, Object>(key, null));
        return (V)(result == null ? null : result.value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.reset();
    }

    @Override
    public Set<K> keySet() {
        return this.keySet(Long.MAX_VALUE);
    }

    public Set<K> keySet(long epoch) {
        return new KeySet(epoch);
    }

    @Override
    public Collection<V> values() {
        return this.values(Long.MAX_VALUE);
    }

    public Collection<V> values(long epoch) {
        return new Values(epoch);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet(Long.MAX_VALUE);
    }

    public Set<Map.Entry<K, V>> entrySet(long epoch) {
        return new EntrySet(epoch);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        Iterator<Map.Entry<K, V>> iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            hash += iter.next().hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> entry : this.entrySet()) {
                if (m.get(entry.getKey()).equals(entry.getValue())) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        return true;
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<TimelineHashMapEntry<K, V>> iter;

        EntryIterator(long epoch) {
            this.iter = TimelineHashMap.this.snapshottableIterator(epoch);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final long epoch;

        EntrySet(long epoch) {
            this.epoch = epoch;
        }

        @Override
        public final int size() {
            return TimelineHashMap.this.size(this.epoch);
        }

        @Override
        public final void clear() {
            if (this.epoch != Long.MAX_VALUE) {
                throw new RuntimeException("can't modify snapshot");
            }
            TimelineHashMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.epoch);
        }

        @Override
        public final boolean contains(Object o) {
            return TimelineHashMap.this.snapshottableGet(o, this.epoch) != null;
        }

        @Override
        public final boolean remove(Object o) {
            if (this.epoch != Long.MAX_VALUE) {
                throw new RuntimeException("can't modify snapshot");
            }
            return TimelineHashMap.this.snapshottableRemove(new TimelineHashMapEntry<Object, Object>(o, null)) != null;
        }
    }

    final class ValueIterator
    implements Iterator<V> {
        private final Iterator<TimelineHashMapEntry<K, V>> iter;

        ValueIterator(long epoch) {
            this.iter = TimelineHashMap.this.snapshottableIterator(epoch);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public V next() {
            TimelineHashMapEntry next = this.iter.next();
            return next.getValue();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        private final long epoch;

        Values(long epoch) {
            this.epoch = epoch;
        }

        @Override
        public final int size() {
            return TimelineHashMap.this.size(this.epoch);
        }

        @Override
        public final void clear() {
            if (this.epoch != Long.MAX_VALUE) {
                throw new RuntimeException("can't modify snapshot");
            }
            TimelineHashMap.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(this.epoch);
        }

        @Override
        public final boolean contains(Object o) {
            return TimelineHashMap.this.containsKey(o, this.epoch);
        }
    }

    final class KeyIterator
    implements Iterator<K> {
        private final Iterator<TimelineHashMapEntry<K, V>> iter;

        KeyIterator(long epoch) {
            this.iter = TimelineHashMap.this.snapshottableIterator(epoch);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public K next() {
            TimelineHashMapEntry next = this.iter.next();
            return next.getKey();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        private final long epoch;

        KeySet(long epoch) {
            this.epoch = epoch;
        }

        @Override
        public final int size() {
            return TimelineHashMap.this.size(this.epoch);
        }

        @Override
        public final void clear() {
            if (this.epoch != Long.MAX_VALUE) {
                throw new RuntimeException("can't modify snapshot");
            }
            TimelineHashMap.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator(this.epoch);
        }

        @Override
        public final boolean contains(Object o) {
            return TimelineHashMap.this.containsKey(o, this.epoch);
        }

        @Override
        public final boolean remove(Object o) {
            if (this.epoch != Long.MAX_VALUE) {
                throw new RuntimeException("can't modify snapshot");
            }
            return TimelineHashMap.this.remove(o) != null;
        }
    }

    static class TimelineHashMapEntry<K, V>
    implements SnapshottableHashTable.ElementWithStartEpoch,
    Map.Entry<K, V> {
        private final K key;
        private final V value;
        private long startEpoch;

        TimelineHashMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
            this.startEpoch = Long.MAX_VALUE;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setStartEpoch(long startEpoch) {
            this.startEpoch = startEpoch;
        }

        @Override
        public long startEpoch() {
            return this.startEpoch;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof TimelineHashMapEntry)) {
                return false;
            }
            TimelineHashMapEntry other = (TimelineHashMapEntry)o;
            return this.key.equals(other.key);
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

