/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Objects;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;

public class ResultOrError<T> {
    private final ApiError error;
    private final T result;

    public ResultOrError(Errors error, String message) {
        this(new ApiError(error, message));
    }

    public ResultOrError(ApiError error) {
        Objects.requireNonNull(error);
        this.error = error;
        this.result = null;
    }

    public ResultOrError(T result) {
        this.error = null;
        this.result = result;
    }

    public static <T> ResultOrError<T> of(T result) {
        return new ResultOrError<T>(result);
    }

    public static <T> ResultOrError<T> of(ApiError error) {
        return new ResultOrError<T>(error);
    }

    public boolean isError() {
        return this.error != null;
    }

    public boolean isResult() {
        return this.error == null;
    }

    public ApiError error() {
        return this.error;
    }

    public T result() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        ResultOrError other = (ResultOrError)o;
        return Objects.equals(this.error, other.error) && Objects.equals(this.result, other.result);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.result);
    }

    public String toString() {
        if (this.error == null) {
            return "ResultOrError(" + this.result + ")";
        }
        return "ResultOrError(" + this.error + ")";
    }
}

