/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.ProduceRequestResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecordSendTest {
    private final TopicPartition topicPartition = new TopicPartition("test", 0);
    private final long baseOffset = 45L;
    private final int relOffset = 5;

    @Test
    public void testTimeout() throws Exception {
        ProduceRequestResult request = new ProduceRequestResult(this.topicPartition);
        FutureRecordMetadata future = new FutureRecordMetadata(request, 5, -1L, 0, 0, Time.SYSTEM);
        Assertions.assertFalse((boolean)future.isDone(), (String)"Request is not completed");
        try {
            future.get(5L, TimeUnit.MILLISECONDS);
            Assertions.fail((String)"Should have thrown exception.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        request.set(45L, -1L, null);
        request.done();
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((long)50L, (long)future.get().offset());
    }

    @Test
    public void testError() throws Exception {
        FutureRecordMetadata future = new FutureRecordMetadata(this.asyncRequest(45L, (RuntimeException)new CorruptRecordException(), 50L), 5, -1L, 0, 0, Time.SYSTEM);
        Assertions.assertThrows(ExecutionException.class, () -> ((FutureRecordMetadata)future).get());
    }

    @Test
    public void testBlocking() throws Exception {
        FutureRecordMetadata future = new FutureRecordMetadata(this.asyncRequest(45L, null, 50L), 5, -1L, 0, 0, Time.SYSTEM);
        Assertions.assertEquals((long)50L, (long)future.get().offset());
    }

    public ProduceRequestResult asyncRequest(final long baseOffset, final RuntimeException error, final long timeout) {
        final ProduceRequestResult request = new ProduceRequestResult(this.topicPartition);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(timeout);
                    if (error == null) {
                        request.set(baseOffset, -1L, null);
                    } else {
                        request.set(-1L, -1L, index -> error);
                    }
                    request.done();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        return request;
    }
}

