/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.replica;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.replica.PartitionView;
import org.apache.kafka.common.replica.RackAwareReplicaSelector;
import org.apache.kafka.common.replica.ReplicaView;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ReplicaSelectorTest {
    @Test
    public void testSameRackSelector() {
        TopicPartition tp = new TopicPartition("test", 0);
        List<ReplicaView> replicaViewSet = ReplicaSelectorTest.replicaInfoSet();
        ReplicaView leader = replicaViewSet.get(0);
        PartitionView partitionView = ReplicaSelectorTest.partitionInfo(new HashSet<ReplicaView>(replicaViewSet), leader);
        RackAwareReplicaSelector selector = new RackAwareReplicaSelector();
        Optional selected = selector.select(tp, ReplicaSelectorTest.metadata("rack-b"), partitionView);
        TestUtils.assertOptional(selected, replicaInfo -> {
            Assert.assertEquals((String)"Expect replica to be in rack-b", (Object)replicaInfo.endpoint().rack(), (Object)"rack-b");
            Assert.assertEquals((String)"Expected replica 3 since it is more caught-up", (long)replicaInfo.endpoint().id(), (long)3L);
        });
        selected = selector.select(tp, ReplicaSelectorTest.metadata("not-a-rack"), partitionView);
        TestUtils.assertOptional(selected, replicaInfo -> Assert.assertEquals((String)"Expect leader when we can't find any nodes in given rack", (Object)replicaInfo, (Object)leader));
        selected = selector.select(tp, ReplicaSelectorTest.metadata("rack-a"), partitionView);
        TestUtils.assertOptional(selected, replicaInfo -> {
            Assert.assertEquals((String)"Expect replica to be in rack-a", (Object)replicaInfo.endpoint().rack(), (Object)"rack-a");
            Assert.assertEquals((String)"Expect the leader since it's in rack-a", (Object)replicaInfo, (Object)leader);
        });
    }

    static List<ReplicaView> replicaInfoSet() {
        return Stream.of(ReplicaSelectorTest.replicaInfo(new Node(0, "host0", 1234, "rack-a"), 4L, 0L), ReplicaSelectorTest.replicaInfo(new Node(1, "host1", 1234, "rack-a"), 2L, 5L), ReplicaSelectorTest.replicaInfo(new Node(2, "host2", 1234, "rack-b"), 3L, 3L), ReplicaSelectorTest.replicaInfo(new Node(3, "host3", 1234, "rack-b"), 4L, 2L)).collect(Collectors.toList());
    }

    static ReplicaView replicaInfo(Node node, long logOffset, long timeSinceLastCaughtUpMs) {
        return new ReplicaView.DefaultReplicaView(node, logOffset, timeSinceLastCaughtUpMs);
    }

    static PartitionView partitionInfo(Set<ReplicaView> replicaViewSet, ReplicaView leader) {
        return new PartitionView.DefaultPartitionView(replicaViewSet, leader);
    }

    static ClientMetadata metadata(String rack) {
        return new ClientMetadata.DefaultClientMetadata(rack, "test-client", InetAddress.getLoopbackAddress(), KafkaPrincipal.ANONYMOUS, "TEST");
    }
}

