/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class AlterReplicaLogDirsRequestData
implements ApiMessage {
    AlterReplicaLogDirCollection dirs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public AlterReplicaLogDirsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AlterReplicaLogDirsRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public AlterReplicaLogDirsRequestData() {
        this.dirs = new AlterReplicaLogDirCollection(0);
    }

    public short apiKey() {
        return 34;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field dirs was serialized as null");
        }
        AlterReplicaLogDirCollection newCollection = new AlterReplicaLogDirCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new AlterReplicaLogDir(_readable, _version));
        }
        this.dirs = newCollection;
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.dirs.size());
        Iterator iterator = this.dirs.iterator();
        while (iterator.hasNext()) {
            AlterReplicaLogDir dirsElement = (AlterReplicaLogDir)iterator.next();
            dirsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        Object[] _nestedObjects = struct.getArray("dirs");
        this.dirs = new AlterReplicaLogDirCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.dirs.add(new AlterReplicaLogDir((Struct)nestedObject, _version));
        }
    }

    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.dirs.size()];
        int i = 0;
        Iterator iterator = this.dirs.iterator();
        while (iterator.hasNext()) {
            AlterReplicaLogDir element = (AlterReplicaLogDir)iterator.next();
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("dirs", (Object)_nestedObjects);
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += 4;
        Iterator iterator = this.dirs.iterator();
        while (iterator.hasNext()) {
            AlterReplicaLogDir dirsElement = (AlterReplicaLogDir)iterator.next();
            _arraySize += dirsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterReplicaLogDirsRequestData)) {
            return false;
        }
        AlterReplicaLogDirsRequestData other = (AlterReplicaLogDirsRequestData)obj;
        if (this.dirs == null ? other.dirs != null : !this.dirs.equals((Object)other.dirs)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.dirs == null ? 0 : this.dirs.hashCode());
        return hashCode;
    }

    public AlterReplicaLogDirsRequestData duplicate() {
        AlterReplicaLogDirsRequestData _duplicate = new AlterReplicaLogDirsRequestData();
        AlterReplicaLogDirCollection newDirs = new AlterReplicaLogDirCollection(this.dirs.size());
        Iterator iterator = this.dirs.iterator();
        while (iterator.hasNext()) {
            AlterReplicaLogDir _element = (AlterReplicaLogDir)iterator.next();
            newDirs.add(_element.duplicate());
        }
        _duplicate.dirs = newDirs;
        return _duplicate;
    }

    public String toString() {
        return "AlterReplicaLogDirsRequestData(dirs=" + MessageUtil.deepToString((Iterator)this.dirs.iterator()) + ")";
    }

    public AlterReplicaLogDirCollection dirs() {
        return this.dirs;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterReplicaLogDirsRequestData setDirs(AlterReplicaLogDirCollection v) {
        this.dirs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("dirs", (Type)new ArrayOf((Type)AlterReplicaLogDir.SCHEMA_0), "The alterations to make for each directory.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class AlterReplicaLogDirCollection
    extends ImplicitLinkedHashMultiCollection<AlterReplicaLogDir> {
        public AlterReplicaLogDirCollection() {
        }

        public AlterReplicaLogDirCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterReplicaLogDirCollection(Iterator<AlterReplicaLogDir> iterator) {
            super(iterator);
        }

        public AlterReplicaLogDir find(String path) {
            AlterReplicaLogDir _key = new AlterReplicaLogDir();
            _key.setPath(path);
            return (AlterReplicaLogDir)this.find(_key);
        }

        public List<AlterReplicaLogDir> findAll(String path) {
            AlterReplicaLogDir _key = new AlterReplicaLogDir();
            _key.setPath(path);
            return this.findAll(_key);
        }

        public AlterReplicaLogDirCollection duplicate() {
            AlterReplicaLogDirCollection _duplicate = new AlterReplicaLogDirCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDir _element = (AlterReplicaLogDir)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AlterReplicaLogDirTopicCollection
    extends ImplicitLinkedHashMultiCollection<AlterReplicaLogDirTopic> {
        public AlterReplicaLogDirTopicCollection() {
        }

        public AlterReplicaLogDirTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterReplicaLogDirTopicCollection(Iterator<AlterReplicaLogDirTopic> iterator) {
            super(iterator);
        }

        public AlterReplicaLogDirTopic find(String name) {
            AlterReplicaLogDirTopic _key = new AlterReplicaLogDirTopic();
            _key.setName(name);
            return (AlterReplicaLogDirTopic)this.find(_key);
        }

        public List<AlterReplicaLogDirTopic> findAll(String name) {
            AlterReplicaLogDirTopic _key = new AlterReplicaLogDirTopic();
            _key.setName(name);
            return this.findAll(_key);
        }

        public AlterReplicaLogDirTopicCollection duplicate() {
            AlterReplicaLogDirTopicCollection _duplicate = new AlterReplicaLogDirTopicCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDirTopic _element = (AlterReplicaLogDirTopic)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AlterReplicaLogDirTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public AlterReplicaLogDirTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public AlterReplicaLogDirTopic(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public AlterReplicaLogDirTopic() {
            this.name = "";
            this.partitions = new ArrayList<Integer>(0);
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterReplicaLogDirTopic");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString((int)length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement.intValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterReplicaLogDirTopic");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add((Integer)nestedObject);
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AlterReplicaLogDirTopic");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Integer[] _nestedObjects = new Integer[this.partitions.size()];
            int i = 0;
            for (Integer element : this.partitions) {
                _nestedObjects[i++] = element;
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterReplicaLogDirTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            _size += (_arraySize += this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AlterReplicaLogDirTopic)) {
                return false;
            }
            AlterReplicaLogDirTopic other = (AlterReplicaLogDirTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterReplicaLogDirTopic)) {
                return false;
            }
            AlterReplicaLogDirTopic other = (AlterReplicaLogDirTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public AlterReplicaLogDirTopic duplicate() {
            AlterReplicaLogDirTopic _duplicate = new AlterReplicaLogDirTopic();
            _duplicate.name = this.name;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "AlterReplicaLogDirTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterReplicaLogDirTopic setName(String v) {
            this.name = v;
            return this;
        }

        public AlterReplicaLogDirTopic setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)Type.INT32), "The partition indexes.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class AlterReplicaLogDir
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String path;
        AlterReplicaLogDirTopicCollection topics;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public AlterReplicaLogDir(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public AlterReplicaLogDir(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public AlterReplicaLogDir() {
            this.path = "";
            this.topics = new AlterReplicaLogDirTopicCollection(0);
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterReplicaLogDir");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field path was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field path had invalid length " + length);
            }
            this.path = _readable.readString((int)length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            AlterReplicaLogDirTopicCollection newCollection = new AlterReplicaLogDirTopicCollection(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new AlterReplicaLogDirTopic(_readable, _version));
            }
            this.topics = newCollection;
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.path);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.topics.size());
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                AlterReplicaLogDirTopic topicsElement = (AlterReplicaLogDirTopic)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterReplicaLogDir");
            }
            this._unknownTaggedFields = null;
            this.path = struct.getString("path");
            Object[] _nestedObjects = struct.getArray("topics");
            this.topics = new AlterReplicaLogDirTopicCollection(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.topics.add(new AlterReplicaLogDirTopic((Struct)nestedObject, _version));
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AlterReplicaLogDir");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("path", (Object)this.path);
            Struct[] _nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            Iterator iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDirTopic element = (AlterReplicaLogDirTopic)iterator.next();
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("topics", (Object)_nestedObjects);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterReplicaLogDir");
            }
            byte[] _stringBytes = this.path.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'path' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.path, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            Iterator iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDirTopic topicsElement = (AlterReplicaLogDirTopic)iterator.next();
                _arraySize += topicsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AlterReplicaLogDir)) {
                return false;
            }
            AlterReplicaLogDir other = (AlterReplicaLogDir)obj;
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterReplicaLogDir)) {
                return false;
            }
            AlterReplicaLogDir other = (AlterReplicaLogDir)obj;
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            if (this.topics == null ? other.topics != null : !this.topics.equals((Object)other.topics)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.path == null ? 0 : this.path.hashCode());
            return hashCode;
        }

        public AlterReplicaLogDir duplicate() {
            AlterReplicaLogDir _duplicate = new AlterReplicaLogDir();
            _duplicate.path = this.path;
            AlterReplicaLogDirTopicCollection newTopics = new AlterReplicaLogDirTopicCollection(this.topics.size());
            Iterator iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDirTopic _element = (AlterReplicaLogDirTopic)iterator.next();
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
            return _duplicate;
        }

        public String toString() {
            return "AlterReplicaLogDir(path=" + (this.path == null ? "null" : "'" + this.path.toString() + "'") + ", topics=" + MessageUtil.deepToString((Iterator)this.topics.iterator()) + ")";
        }

        public String path() {
            return this.path;
        }

        public AlterReplicaLogDirTopicCollection topics() {
            return this.topics;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterReplicaLogDir setPath(String v) {
            this.path = v;
            return this;
        }

        public AlterReplicaLogDir setTopics(AlterReplicaLogDirTopicCollection v) {
            this.topics = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("path", (Type)Type.STRING, "The absolute directory path."), new Field("topics", (Type)new ArrayOf((Type)AlterReplicaLogDirTopic.SCHEMA_0), "The topics to add to the directory.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

