/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.ApiVersion;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AdminClientUnitTestEnv;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeFeaturesOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.MemberAssignment;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.ReplicaInfo;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.SupportedVersionRange;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UserScramCredentialDeletion;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.clients.admin.UserScramCredentialsDescription;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.LogDirNotFoundException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListOffsetResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAdminClientTest {
    private static final Logger log = LoggerFactory.getLogger(KafkaAdminClientTest.class);
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);
    private static final AclBinding ACL1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
    private static final AclBinding ACL2 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic4", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.DENY));
    private static final AclBindingFilter FILTER1 = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.LITERAL), new AccessControlEntryFilter("User:ANONYMOUS", null, AclOperation.ANY, AclPermissionType.ANY));
    private static final AclBindingFilter FILTER2 = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.LITERAL), new AccessControlEntryFilter("User:bob", null, AclOperation.ANY, AclPermissionType.ANY));
    private static final AclBindingFilter UNKNOWN_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.UNKNOWN, null, PatternType.LITERAL), new AccessControlEntryFilter("User:bob", null, AclOperation.ANY, AclPermissionType.ANY));

    @Test
    public void testDefaultApiTimeoutAndRequestTimeoutConflicts() {
        AdminClientConfig config = KafkaAdminClientTest.newConfMap("default.api.timeout.ms", "500");
        KafkaException exception = (KafkaException)Assert.assertThrows(KafkaException.class, () -> KafkaAdminClient.createInternal((AdminClientConfig)config, null));
        Assert.assertTrue((boolean)(exception.getCause() instanceof ConfigException));
    }

    @Test
    public void testGetOrCreateListValue() {
        HashMap map = new HashMap();
        List fooList = KafkaAdminClient.getOrCreateListValue(map, (Object)"foo");
        Assert.assertNotNull((Object)fooList);
        fooList.add("a");
        fooList.add("b");
        List fooList2 = KafkaAdminClient.getOrCreateListValue(map, (Object)"foo");
        Assert.assertEquals((Object)fooList, (Object)fooList2);
        Assert.assertTrue((boolean)fooList2.contains("a"));
        Assert.assertTrue((boolean)fooList2.contains("b"));
        List barList = KafkaAdminClient.getOrCreateListValue(map, (Object)"bar");
        Assert.assertNotNull((Object)barList);
        Assert.assertTrue((boolean)barList.isEmpty());
    }

    @Test
    public void testCalcTimeoutMsRemainingAsInt() {
        Assert.assertEquals((long)0L, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)1000L, (long)1000L));
        Assert.assertEquals((long)100L, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)1000L, (long)1100L));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)0L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)Long.MAX_VALUE, (long)0L));
    }

    @Test
    public void testPrettyPrintException() {
        Assert.assertEquals((Object)"Null exception.", (Object)KafkaAdminClient.prettyPrintException(null));
        Assert.assertEquals((Object)"TimeoutException", (Object)KafkaAdminClient.prettyPrintException((Throwable)new TimeoutException()));
        Assert.assertEquals((Object)"TimeoutException: The foobar timed out.", (Object)KafkaAdminClient.prettyPrintException((Throwable)new TimeoutException("The foobar timed out.")));
    }

    private static Map<String, Object> newStrMap(String ... vals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrap.servers", "localhost:8121");
        map.put("request.timeout.ms", "1000");
        if (vals.length % 2 != 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < vals.length; i += 2) {
            map.put(vals[i], vals[i + 1]);
        }
        return map;
    }

    private static AdminClientConfig newConfMap(String ... vals) {
        return new AdminClientConfig(KafkaAdminClientTest.newStrMap(vals));
    }

    @Test
    public void testGenerateClientId() {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            String id = KafkaAdminClient.generateClientId((AdminClientConfig)KafkaAdminClientTest.newConfMap("client.id", ""));
            Assert.assertTrue((String)("Got duplicate id " + id), (!ids.contains(id) ? 1 : 0) != 0);
            ids.add(id);
        }
        Assert.assertEquals((Object)"myCustomId", (Object)KafkaAdminClient.generateClientId((AdminClientConfig)KafkaAdminClientTest.newConfMap("client.id", "myCustomId")));
    }

    private static Cluster mockCluster(int numNodes, int controllerIndex) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.put(i, new Node(i, "localhost", 8121 + i));
        }
        return new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(controllerIndex));
    }

    private static Cluster mockBootstrapCluster() {
        return Cluster.bootstrap((List)ClientUtils.parseAndValidateAddresses(Collections.singletonList("localhost:8121"), (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS));
    }

    private static AdminClientUnitTestEnv mockClientEnv(String ... configVals) {
        return new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(3, 0), configVals);
    }

    private static AdminClientUnitTestEnv mockClientEnv(Time time, String ... configVals) {
        return new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0), configVals);
    }

    @Test
    public void testCloseAdminClient() {
        AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);
        Throwable throwable = null;
        if (env != null) {
            if (throwable != null) {
                try {
                    env.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                env.close();
            }
        }
    }

    @Test(timeout=10000L)
    public void testCloseAdminClientInCallback() throws InterruptedException {
        MockTime time = new MockTime();
        AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0));
        ListTopicsResult result = env.adminClient().listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(1000)));
        KafkaFuture kafkaFuture = result.listings();
        Semaphore callbackCalled = new Semaphore(0);
        kafkaFuture.whenComplete((topicListings, throwable) -> {
            env.close();
            callbackCalled.release();
        });
        time.sleep(2000L);
        callbackCalled.acquire();
    }

    private static OffsetDeleteResponse prepareOffsetDeleteResponse(Errors error) {
        return new OffsetDeleteResponse(new OffsetDeleteResponseData().setErrorCode(error.code()).setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection()));
    }

    private static OffsetDeleteResponse prepareOffsetDeleteResponse(String topic, int partition, Errors error) {
        return new OffsetDeleteResponse(new OffsetDeleteResponseData().setErrorCode(Errors.NONE.code()).setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(Stream.of(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topic).setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(partition).setErrorCode(error.code())).iterator()))).collect(Collectors.toList()).iterator())));
    }

    private static OffsetCommitResponse prepareOffsetCommitResponse(TopicPartition tp, Errors error) {
        HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
        responseData.put(tp, error);
        return new OffsetCommitResponse(0, responseData);
    }

    private static CreateTopicsResponse prepareCreateTopicsResponse(String topicName, Errors error) {
        CreateTopicsResponseData data = new CreateTopicsResponseData();
        data.topics().add(new CreateTopicsResponseData.CreatableTopicResult().setName(topicName).setErrorCode(error.code()));
        return new CreateTopicsResponse(data);
    }

    public static CreateTopicsResponse prepareCreateTopicsResponse(int throttleTimeMs, CreateTopicsResponseData.CreatableTopicResult ... topics) {
        CreateTopicsResponseData data = new CreateTopicsResponseData().setThrottleTimeMs(throttleTimeMs).setTopics(new CreateTopicsResponseData.CreatableTopicResultCollection(Arrays.stream(topics).iterator()));
        return new CreateTopicsResponse(data);
    }

    public static CreateTopicsResponseData.CreatableTopicResult creatableTopicResult(String name, Errors error) {
        return new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(error.code());
    }

    public static DeleteTopicsResponse prepareDeleteTopicsResponse(int throttleTimeMs, DeleteTopicsResponseData.DeletableTopicResult ... topics) {
        DeleteTopicsResponseData data = new DeleteTopicsResponseData().setThrottleTimeMs(throttleTimeMs).setResponses(new DeleteTopicsResponseData.DeletableTopicResultCollection(Arrays.stream(topics).iterator()));
        return new DeleteTopicsResponse(data);
    }

    public static DeleteTopicsResponseData.DeletableTopicResult deletableTopicResult(String topicName, Errors error) {
        return new DeleteTopicsResponseData.DeletableTopicResult().setName(topicName).setErrorCode(error.code());
    }

    public static CreatePartitionsResponse prepareCreatePartitionsResponse(int throttleTimeMs, CreatePartitionsResponseData.CreatePartitionsTopicResult ... topics) {
        CreatePartitionsResponseData data = new CreatePartitionsResponseData().setThrottleTimeMs(throttleTimeMs).setResults(Arrays.asList(topics));
        return new CreatePartitionsResponse(data);
    }

    public static CreatePartitionsResponseData.CreatePartitionsTopicResult createPartitionsTopicResult(String name, Errors error) {
        return KafkaAdminClientTest.createPartitionsTopicResult(name, error, null);
    }

    public static CreatePartitionsResponseData.CreatePartitionsTopicResult createPartitionsTopicResult(String name, Errors error, String errorMessage) {
        return new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(name).setErrorCode(error.code()).setErrorMessage(errorMessage);
    }

    private static DeleteTopicsResponse prepareDeleteTopicsResponse(String topicName, Errors error) {
        DeleteTopicsResponseData data = new DeleteTopicsResponseData();
        data.responses().add(new DeleteTopicsResponseData.DeletableTopicResult().setName(topicName).setErrorCode(error.code()));
        return new DeleteTopicsResponse(data);
    }

    private static FindCoordinatorResponse prepareFindCoordinatorResponse(Errors error, Node node) {
        return FindCoordinatorResponse.prepareResponse((Errors)error, (Node)node);
    }

    private static MetadataResponse prepareMetadataResponse(Cluster cluster, Errors error) {
        return KafkaAdminClientTest.prepareMetadataResponse(cluster, error, error);
    }

    private static MetadataResponse prepareMetadataResponse(Cluster cluster, Errors topicError, Errors partitionError) {
        ArrayList<MetadataResponseData.MetadataResponseTopic> metadata = new ArrayList<MetadataResponseData.MetadataResponseTopic>();
        for (String topic : cluster.topics()) {
            ArrayList<MetadataResponseData.MetadataResponsePartition> pms = new ArrayList<MetadataResponseData.MetadataResponsePartition>();
            for (PartitionInfo pInfo : cluster.availablePartitionsForTopic(topic)) {
                MetadataResponseData.MetadataResponsePartition pm = new MetadataResponseData.MetadataResponsePartition().setErrorCode(partitionError.code()).setPartitionIndex(pInfo.partition()).setLeaderId(pInfo.leader().id()).setLeaderEpoch(234).setReplicaNodes(Arrays.stream(pInfo.replicas()).map(Node::id).collect(Collectors.toList())).setIsrNodes(Arrays.stream(pInfo.inSyncReplicas()).map(Node::id).collect(Collectors.toList())).setOfflineReplicas(Arrays.stream(pInfo.offlineReplicas()).map(Node::id).collect(Collectors.toList()));
                pms.add(pm);
            }
            MetadataResponseData.MetadataResponseTopic tm = new MetadataResponseData.MetadataResponseTopic().setErrorCode(topicError.code()).setName(topic).setIsInternal(false).setPartitions(pms);
            metadata.add(tm);
        }
        return MetadataResponse.prepareResponse((int)0, metadata, (Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), (int)Integer.MIN_VALUE);
    }

    private static DescribeGroupsResponseData prepareDescribeGroupsResponseData(String groupId, List<String> groupInstances, List<TopicPartition> topicPartitions) {
        ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
        List describedGroupMembers = groupInstances.stream().map(groupInstance -> DescribeGroupsResponse.groupMember((String)"", (String)groupInstance, (String)"clientId0", (String)"clientHost", (byte[])new byte[memberAssignment.remaining()], null)).collect(Collectors.toList());
        DescribeGroupsResponseData data = new DescribeGroupsResponseData();
        data.groups().add(DescribeGroupsResponse.groupMetadata((String)groupId, (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", describedGroupMembers, Collections.emptySet()));
        return data;
    }

    private static FeatureMetadata defaultFeatureMetadata() {
        return new FeatureMetadata(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)new FinalizedVersionRange(2, 3))}), Optional.of(1L), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)new SupportedVersionRange(1, 5))}));
    }

    private static Features<org.apache.kafka.common.feature.SupportedVersionRange> convertSupportedFeaturesMap(Map<String, SupportedVersionRange> features) {
        HashMap<String, org.apache.kafka.common.feature.SupportedVersionRange> featuresMap = new HashMap<String, org.apache.kafka.common.feature.SupportedVersionRange>();
        for (Map.Entry<String, SupportedVersionRange> entry : features.entrySet()) {
            SupportedVersionRange versionRange = entry.getValue();
            featuresMap.put(entry.getKey(), new org.apache.kafka.common.feature.SupportedVersionRange(versionRange.minVersion(), versionRange.maxVersion()));
        }
        return Features.supportedFeatures(featuresMap);
    }

    private static Features<org.apache.kafka.common.feature.FinalizedVersionRange> convertFinalizedFeaturesMap(Map<String, FinalizedVersionRange> features) {
        HashMap<String, org.apache.kafka.common.feature.FinalizedVersionRange> featuresMap = new HashMap<String, org.apache.kafka.common.feature.FinalizedVersionRange>();
        for (Map.Entry<String, FinalizedVersionRange> entry : features.entrySet()) {
            FinalizedVersionRange versionRange = entry.getValue();
            featuresMap.put(entry.getKey(), new org.apache.kafka.common.feature.FinalizedVersionRange(versionRange.minVersionLevel(), versionRange.maxVersionLevel()));
        }
        return Features.finalizedFeatures(featuresMap);
    }

    private static ApiVersionsResponse prepareApiVersionsResponseForDescribeFeatures(Errors error) {
        if (error == Errors.NONE) {
            return new ApiVersionsResponse(ApiVersionsResponse.createApiVersionsResponseData((int)ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE.throttleTimeMs(), (Errors)error, (ApiVersionsResponseData.ApiVersionsResponseKeyCollection)ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE.data().apiKeys(), KafkaAdminClientTest.convertSupportedFeaturesMap(KafkaAdminClientTest.defaultFeatureMetadata().supportedFeatures()), KafkaAdminClientTest.convertFinalizedFeaturesMap(KafkaAdminClientTest.defaultFeatureMetadata().finalizedFeatures()), (long)((Long)KafkaAdminClientTest.defaultFeatureMetadata().finalizedFeaturesEpoch().get())));
        }
        return new ApiVersionsResponse(new ApiVersionsResponseData().setThrottleTimeMs(ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE.throttleTimeMs()).setErrorCode(error.code()));
    }

    @Test
    public void testTimeoutWithoutMetadata() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, KafkaAdminClientTest.mockBootstrapCluster(), KafkaAdminClientTest.newStrMap("request.timeout.ms", "10"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(1000))).all();
            TestUtils.assertFutureError(future, TimeoutException.class);
        }
    }

    @Test
    public void testConnectionFailureOnMetadataUpdate() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockBootstrapCluster();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, cluster);){
            Cluster discoveredCluster = KafkaAdminClientTest.mockCluster(3, 0);
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, null, true);
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, (AbstractResponse)MetadataResponse.prepareResponse((Collection)discoveredCluster.nodes(), (String)discoveredCluster.clusterResource().clusterId(), (int)1, Collections.emptyList()));
            env.kafkaClient().prepareResponse(body -> body instanceof CreateTopicsRequest, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testUnreachableBootstrapServer() throws Exception {
        Cluster cluster = Cluster.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 8121)));
        Map<Node, Long> unreachableNodes = Collections.singletonMap(cluster.nodes().get(0), 200L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, cluster, AdminClientUnitTestEnv.clientConfigs(new String[0]), unreachableNodes);){
            Cluster discoveredCluster = KafkaAdminClientTest.mockCluster(3, 0);
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(body -> body instanceof MetadataRequest, (AbstractResponse)MetadataResponse.prepareResponse((Collection)discoveredCluster.nodes(), (String)discoveredCluster.clusterResource().clusterId(), (int)1, Collections.emptyList()));
            env.kafkaClient().prepareResponse(body -> body instanceof CreateTopicsRequest, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testPropagatedMetadataFetchException() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("bootstrap.servers", "localhost:8121", "request.timeout.ms", "10"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().createPendingAuthenticationError(env.cluster().nodeById(0), TimeUnit.DAYS.toMillis(1L));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(1000))).all();
            TestUtils.assertFutureError(future, SaslAuthenticationException.class);
        }
    }

    @Test
    public void testCreateTopics() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("myTopic"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testCreateTopicsPartialResponse() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("myTopic", "myTopic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            CreateTopicsResult topicsResult = env.adminClient().createTopics(Arrays.asList(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2))), new NewTopic("myTopic2", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000)));
            ((KafkaFuture)topicsResult.values().get("myTopic")).get();
            TestUtils.assertFutureThrows((Future)topicsResult.values().get("myTopic2"), ApiException.class);
        }
    }

    @Test
    public void testCreateTopicsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return body instanceof CreateTopicsRequest;
            }, null, true);
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return body instanceof CreateTopicsRequest;
            }, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting CreateTopics first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry CreateTopics call");
            time.sleep(retryBackoff);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assert.assertEquals((String)"CreateTopics retry did not await expected backoff", (long)retryBackoff, (long)actualRetryBackoff);
        }
    }

    @Test
    public void testCreateTopicsHandleNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)1, Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE), env.cluster().nodeById(1));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testCreateTopicsRetryThrottlingExceptionWhenEnabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.creatableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(0, KafkaAdminClientTest.creatableTopicResult("topic2", Errors.NONE)));
            CreateTopicsResult result = env.adminClient().createTopics(Arrays.asList(new NewTopic("topic1", 1, 1), new NewTopic("topic2", 1, 1), new NewTopic("topic3", 1, 1)), new CreateTopicsOptions().retryOnQuotaViolation(true));
            Assert.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            Assert.assertNull((Object)((KafkaFuture)result.values().get("topic2")).get());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    @Test
    public void testCreateTopicsRetryThrottlingExceptionWhenEnabledUntilRequestTimeOut() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "default.api.timeout.ms", String.valueOf(defaultApiTimeout));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.creatableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            CreateTopicsResult result = env.adminClient().createTopics(Arrays.asList(new NewTopic("topic1", 1, 1), new NewTopic("topic2", 1, 1), new NewTopic("topic3", 1, 1)), new CreateTopicsOptions().retryOnQuotaViolation(true));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting CreateTopics requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting next CreateTopics request");
            time.sleep(defaultApiTimeout + 1L);
            Assert.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows((Future)result.values().get("topic2"), ThrottlingQuotaExceededException.class);
            Assert.assertEquals((long)0L, (long)e.throttleTimeMs());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    @Test
    public void testCreateTopicsDontRetryThrottlingExceptionWhenDisabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.creatableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            CreateTopicsResult result = env.adminClient().createTopics(Arrays.asList(new NewTopic("topic1", 1, 1), new NewTopic("topic2", 1, 1), new NewTopic("topic3", 1, 1)), new CreateTopicsOptions().retryOnQuotaViolation(false));
            Assert.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows((Future)result.values().get("topic2"), ThrottlingQuotaExceededException.class);
            Assert.assertEquals((long)1000L, (long)e.throttleTimeMs());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    private MockClient.RequestMatcher expectCreateTopicsRequestWithTopics(String ... topics) {
        return body -> {
            if (body instanceof CreateTopicsRequest) {
                CreateTopicsRequest request = (CreateTopicsRequest)body;
                for (String topic : topics) {
                    if (request.data().topics().find(topic) != null) continue;
                    return false;
                }
                return topics.length == request.data().topics().size();
            }
            return false;
        };
    }

    @Test
    public void testDeleteTopics() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("myTopic"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().deleteTopics(Collections.singletonList("myTopic"), new DeleteTopicsOptions()).all();
            Assert.assertNull((Object)future.get());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("myTopic"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse("myTopic", Errors.TOPIC_DELETION_DISABLED));
            future = env.adminClient().deleteTopics(Collections.singletonList("myTopic"), new DeleteTopicsOptions()).all();
            TestUtils.assertFutureError(future, TopicDeletionDisabledException.class);
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("myTopic"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse("myTopic", Errors.UNKNOWN_TOPIC_OR_PARTITION));
            future = env.adminClient().deleteTopics(Collections.singletonList("myTopic"), new DeleteTopicsOptions()).all();
            TestUtils.assertFutureError(future, UnknownTopicOrPartitionException.class);
        }
    }

    @Test
    public void testDeleteTopicsPartialResponse() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("myTopic", "myOtherTopic"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("myTopic", Errors.NONE)));
            DeleteTopicsResult result = env.adminClient().deleteTopics(Arrays.asList("myTopic", "myOtherTopic"), new DeleteTopicsOptions());
            ((KafkaFuture)result.values().get("myTopic")).get();
            TestUtils.assertFutureThrows((Future)result.values().get("myOtherTopic"), ApiException.class);
        }
    }

    @Test
    public void testDeleteTopicsRetryThrottlingExceptionWhenEnabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(0, KafkaAdminClientTest.deletableTopicResult("topic2", Errors.NONE)));
            DeleteTopicsResult result = env.adminClient().deleteTopics(Arrays.asList("topic1", "topic2", "topic3"), new DeleteTopicsOptions().retryOnQuotaViolation(true));
            Assert.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            Assert.assertNull((Object)((KafkaFuture)result.values().get("topic2")).get());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    @Test
    public void testDeleteTopicsRetryThrottlingExceptionWhenEnabledUntilRequestTimeOut() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "default.api.timeout.ms", String.valueOf(defaultApiTimeout));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            DeleteTopicsResult result = env.adminClient().deleteTopics(Arrays.asList("topic1", "topic2", "topic3"), new DeleteTopicsOptions().retryOnQuotaViolation(true));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting DeleteTopics requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting next DeleteTopics request");
            time.sleep(defaultApiTimeout + 1L);
            Assert.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows((Future)result.values().get("topic2"), ThrottlingQuotaExceededException.class);
            Assert.assertEquals((long)0L, (long)e.throttleTimeMs());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    @Test
    public void testDeleteTopicsDontRetryThrottlingExceptionWhenDisabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            DeleteTopicsResult result = env.adminClient().deleteTopics(Arrays.asList("topic1", "topic2", "topic3"), new DeleteTopicsOptions().retryOnQuotaViolation(false));
            Assert.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows((Future)result.values().get("topic2"), ThrottlingQuotaExceededException.class);
            Assert.assertEquals((long)1000L, (long)e.throttleTimeMs());
            TestUtils.assertFutureError((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    private MockClient.RequestMatcher expectDeleteTopicsRequestWithTopics(String ... topics) {
        return body -> {
            if (body instanceof DeleteTopicsRequest) {
                DeleteTopicsRequest request = (DeleteTopicsRequest)body;
                return request.data().topicNames().equals(Arrays.asList(topics));
            }
            return false;
        };
    }

    @Test
    public void testInvalidTopicNames() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            List<String> sillyTopicNames = Arrays.asList("", null);
            Map deleteFutures = env.adminClient().deleteTopics(sillyTopicNames).values();
            for (String string : sillyTopicNames) {
                TestUtils.assertFutureError((Future)deleteFutures.get(string), InvalidTopicException.class);
            }
            Assert.assertEquals((long)0L, (long)env.kafkaClient().inFlightRequestCount());
            Map describeFutures = env.adminClient().describeTopics(sillyTopicNames).values();
            for (String string : sillyTopicNames) {
                TestUtils.assertFutureError((Future)describeFutures.get(string), InvalidTopicException.class);
            }
            Assert.assertEquals((long)0L, (long)env.kafkaClient().inFlightRequestCount());
            ArrayList<NewTopic> arrayList = new ArrayList<NewTopic>();
            for (String sillyTopicName : sillyTopicNames) {
                arrayList.add(new NewTopic(sillyTopicName, 1, 1));
            }
            Map map = env.adminClient().createTopics(arrayList).values();
            for (String sillyTopicName : sillyTopicNames) {
                TestUtils.assertFutureError((Future)map.get(sillyTopicName), InvalidTopicException.class);
            }
            Assert.assertEquals((long)0L, (long)env.kafkaClient().inFlightRequestCount());
        }
    }

    @Test
    public void testMetadataRetries() throws Exception {
        String topic = "topic";
        Cluster bootstrapCluster = Cluster.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 9999)));
        Cluster initializedCluster = KafkaAdminClientTest.mockCluster(3, 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, bootstrapCluster, KafkaAdminClientTest.newStrMap("bootstrap.servers", "localhost:9999", "default.api.timeout.ms", "10000000", "retries", "0"));){
            env.kafkaClient().prepareResponse(null, true);
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)initializedCluster.nodes(), (String)initializedCluster.clusterResource().clusterId(), (int)initializedCluster.controller().id(), Collections.emptyList()));
            Node leader = (Node)initializedCluster.nodes().get(0);
            MetadataResponse.PartitionMetadata partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, new TopicPartition(topic, 0), Optional.of(leader.id()), Optional.of(10), Collections.singletonList(leader.id()), Collections.singletonList(leader.id()), Collections.singletonList(leader.id()));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)initializedCluster.nodes(), (String)initializedCluster.clusterResource().clusterId(), (int)1, Collections.singletonList(new MetadataResponse.TopicMetadata(Errors.NONE, topic, false, Collections.singletonList(partitionMetadata), Integer.MIN_VALUE))));
            DescribeTopicsResult result = env.adminClient().describeTopics(Collections.singleton(topic));
            Map topicDescriptions = (Map)result.all().get();
            Assert.assertEquals((Object)leader, (Object)((TopicPartitionInfo)((TopicDescription)topicDescriptions.get(topic)).partitions().get(0)).leader());
            Assert.assertEquals(null, (Object)((TopicDescription)topicDescriptions.get(topic)).authorizedOperations());
        }
    }

    @Test
    public void testAdminClientApisAuthenticationFailure() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockBootstrapCluster();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, cluster, KafkaAdminClientTest.newStrMap("request.timeout.ms", "1000"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().createPendingAuthenticationError((Node)cluster.nodes().get(0), TimeUnit.DAYS.toMillis(1L));
            this.callAdminClientApisAndExpectAnAuthenticationError(env);
            this.callClientQuotasApisAndExpectAnAuthenticationError(env);
        }
    }

    private void callAdminClientApisAndExpectAnAuthenticationError(AdminClientUnitTestEnv env) throws InterruptedException {
        try {
            env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
        try {
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("my_topic", NewPartitions.increaseTo((int)3));
            counts.put("other_topic", NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(2), Arrays.asList(3))));
            env.adminClient().createPartitions(counts).all().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
        try {
            env.adminClient().createAcls(Arrays.asList(ACL1, ACL2)).all().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
        try {
            env.adminClient().describeAcls(FILTER1).values().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
        try {
            env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2)).all().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
        try {
            env.adminClient().describeConfigs(Collections.singleton(new ConfigResource(ConfigResource.Type.BROKER, "0"))).all().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
    }

    private void callClientQuotasApisAndExpectAnAuthenticationError(AdminClientUnitTestEnv env) throws InterruptedException {
        try {
            env.adminClient().describeClientQuotas(ClientQuotaFilter.all()).entities().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
        try {
            ClientQuotaEntity entity = new ClientQuotaEntity(Collections.singletonMap("user", "user"));
            ClientQuotaAlteration alteration = new ClientQuotaAlteration(entity, Arrays.asList(new ClientQuotaAlteration.Op("consumer_byte_rate", Double.valueOf(1000.0))));
            env.adminClient().alterClientQuotas(Arrays.asList(alteration)).all().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
    }

    @Test
    public void testDescribeAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(new DescribeAclsResponseData().setResources(DescribeAclsResponse.aclsResources(Arrays.asList(ACL1, ACL2)))));
            KafkaAdminClientTest.assertCollectionIs((Collection)env.adminClient().describeAcls(FILTER1).values().get(), ACL1, ACL2);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(new DescribeAclsResponseData()));
            Assert.assertTrue((boolean)((Collection)env.adminClient().describeAcls(FILTER2).values().get()).isEmpty());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(new DescribeAclsResponseData().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("Security is disabled")));
            TestUtils.assertFutureError(env.adminClient().describeAcls(FILTER2).values(), SecurityDisabledException.class);
            TestUtils.assertFutureError(env.adminClient().describeAcls(UNKNOWN_FILTER).values(), InvalidRequestException.class);
        }
    }

    @Test
    public void testCreateAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(new CreateAclsResponseData().setResults(Arrays.asList(new CreateAclsResponseData.AclCreationResult(), new CreateAclsResponseData.AclCreationResult()))));
            CreateAclsResult results = env.adminClient().createAcls(Arrays.asList(ACL1, ACL2));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1, ACL2);
            for (KafkaFuture future : results.values().values()) {
                future.get();
            }
            results.all().get();
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(new CreateAclsResponseData().setResults(Arrays.asList(new CreateAclsResponseData.AclCreationResult().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("Security is disabled"), new CreateAclsResponseData.AclCreationResult()))));
            results = env.adminClient().createAcls(Arrays.asList(ACL1, ACL2));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1, ACL2);
            TestUtils.assertFutureError((Future)results.values().get(ACL1), SecurityDisabledException.class);
            ((KafkaFuture)results.values().get(ACL2)).get();
            TestUtils.assertFutureError(results.all(), SecurityDisabledException.class);
        }
    }

    @Test
    public void testDeleteAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE), DeleteAclsResponse.matchingAcl((AclBinding)ACL2, (ApiError)ApiError.NONE))), new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("No security")))));
            DeleteAclsResult results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Map filterResults = results.values();
            DeleteAclsResult.FilterResults filter1Results = (DeleteAclsResult.FilterResults)((KafkaFuture)filterResults.get(FILTER1)).get();
            Assert.assertEquals(null, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(0)).exception());
            Assert.assertEquals((Object)ACL1, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(0)).binding());
            Assert.assertEquals(null, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(1)).exception());
            Assert.assertEquals((Object)ACL2, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(1)).binding());
            TestUtils.assertFutureError((Future)filterResults.get(FILTER2), SecurityDisabledException.class);
            TestUtils.assertFutureError(results.all(), SecurityDisabledException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE), new DeleteAclsResponseData.DeleteAclsMatchingAcl().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("No security"))), new DeleteAclsResponseData.DeleteAclsFilterResult()))));
            results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Assert.assertTrue((boolean)((DeleteAclsResult.FilterResults)((KafkaFuture)results.values().get(FILTER2)).get()).values().isEmpty());
            TestUtils.assertFutureError(results.all(), SecurityDisabledException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE))), new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL2, (ApiError)ApiError.NONE)))))));
            results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Collection deleted = (Collection)results.all().get();
            KafkaAdminClientTest.assertCollectionIs(deleted, ACL1, ACL2);
        }
    }

    @Test
    public void testElectLeaders() throws Exception {
        TopicPartition topic1 = new TopicPartition("topic", 0);
        TopicPartition topic2 = new TopicPartition("topic", 2);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            for (ElectionType electionType : ElectionType.values()) {
                env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
                ApiError value = ApiError.fromThrowable((Throwable)new ClusterAuthorizationException(null));
                ArrayList<ElectLeadersResponseData.ReplicaElectionResult> electionResults = new ArrayList<ElectLeadersResponseData.ReplicaElectionResult>();
                ElectLeadersResponseData.ReplicaElectionResult electionResult = new ElectLeadersResponseData.ReplicaElectionResult();
                electionResult.setTopic(topic1.topic());
                ElectLeadersResponseData.PartitionResult partition1Result = new ElectLeadersResponseData.PartitionResult();
                partition1Result.setPartitionId(topic1.partition());
                partition1Result.setErrorCode(value.error().code());
                partition1Result.setErrorMessage(value.message());
                electionResult.partitionResult().add(partition1Result);
                ElectLeadersResponseData.PartitionResult partition2Result = new ElectLeadersResponseData.PartitionResult();
                partition2Result.setPartitionId(topic2.partition());
                partition2Result.setErrorCode(value.error().code());
                partition2Result.setErrorMessage(value.message());
                electionResult.partitionResult().add(partition2Result);
                electionResults.add(electionResult);
                env.kafkaClient().prepareResponse((AbstractResponse)new ElectLeadersResponse(0, Errors.NONE.code(), electionResults));
                ElectLeadersResult results = env.adminClient().electLeaders(electionType, new HashSet<TopicPartition>(Arrays.asList(topic1, topic2)));
                Assert.assertEquals(((Throwable)((Optional)((Map)results.partitions().get()).get(topic2)).get()).getClass(), ClusterAuthorizationException.class);
                partition1Result.setErrorCode(ApiError.NONE.error().code());
                partition1Result.setErrorMessage(ApiError.NONE.message());
                partition2Result.setErrorCode(ApiError.NONE.error().code());
                partition2Result.setErrorMessage(ApiError.NONE.message());
                env.kafkaClient().prepareResponse((AbstractResponse)new ElectLeadersResponse(0, Errors.NONE.code(), electionResults));
                results = env.adminClient().electLeaders(electionType, new HashSet<TopicPartition>(Arrays.asList(topic1, topic2)));
                Assert.assertFalse((boolean)((Optional)((Map)results.partitions().get()).get(topic1)).isPresent());
                Assert.assertFalse((boolean)((Optional)((Map)results.partitions().get()).get(topic2)).isPresent());
                results = env.adminClient().electLeaders(electionType, new HashSet<TopicPartition>(Arrays.asList(topic1, topic2)), (ElectLeadersOptions)new ElectLeadersOptions().timeoutMs(Integer.valueOf(100)));
                TestUtils.assertFutureError(results.partitions(), TimeoutException.class);
            }
        }
    }

    @Test
    public void testDescribeBrokerConfigs() throws Exception {
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        ConfigResource broker1Resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(broker0Resource.name()).setResourceType(broker0Resource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(broker1Resource.name()).setResourceType(broker1Resource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))), env.cluster().nodeById(1));
            Map result = env.adminClient().describeConfigs(Arrays.asList(broker0Resource, broker1Resource)).values();
            Assert.assertEquals(new HashSet<ConfigResource>(Arrays.asList(broker0Resource, broker1Resource)), result.keySet());
            ((KafkaFuture)result.get(broker0Resource)).get();
            ((KafkaFuture)result.get(broker1Resource)).get();
        }
    }

    @Test
    public void testDescribeBrokerAndLogConfigs() throws Exception {
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        ConfigResource brokerLoggerResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "0");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(brokerResource.name()).setResourceType(brokerResource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList()), new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(brokerLoggerResource.name()).setResourceType(brokerLoggerResource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))), env.cluster().nodeById(0));
            Map result = env.adminClient().describeConfigs(Arrays.asList(brokerResource, brokerLoggerResource)).values();
            Assert.assertEquals(new HashSet<ConfigResource>(Arrays.asList(brokerResource, brokerLoggerResource)), result.keySet());
            ((KafkaFuture)result.get(brokerResource)).get();
            ((KafkaFuture)result.get(brokerLoggerResource)).get();
        }
    }

    @Test
    public void testDescribeConfigsPartialResponse() throws Exception {
        ConfigResource topic = new ConfigResource(ConfigResource.Type.TOPIC, "topic");
        ConfigResource topic2 = new ConfigResource(ConfigResource.Type.TOPIC, "topic2");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(topic.name()).setResourceType(topic.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))));
            Map result = env.adminClient().describeConfigs(Arrays.asList(topic, topic2)).values();
            Assert.assertEquals(new HashSet<ConfigResource>(Arrays.asList(topic, topic2)), result.keySet());
            result.get(topic);
            TestUtils.assertFutureThrows((Future)result.get(topic2), ApiException.class);
        }
    }

    @Test
    public void testDescribeConfigsUnrequested() throws Exception {
        ConfigResource topic = new ConfigResource(ConfigResource.Type.TOPIC, "topic");
        ConfigResource unrequested = new ConfigResource(ConfigResource.Type.TOPIC, "unrequested");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(topic.name()).setResourceType(topic.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList()), new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(unrequested.name()).setResourceType(unrequested.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))));
            Map result = env.adminClient().describeConfigs(Arrays.asList(topic)).values();
            Assert.assertEquals(new HashSet<ConfigResource>(Arrays.asList(topic)), result.keySet());
            Assert.assertNotNull((Object)((KafkaFuture)result.get(topic)).get());
            Assert.assertNull(result.get(unrequested));
        }
    }

    private static DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir, TopicPartition tp, long partitionSize, long offsetLag) {
        return KafkaAdminClientTest.prepareDescribeLogDirsResponse(error, logDir, KafkaAdminClientTest.prepareDescribeLogDirsTopics(partitionSize, offsetLag, tp.topic(), tp.partition(), false));
    }

    private static List<DescribeLogDirsResponseData.DescribeLogDirsTopic> prepareDescribeLogDirsTopics(long partitionSize, long offsetLag, String topic, int partition, boolean isFuture) {
        return Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsTopic().setName(topic).setPartitions(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsPartition().setPartitionIndex(partition).setPartitionSize(partitionSize).setIsFutureKey(isFuture).setOffsetLag(offsetLag))));
    }

    private static DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir, List<DescribeLogDirsResponseData.DescribeLogDirsTopic> topics) {
        return new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(error.code()).setLogDir(logDir).setTopics(topics))));
    }

    @Test
    public void testDescribeLogDirs() throws ExecutionException, InterruptedException {
        Set<Integer> brokers = Collections.singleton(0);
        String logDir = "/var/data/kafka";
        TopicPartition tp = new TopicPartition("topic", 12);
        long partitionSize = 1234567890L;
        long offsetLag = 24L;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeLogDirsResponse(Errors.NONE, logDir, tp, partitionSize, offsetLag), env.cluster().nodeById(0));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(brokers);
            Map descriptions = result.descriptions();
            Assert.assertEquals(brokers, descriptions.keySet());
            Assert.assertNotNull(descriptions.get(0));
            KafkaAdminClientTest.assertDescriptionContains((Map)((KafkaFuture)descriptions.get(0)).get(), logDir, tp, partitionSize, offsetLag);
            Map allDescriptions = (Map)result.allDescriptions().get();
            Assert.assertEquals(brokers, allDescriptions.keySet());
            KafkaAdminClientTest.assertDescriptionContains((Map)allDescriptions.get(0), logDir, tp, partitionSize, offsetLag);
        }
    }

    private static void assertDescriptionContains(Map<String, LogDirDescription> descriptionsMap, String logDir, TopicPartition tp, long partitionSize, long offsetLag) {
        Assert.assertNotNull(descriptionsMap);
        Assert.assertEquals(Collections.singleton(logDir), descriptionsMap.keySet());
        Assert.assertNull((Object)descriptionsMap.get(logDir).error());
        Map descriptionsReplicaInfos = descriptionsMap.get(logDir).replicaInfos();
        Assert.assertEquals(Collections.singleton(tp), descriptionsReplicaInfos.keySet());
        Assert.assertEquals((long)partitionSize, (long)((ReplicaInfo)descriptionsReplicaInfos.get(tp)).size());
        Assert.assertEquals((long)offsetLag, (long)((ReplicaInfo)descriptionsReplicaInfos.get(tp)).offsetLag());
        Assert.assertFalse((boolean)((ReplicaInfo)descriptionsReplicaInfos.get(tp)).isFuture());
    }

    @Test
    public void testDescribeLogDirsDeprecated() throws ExecutionException, InterruptedException {
        Set<Integer> brokers = Collections.singleton(0);
        TopicPartition tp = new TopicPartition("topic", 12);
        String logDir = "/var/data/kafka";
        Errors error = Errors.NONE;
        int offsetLag = 24;
        long partitionSize = 1234567890L;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeLogDirsResponse(error, logDir, tp, partitionSize, offsetLag), env.cluster().nodeById(0));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(brokers);
            Map deprecatedValues = result.values();
            Assert.assertEquals(brokers, deprecatedValues.keySet());
            Assert.assertNotNull(deprecatedValues.get(0));
            KafkaAdminClientTest.assertDescriptionContains((Map)((KafkaFuture)deprecatedValues.get(0)).get(), logDir, tp, error, offsetLag, partitionSize);
            Map deprecatedAll = (Map)result.all().get();
            Assert.assertEquals(brokers, deprecatedAll.keySet());
            KafkaAdminClientTest.assertDescriptionContains((Map)deprecatedAll.get(0), logDir, tp, error, offsetLag, partitionSize);
        }
    }

    private static void assertDescriptionContains(Map<String, DescribeLogDirsResponse.LogDirInfo> descriptionsMap, String logDir, TopicPartition tp, Errors error, int offsetLag, long partitionSize) {
        Assert.assertNotNull(descriptionsMap);
        Assert.assertEquals(Collections.singleton(logDir), descriptionsMap.keySet());
        Assert.assertEquals((Object)error, (Object)descriptionsMap.get((Object)logDir).error);
        Map allReplicaInfos = descriptionsMap.get((Object)logDir).replicaInfos;
        Assert.assertEquals(Collections.singleton(tp), allReplicaInfos.keySet());
        Assert.assertEquals((long)partitionSize, (long)((DescribeLogDirsResponse.ReplicaInfo)allReplicaInfos.get((Object)tp)).size);
        Assert.assertEquals((long)offsetLag, (long)((DescribeLogDirsResponse.ReplicaInfo)allReplicaInfos.get((Object)tp)).offsetLag);
        Assert.assertFalse((boolean)((DescribeLogDirsResponse.ReplicaInfo)allReplicaInfos.get((Object)tp)).isFuture);
    }

    @Test
    public void testDescribeLogDirsOfflineDir() throws ExecutionException, InterruptedException {
        Set<Integer> brokers = Collections.singleton(0);
        String logDir = "/var/data/kafka";
        Errors error = Errors.KAFKA_STORAGE_ERROR;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeLogDirsResponse(error, logDir, Collections.emptyList()), env.cluster().nodeById(0));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(brokers);
            Map descriptions = result.descriptions();
            Assert.assertEquals(brokers, descriptions.keySet());
            Assert.assertNotNull(descriptions.get(0));
            Map descriptionsMap = (Map)((KafkaFuture)descriptions.get(0)).get();
            Assert.assertEquals(Collections.singleton(logDir), descriptionsMap.keySet());
            Assert.assertEquals(error.exception().getClass(), ((LogDirDescription)descriptionsMap.get(logDir)).error().getClass());
            Assert.assertEquals(Collections.emptySet(), ((LogDirDescription)descriptionsMap.get(logDir)).replicaInfos().keySet());
            Map allDescriptions = (Map)result.allDescriptions().get();
            Assert.assertEquals(brokers, allDescriptions.keySet());
            Map allMap = (Map)allDescriptions.get(0);
            Assert.assertNotNull((Object)allMap);
            Assert.assertEquals(Collections.singleton(logDir), allMap.keySet());
            Assert.assertEquals(error.exception().getClass(), ((LogDirDescription)allMap.get(logDir)).error().getClass());
            Assert.assertEquals(Collections.emptySet(), ((LogDirDescription)allMap.get(logDir)).replicaInfos().keySet());
        }
    }

    @Test
    public void testDescribeLogDirsOfflineDirDeprecated() throws ExecutionException, InterruptedException {
        Set<Integer> brokers = Collections.singleton(0);
        String logDir = "/var/data/kafka";
        Errors error = Errors.KAFKA_STORAGE_ERROR;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeLogDirsResponse(error, logDir, Collections.emptyList()), env.cluster().nodeById(0));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(brokers);
            Map deprecatedValues = result.values();
            Assert.assertEquals(brokers, deprecatedValues.keySet());
            Assert.assertNotNull(deprecatedValues.get(0));
            Map valuesMap = (Map)((KafkaFuture)deprecatedValues.get(0)).get();
            Assert.assertEquals(Collections.singleton(logDir), valuesMap.keySet());
            Assert.assertEquals((Object)error, (Object)((DescribeLogDirsResponse.LogDirInfo)valuesMap.get((Object)logDir)).error);
            Assert.assertEquals(Collections.emptySet(), ((DescribeLogDirsResponse.LogDirInfo)valuesMap.get((Object)logDir)).replicaInfos.keySet());
            Map deprecatedAll = (Map)result.all().get();
            Assert.assertEquals(brokers, deprecatedAll.keySet());
            Map allMap = (Map)deprecatedAll.get(0);
            Assert.assertNotNull((Object)allMap);
            Assert.assertEquals(Collections.singleton(logDir), allMap.keySet());
            Assert.assertEquals((Object)error, (Object)((DescribeLogDirsResponse.LogDirInfo)allMap.get((Object)logDir)).error);
            Assert.assertEquals(Collections.emptySet(), ((DescribeLogDirsResponse.LogDirInfo)allMap.get((Object)logDir)).replicaInfos.keySet());
        }
    }

    @Test
    public void testDescribeReplicaLogDirs() throws ExecutionException, InterruptedException {
        TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 12, 1);
        TopicPartitionReplica tpr2 = new TopicPartitionReplica("topic", 12, 2);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String broker1log0 = "/var/data/kafka0";
            String broker1log1 = "/var/data/kafka1";
            String broker2log0 = "/var/data/kafka2";
            int broker1Log0OffsetLag = 24;
            int broker1Log0PartitionSize = 987654321;
            int broker1Log1PartitionSize = 123456789;
            int broker1Log1OffsetLag = 4321;
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Arrays.asList(KafkaAdminClientTest.prepareDescribeLogDirsResult(tpr1, broker1log0, broker1Log0PartitionSize, broker1Log0OffsetLag, false), KafkaAdminClientTest.prepareDescribeLogDirsResult(tpr1, broker1log1, broker1Log1PartitionSize, broker1Log1OffsetLag, true)))), env.cluster().nodeById(tpr1.brokerId()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)this.prepareDescribeLogDirsResponse(Errors.KAFKA_STORAGE_ERROR, broker2log0), env.cluster().nodeById(tpr2.brokerId()));
            DescribeReplicaLogDirsResult result = env.adminClient().describeReplicaLogDirs(Arrays.asList(tpr1, tpr2));
            Map values = result.values();
            Assert.assertEquals(TestUtils.toSet(Arrays.asList(tpr1, tpr2)), values.keySet());
            Assert.assertNotNull(values.get(tpr1));
            Assert.assertEquals((Object)broker1log0, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getCurrentReplicaLogDir());
            Assert.assertEquals((long)broker1Log0OffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getCurrentReplicaOffsetLag());
            Assert.assertEquals((Object)broker1log1, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getFutureReplicaLogDir());
            Assert.assertEquals((long)broker1Log1OffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getFutureReplicaOffsetLag());
            Assert.assertNotNull(values.get(tpr2));
            Assert.assertNull((Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getCurrentReplicaLogDir());
            Assert.assertEquals((long)-1L, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getCurrentReplicaOffsetLag());
            Assert.assertNull((Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getFutureReplicaLogDir());
            Assert.assertEquals((long)-1L, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getFutureReplicaOffsetLag());
        }
    }

    private static DescribeLogDirsResponseData.DescribeLogDirsResult prepareDescribeLogDirsResult(TopicPartitionReplica tpr, String logDir, int partitionSize, int offsetLag, boolean isFuture) {
        return new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(Errors.NONE.code()).setLogDir(logDir).setTopics(KafkaAdminClientTest.prepareDescribeLogDirsTopics(partitionSize, offsetLag, tpr.topic(), tpr.partition(), isFuture));
    }

    @Test
    public void testDescribeReplicaLogDirsUnexpected() throws ExecutionException, InterruptedException {
        TopicPartitionReplica expected = new TopicPartitionReplica("topic", 12, 1);
        TopicPartitionReplica unexpected = new TopicPartitionReplica("topic", 12, 2);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String broker1log0 = "/var/data/kafka0";
            String broker1log1 = "/var/data/kafka1";
            int broker1Log0PartitionSize = 987654321;
            int broker1Log0OffsetLag = 24;
            int broker1Log1PartitionSize = 123456789;
            int broker1Log1OffsetLag = 4321;
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Arrays.asList(KafkaAdminClientTest.prepareDescribeLogDirsResult(expected, broker1log0, broker1Log0PartitionSize, broker1Log0OffsetLag, false), KafkaAdminClientTest.prepareDescribeLogDirsResult(unexpected, broker1log1, broker1Log1PartitionSize, broker1Log1OffsetLag, true)))), env.cluster().nodeById(expected.brokerId()));
            DescribeReplicaLogDirsResult result = env.adminClient().describeReplicaLogDirs(Arrays.asList(expected));
            Map values = result.values();
            Assert.assertEquals(TestUtils.toSet(Arrays.asList(expected)), values.keySet());
            Assert.assertNotNull(values.get(expected));
            Assert.assertEquals((Object)broker1log0, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(expected)).get()).getCurrentReplicaLogDir());
            Assert.assertEquals((long)broker1Log0OffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(expected)).get()).getCurrentReplicaOffsetLag());
            Assert.assertEquals((Object)broker1log1, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(expected)).get()).getFutureReplicaLogDir());
            Assert.assertEquals((long)broker1Log1OffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(expected)).get()).getFutureReplicaOffsetLag());
        }
    }

    @Test
    public void testCreatePartitions() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("my_topic", "other_topic"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("my_topic", Errors.NONE), KafkaAdminClientTest.createPartitionsTopicResult("other_topic", Errors.INVALID_TOPIC_EXCEPTION, "some detailed reason")));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("my_topic", NewPartitions.increaseTo((int)3));
            counts.put("other_topic", NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(2), Arrays.asList(3))));
            CreatePartitionsResult results = env.adminClient().createPartitions(counts);
            Map values = results.values();
            KafkaFuture myTopicResult = (KafkaFuture)values.get("my_topic");
            myTopicResult.get();
            KafkaFuture otherTopicResult = (KafkaFuture)values.get("other_topic");
            try {
                otherTopicResult.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e0) {
                Assert.assertTrue((boolean)(e0.getCause() instanceof InvalidTopicException));
                InvalidTopicException e = (InvalidTopicException)e0.getCause();
                Assert.assertEquals((Object)"some detailed reason", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testCreatePartitionsRetryThrottlingExceptionWhenEnabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.createPartitionsTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(0, KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.NONE)));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("topic1", NewPartitions.increaseTo((int)1));
            counts.put("topic2", NewPartitions.increaseTo((int)2));
            counts.put("topic3", NewPartitions.increaseTo((int)3));
            CreatePartitionsResult result = env.adminClient().createPartitions(counts, new CreatePartitionsOptions().retryOnQuotaViolation(true));
            Assert.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            Assert.assertNull((Object)((KafkaFuture)result.values().get("topic2")).get());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    @Test
    public void testCreatePartitionsRetryThrottlingExceptionWhenEnabledUntilRequestTimeOut() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "default.api.timeout.ms", String.valueOf(defaultApiTimeout));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.createPartitionsTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("topic1", NewPartitions.increaseTo((int)1));
            counts.put("topic2", NewPartitions.increaseTo((int)2));
            counts.put("topic3", NewPartitions.increaseTo((int)3));
            CreatePartitionsResult result = env.adminClient().createPartitions(counts, new CreatePartitionsOptions().retryOnQuotaViolation(true));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting CreatePartitions requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting next CreatePartitions request");
            time.sleep(defaultApiTimeout + 1L);
            Assert.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows((Future)result.values().get("topic2"), ThrottlingQuotaExceededException.class);
            Assert.assertEquals((long)0L, (long)e.throttleTimeMs());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    @Test
    public void testCreatePartitionsDontRetryThrottlingExceptionWhenDisabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.createPartitionsTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("topic1", NewPartitions.increaseTo((int)1));
            counts.put("topic2", NewPartitions.increaseTo((int)2));
            counts.put("topic3", NewPartitions.increaseTo((int)3));
            CreatePartitionsResult result = env.adminClient().createPartitions(counts, new CreatePartitionsOptions().retryOnQuotaViolation(false));
            Assert.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows((Future)result.values().get("topic2"), ThrottlingQuotaExceededException.class);
            Assert.assertEquals((long)1000L, (long)e.throttleTimeMs());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    private MockClient.RequestMatcher expectCreatePartitionsRequestWithTopics(String ... topics) {
        return body -> {
            if (body instanceof CreatePartitionsRequest) {
                CreatePartitionsRequest request = (CreatePartitionsRequest)body;
                for (String topic : topics) {
                    if (request.data().topics().find(topic) != null) continue;
                    return false;
                }
                return topics.length == request.data().topics().size();
            }
            return false;
        };
    }

    @Test
    public void testDeleteRecordsTopicAuthorizationError() {
        String topic = "foo";
        TopicPartition partition = new TopicPartition(topic, 0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            ArrayList<MetadataResponse.TopicMetadata> topics = new ArrayList<MetadataResponse.TopicMetadata>();
            topics.add(new MetadataResponse.TopicMetadata(Errors.TOPIC_AUTHORIZATION_FAILED, topic, false, Collections.emptyList()));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)env.cluster().controller().id(), topics));
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(partition, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            TestUtils.assertFutureThrows((Future)results.lowWatermarks().get(partition), TopicAuthorizationException.class);
        }
    }

    @Test
    public void testDeleteRecordsMultipleSends() throws Exception {
        String topic = "foo";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0));){
            List nodes = env.cluster().nodes();
            ArrayList<MetadataResponse.PartitionMetadata> partitionMetadata = new ArrayList<MetadataResponse.PartitionMetadata>();
            partitionMetadata.add(new MetadataResponse.PartitionMetadata(Errors.NONE, tp0, Optional.of(((Node)nodes.get(0)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            partitionMetadata.add(new MetadataResponse.PartitionMetadata(Errors.NONE, tp1, Optional.of(((Node)nodes.get(1)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(1)).id()), Collections.singletonList(((Node)nodes.get(1)).id()), Collections.emptyList()));
            ArrayList<MetadataResponse.TopicMetadata> topicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
            topicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, topic, false, partitionMetadata));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)env.cluster().controller().id(), topicMetadata));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DeleteRecordsResponse(new DeleteRecordsResponseData().setTopics(new DeleteRecordsResponseData.DeleteRecordsTopicResultCollection(Collections.singletonList(new DeleteRecordsResponseData.DeleteRecordsTopicResult().setName(tp0.topic()).setPartitions(new DeleteRecordsResponseData.DeleteRecordsPartitionResultCollection(Collections.singletonList(new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(tp0.partition()).setErrorCode(Errors.NONE.code()).setLowWatermark(3L)).iterator()))).iterator()))), (Node)nodes.get(0));
            env.kafkaClient().disconnect(((Node)nodes.get(1)).idString());
            env.kafkaClient().createPendingAuthenticationError((Node)nodes.get(1), 100L);
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(tp0, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(tp1, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            Assert.assertEquals((long)3L, (long)((DeletedRecords)((KafkaFuture)results.lowWatermarks().get(tp0)).get()).lowWatermark());
            TestUtils.assertFutureThrows((Future)results.lowWatermarks().get(tp1), AuthenticationException.class);
        }
    }

    @Test
    public void testDeleteRecords() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        nodes.put(0, new Node(0, "localhost", 8121));
        ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>();
        partitionInfos.add(new PartitionInfo("my_topic", 0, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 1, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 2, null, new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 3, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 4, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), partitionInfos, Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
        TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
        TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
        TopicPartition myTopicPartition3 = new TopicPartition("my_topic", 3);
        TopicPartition myTopicPartition4 = new TopicPartition("my_topic", 4);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            DeleteRecordsResponseData m = new DeleteRecordsResponseData();
            m.topics().add(new DeleteRecordsResponseData.DeleteRecordsTopicResult().setName(myTopicPartition0.topic()).setPartitions(new DeleteRecordsResponseData.DeleteRecordsPartitionResultCollection(Arrays.asList(new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(myTopicPartition0.partition()).setLowWatermark(3L).setErrorCode(Errors.NONE.code()), new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(myTopicPartition1.partition()).setLowWatermark(-1L).setErrorCode(Errors.OFFSET_OUT_OF_RANGE.code()), new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(myTopicPartition3.partition()).setLowWatermark(-1L).setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code()), new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(myTopicPartition4.partition()).setLowWatermark(-1L).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code())).iterator())));
            ArrayList<MetadataResponse.TopicMetadata> t = new ArrayList<MetadataResponse.TopicMetadata>();
            ArrayList<MetadataResponse.PartitionMetadata> p = new ArrayList<MetadataResponse.PartitionMetadata>();
            p.add(new MetadataResponse.PartitionMetadata(Errors.NONE, myTopicPartition0, Optional.of(((Node)nodes.get(0)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            p.add(new MetadataResponse.PartitionMetadata(Errors.NONE, myTopicPartition1, Optional.of(((Node)nodes.get(0)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            p.add(new MetadataResponse.PartitionMetadata(Errors.LEADER_NOT_AVAILABLE, myTopicPartition2, Optional.empty(), Optional.empty(), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            p.add(new MetadataResponse.PartitionMetadata(Errors.NONE, myTopicPartition3, Optional.of(((Node)nodes.get(0)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            p.add(new MetadataResponse.PartitionMetadata(Errors.NONE, myTopicPartition4, Optional.of(((Node)nodes.get(0)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            t.add(new MetadataResponse.TopicMetadata(Errors.NONE, "my_topic", false, p));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), t));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteRecordsResponse(m));
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(myTopicPartition0, RecordsToDelete.beforeOffset((long)3L));
            recordsToDelete.put(myTopicPartition1, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition2, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition3, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition4, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            Map values = results.lowWatermarks();
            KafkaFuture myTopicPartition0Result = (KafkaFuture)values.get(myTopicPartition0);
            long lowWatermark = ((DeletedRecords)myTopicPartition0Result.get()).lowWatermark();
            Assert.assertEquals((long)lowWatermark, (long)3L);
            KafkaFuture myTopicPartition1Result = (KafkaFuture)values.get(myTopicPartition1);
            try {
                myTopicPartition1Result.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e0) {
                Assert.assertTrue((boolean)(e0.getCause() instanceof OffsetOutOfRangeException));
            }
            KafkaFuture myTopicPartition2Result = (KafkaFuture)values.get(myTopicPartition2);
            try {
                myTopicPartition2Result.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e1) {
                Assert.assertTrue((boolean)(e1.getCause() instanceof LeaderNotAvailableException));
            }
            KafkaFuture myTopicPartition3Result = (KafkaFuture)values.get(myTopicPartition3);
            try {
                myTopicPartition3Result.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e1) {
                Assert.assertTrue((boolean)(e1.getCause() instanceof NotLeaderOrFollowerException));
            }
            KafkaFuture myTopicPartition4Result = (KafkaFuture)values.get(myTopicPartition4);
            try {
                myTopicPartition4Result.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e1) {
                Assert.assertTrue((boolean)(e1.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    @Test
    public void testDescribeCluster() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            MetadataResponse response = MetadataResponse.prepareResponse((int)0, Collections.emptyList(), (Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)2, (int)Integer.MIN_VALUE);
            env.kafkaClient().prepareResponse((AbstractResponse)response);
            MetadataResponse response2 = MetadataResponse.prepareResponse((int)0, Collections.emptyList(), (Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)3, (int)(1 << AclOperation.DESCRIBE.code() | 1 << AclOperation.ALTER.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)response2);
            DescribeClusterResult result = env.adminClient().describeCluster();
            Assert.assertEquals((Object)env.cluster().clusterResource().clusterId(), (Object)result.clusterId().get());
            Assert.assertEquals((long)2L, (long)((Node)result.controller().get()).id());
            Assert.assertEquals(null, (Object)result.authorizedOperations().get());
            DescribeClusterResult result2 = env.adminClient().describeCluster();
            Assert.assertEquals((Object)env.cluster().clusterResource().clusterId(), (Object)result2.clusterId().get());
            Assert.assertEquals((long)3L, (long)((Node)result2.controller().get()).id());
            Assert.assertEquals(new HashSet<AclOperation>(Arrays.asList(AclOperation.DESCRIBE, AclOperation.ALTER)), (Object)result2.authorizedOperations().get());
        }
    }

    @Test
    public void testListConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse(Collections.emptyList(), (String)env.cluster().clusterResource().clusterId(), (int)-1, Collections.emptyList()));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)env.cluster().controller().id(), Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-1").setProtocolType("connector").setGroupState("Stable")))), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-2").setProtocolType("connector").setGroupState("Stable")))), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-3").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-3").setProtocolType("connector").setGroupState("Stable")))), env.cluster().nodeById(2));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(3));
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups();
            TestUtils.assertFutureError(result.all(), UnknownServerException.class);
            Collection listings = (Collection)result.valid().get();
            Assert.assertEquals((long)3L, (long)listings.size());
            HashSet<String> groupIds = new HashSet<String>();
            for (ConsumerGroupListing listing : listings) {
                groupIds.add(listing.groupId());
                Assert.assertTrue((boolean)listing.state().isPresent());
            }
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"group-1", "group-2", "group-3"}), groupIds);
            Assert.assertEquals((long)1L, (long)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListConsumerGroupsMetadataFailure() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse(Collections.emptyList(), (String)env.cluster().clusterResource().clusterId(), (int)-1, Collections.emptyList()));
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups();
            TestUtils.assertFutureError(result.all(), KafkaException.class);
        }
    }

    @Test
    public void testListConsumerGroupsWithStates() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setGroupState("Empty")))), env.cluster().nodeById(0));
            ListConsumerGroupsOptions options = new ListConsumerGroupsOptions();
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups(options);
            Collection listings = (Collection)result.valid().get();
            Assert.assertEquals((long)2L, (long)listings.size());
            ArrayList<ConsumerGroupListing> expected = new ArrayList<ConsumerGroupListing>();
            expected.add(new ConsumerGroupListing("group-2", true, Optional.of(ConsumerGroupState.EMPTY)));
            expected.add(new ConsumerGroupListing("group-1", false, Optional.of(ConsumerGroupState.STABLE)));
            Assert.assertEquals(expected, (Object)listings);
            Assert.assertEquals((long)0L, (long)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListConsumerGroupsWithStatesOlderBrokerVersion() throws Exception {
        ApiVersion listGroupV3 = new ApiVersion(ApiKeys.LIST_GROUPS.id, 0, 3);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Collections.singletonList(listGroupV3)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Collections.singletonList(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer")))), env.cluster().nodeById(0));
            ListConsumerGroupsOptions options = new ListConsumerGroupsOptions();
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups(options);
            Collection listing = (Collection)result.all().get();
            Assert.assertEquals((long)1L, (long)listing.size());
            List<ConsumerGroupListing> expected = Collections.singletonList(new ConsumerGroupListing("group-1", false, Optional.empty()));
            Assert.assertEquals(expected, (Object)listing);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(body -> body instanceof ListGroupsRequest);
            options = new ListConsumerGroupsOptions().inStates(Collections.singleton(ConsumerGroupState.STABLE));
            result = env.adminClient().listConsumerGroups(options);
            TestUtils.assertFutureThrows(result.all(), UnsupportedVersionException.class);
        }
    }

    @Test
    public void testOffsetCommitNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String groupId = "group-0";
            TopicPartition tp1 = new TopicPartition("foo", 0);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets("group-0", offsets);
            TestUtils.assertFutureError(result.all(), TimeoutException.class);
        }
    }

    @Test
    public void testOffsetCommitRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            String groupId = "group-0";
            TopicPartition tp1 = new TopicPartition("foo", 0);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            KafkaFuture future = env.adminClient().alterConsumerGroupOffsets("group-0", offsets).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting CommitOffsets first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry CommitOffsets call on first failure");
            time.sleep(retryBackoff);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assert.assertEquals((String)"CommitOffsets retry did not await expected backoff!", (long)retryBackoff, (long)actualRetryBackoff);
        }
    }

    @Test
    public void testDescribeConsumerGroupNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NOT_COORDINATOR, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList("group-0"));
            TestUtils.assertFutureError(result.all(), TimeoutException.class);
        }
    }

    @Test
    public void testDescribeConsumerGroupRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NOT_COORDINATOR, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DescribeGroupsResponse(data));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Collections.emptyList(), Collections.emptySet()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DescribeGroupsResponse(data));
            KafkaFuture future = env.adminClient().describeConsumerGroups(Collections.singletonList("group-0")).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting DescribeConsumerGroup first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry DescribeConsumerGroup call on first failure");
            time.sleep(retryBackoff);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assert.assertEquals((String)"DescribeConsumerGroup retry did not await expected backoff!", (long)retryBackoff, (long)actualRetryBackoff);
        }
    }

    @Test
    public void testDescribeConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.COORDINATOR_LOAD_IN_PROGRESS, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.COORDINATOR_NOT_AVAILABLE, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NOT_COORDINATOR, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new DescribeGroupsResponseData();
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            topicPartitions.add(0, myTopicPartition0);
            topicPartitions.add(1, myTopicPartition1);
            topicPartitions.add(2, myTopicPartition2);
            ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
            byte[] memberAssignmentBytes = new byte[memberAssignment.remaining()];
            memberAssignment.get(memberAssignmentBytes);
            DescribeGroupsResponseData.DescribedGroupMember memberOne = DescribeGroupsResponse.groupMember((String)"0", (String)"instance1", (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null);
            DescribeGroupsResponseData.DescribedGroupMember memberTwo = DescribeGroupsResponse.groupMember((String)"1", (String)"instance2", (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null);
            ArrayList<MemberDescription> expectedMemberDescriptions = new ArrayList<MemberDescription>();
            expectedMemberDescriptions.add(KafkaAdminClientTest.convertToMemberDescriptions(memberOne, new MemberAssignment(new HashSet(topicPartitions))));
            expectedMemberDescriptions.add(KafkaAdminClientTest.convertToMemberDescriptions(memberTwo, new MemberAssignment(new HashSet(topicPartitions))));
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Arrays.asList(memberOne, memberTwo), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList("group-0"));
            ConsumerGroupDescription groupDescription = (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get("group-0")).get();
            Assert.assertEquals((long)1L, (long)result.describedGroups().size());
            Assert.assertEquals((Object)"group-0", (Object)groupDescription.groupId());
            Assert.assertEquals((long)2L, (long)groupDescription.members().size());
            Assert.assertEquals(expectedMemberDescriptions, (Object)groupDescription.members());
        }
    }

    @Test
    public void testDescribeMultipleConsumerGroups() {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            topicPartitions.add(0, myTopicPartition0);
            topicPartitions.add(1, myTopicPartition1);
            topicPartitions.add(2, myTopicPartition2);
            ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
            byte[] memberAssignmentBytes = new byte[memberAssignment.remaining()];
            memberAssignment.get(memberAssignmentBytes);
            DescribeGroupsResponseData group0Data = new DescribeGroupsResponseData();
            group0Data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Arrays.asList(DescribeGroupsResponse.groupMember((String)"0", null, (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null), DescribeGroupsResponse.groupMember((String)"1", null, (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null)), Collections.emptySet()));
            DescribeGroupsResponseData groupConnectData = new DescribeGroupsResponseData();
            group0Data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-connect-0", (Errors)Errors.NONE, (String)"", (String)"connect", (String)"", Arrays.asList(DescribeGroupsResponse.groupMember((String)"0", null, (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null), DescribeGroupsResponse.groupMember((String)"1", null, (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null)), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(group0Data));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(groupConnectData));
            HashSet<String> groups = new HashSet<String>();
            groups.add("group-0");
            groups.add("group-connect-0");
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(groups);
            Assert.assertEquals((long)2L, (long)result.describedGroups().size());
            Assert.assertEquals(groups, result.describedGroups().keySet());
        }
    }

    @Test
    public void testDescribeConsumerGroupsWithAuthorizedOperationsOmitted() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Collections.emptyList(), (int)Integer.MIN_VALUE));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList("group-0"));
            ConsumerGroupDescription groupDescription = (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get("group-0")).get();
            Assert.assertNull((Object)groupDescription.authorizedOperations());
        }
    }

    @Test
    public void testDescribeNonConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NONE, (String)"", (String)"non-consumer", (String)"", Arrays.asList(new DescribeGroupsResponseData.DescribedGroupMember[0]), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList("group-0"));
            TestUtils.assertFutureError((Future)result.describedGroups().get("group-0"), IllegalArgumentException.class);
        }
    }

    @Test
    public void testListConsumerGroupOffsetsNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(Errors.NOT_COORDINATOR, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets("group-0");
            TestUtils.assertFutureError(result.partitionsToOffsetAndMetadata(), TimeoutException.class);
        }
    }

    @Test
    public void testListConsumerGroupOffsetsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new OffsetFetchResponse(Errors.NOT_COORDINATOR, Collections.emptyMap()));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new OffsetFetchResponse(Errors.NONE, Collections.emptyMap()));
            KafkaFuture future = env.adminClient().listConsumerGroupOffsets("group-0").partitionsToOffsetAndMetadata();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting ListConsumerGroupOffsets first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry ListConsumerGroupOffsets call on first failure");
            time.sleep(retryBackoff);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assert.assertEquals((String)"ListConsumerGroupOffsets retry did not await expected backoff!", (long)retryBackoff, (long)actualRetryBackoff);
        }
    }

    @Test
    public void testListConsumerGroupOffsets() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(Errors.COORDINATOR_NOT_AVAILABLE, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(Errors.NOT_COORDINATOR, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            TopicPartition myTopicPartition3 = new TopicPartition("my_topic", 3);
            HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
            responseData.put(myTopicPartition0, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", Errors.NONE));
            responseData.put(myTopicPartition1, new OffsetFetchResponse.PartitionData(0L, Optional.empty(), "", Errors.NONE));
            responseData.put(myTopicPartition2, new OffsetFetchResponse.PartitionData(20L, Optional.empty(), "", Errors.NONE));
            responseData.put(myTopicPartition3, new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.NONE));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(Errors.NONE, responseData));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets("group-0");
            Map partitionToOffsetAndMetadata = (Map)result.partitionsToOffsetAndMetadata().get();
            Assert.assertEquals((long)4L, (long)partitionToOffsetAndMetadata.size());
            Assert.assertEquals((long)10L, (long)((OffsetAndMetadata)partitionToOffsetAndMetadata.get(myTopicPartition0)).offset());
            Assert.assertEquals((long)0L, (long)((OffsetAndMetadata)partitionToOffsetAndMetadata.get(myTopicPartition1)).offset());
            Assert.assertEquals((long)20L, (long)((OffsetAndMetadata)partitionToOffsetAndMetadata.get(myTopicPartition2)).offset());
            Assert.assertTrue((boolean)partitionToOffsetAndMetadata.containsKey(myTopicPartition3));
            Assert.assertNull(partitionToOffsetAndMetadata.get(myTopicPartition3));
        }
    }

    @Test
    public void testDeleteConsumerGroupsNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        List<String> groupIds = Collections.singletonList("group-0");
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-0").setErrorCode(Errors.NOT_COORDINATOR.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteConsumerGroupsResult result = env.adminClient().deleteConsumerGroups(groupIds);
            TestUtils.assertFutureError(result.all(), TimeoutException.class);
        }
    }

    @Test
    public void testDeleteConsumerGroupsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        List<String> groupIds = Collections.singletonList("group-0");
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-0").setErrorCode(Errors.NOT_COORDINATOR.code()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-0").setErrorCode(Errors.NONE.code()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            KafkaFuture future = env.adminClient().deleteConsumerGroups(groupIds).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting DeleteConsumerGroups first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry DeleteConsumerGroups call on first failure");
            time.sleep(retryBackoff);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assert.assertEquals((String)"DeleteConsumerGroups retry did not await expected backoff!", (long)retryBackoff, (long)actualRetryBackoff);
        }
    }

    @Test
    public void testDeleteConsumerGroups() throws Exception {
        List<String> groupIds = Collections.singletonList("group-0");
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-0").setErrorCode(Errors.NONE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            DeleteConsumerGroupsResult result = env.adminClient().deleteConsumerGroups(groupIds);
            KafkaFuture results = (KafkaFuture)result.deletedGroups().get("group-0");
            Assert.assertNull((Object)results.get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            DeleteConsumerGroupsResult errorResult = env.adminClient().deleteConsumerGroups(groupIds);
            TestUtils.assertFutureError((Future)errorResult.deletedGroups().get("group-0"), GroupAuthorizationException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection errorResponse1 = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            errorResponse1.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-0").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(errorResponse1)));
            DeleteGroupsResponseData.DeletableGroupResultCollection errorResponse2 = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            errorResponse2.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-0").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(errorResponse2)));
            DeleteGroupsResponseData.DeletableGroupResultCollection coordinatorMoved = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            coordinatorMoved.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("UnitTestError").setErrorCode(Errors.NOT_COORDINATOR.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(coordinatorMoved)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            DeleteConsumerGroupsResult errorResult1 = env.adminClient().deleteConsumerGroups(groupIds);
            KafkaFuture errorResults = (KafkaFuture)errorResult1.deletedGroups().get("group-0");
            Assert.assertNull((Object)errorResults.get());
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            TopicPartition tp1 = new TopicPartition("foo", 0);
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteConsumerGroupOffsetsResult result = env.adminClient().deleteConsumerGroupOffsets("group-0", Stream.of(tp1).collect(Collectors.toSet()));
            TestUtils.assertFutureError(result.all(), TimeoutException.class);
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            TopicPartition tp1 = new TopicPartition("foo", 0);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NOT_COORDINATOR));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            KafkaFuture future = env.adminClient().deleteConsumerGroupOffsets("group-0", Stream.of(tp1).collect(Collectors.toSet())).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting DeleteConsumerGroupOffsets first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry DeleteConsumerGroupOffsets call on first failure");
            time.sleep(retryBackoff);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assert.assertEquals((String)"DeleteConsumerGroupOffsets retry did not await expected backoff!", (long)retryBackoff, (long)actualRetryBackoff);
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsets() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("foobar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetDeleteResponse(new OffsetDeleteResponseData().setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(Stream.of(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("foo").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code())).iterator())), new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("bar").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code())).iterator()))).collect(Collectors.toList()).iterator()))));
            DeleteConsumerGroupOffsetsResult errorResult = env.adminClient().deleteConsumerGroupOffsets("group-0", Stream.of(tp1, tp2).collect(Collectors.toSet()));
            Assert.assertNull((Object)errorResult.partitionResult(tp1).get());
            TestUtils.assertFutureError(errorResult.all(), GroupSubscribedToTopicException.class);
            TestUtils.assertFutureError(errorResult.partitionResult(tp2), GroupSubscribedToTopicException.class);
            Assert.assertThrows(IllegalArgumentException.class, () -> errorResult.partitionResult(tp3));
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.COORDINATOR_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            DeleteConsumerGroupOffsetsResult errorResult1 = env.adminClient().deleteConsumerGroupOffsets("group-0", Stream.of(tp1).collect(Collectors.toSet()));
            Assert.assertNull((Object)errorResult1.all().get());
            Assert.assertNull((Object)errorResult1.partitionResult(tp1).get());
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsNonRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(error));
                DeleteConsumerGroupOffsetsResult errorResult = env.adminClient().deleteConsumerGroupOffsets("group-0", Stream.of(tp1).collect(Collectors.toSet()));
                TestUtils.assertFutureError(errorResult.all(), error.exception().getClass());
                TestUtils.assertFutureError(errorResult.partitionResult(tp1), error.exception().getClass());
            }
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsFindCoordinatorRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            DeleteConsumerGroupOffsetsResult result = env.adminClient().deleteConsumerGroupOffsets("group-0", Stream.of(tp1).collect(Collectors.toSet()));
            Assert.assertNull((Object)result.all().get());
            Assert.assertNull((Object)result.partitionResult(tp1).get());
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsFindCoordinatorNonRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            DeleteConsumerGroupOffsetsResult errorResult = env.adminClient().deleteConsumerGroupOffsets("group-0", Stream.of(tp1).collect(Collectors.toSet()));
            TestUtils.assertFutureError(errorResult.all(), GroupAuthorizationException.class);
            TestUtils.assertFutureError(errorResult.partitionResult(tp1), GroupAuthorizationException.class);
        }
    }

    @Test
    public void testIncrementalAlterConfigs() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            IncrementalAlterConfigsResponseData responseData = new IncrementalAlterConfigsResponseData();
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage("authorization error"));
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("topic1").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Config value append is not allowed for config"));
            env.kafkaClient().prepareResponse((AbstractResponse)new IncrementalAlterConfigsResponse(responseData));
            ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "");
            ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "topic1");
            AlterConfigOp alterConfigOp1 = new AlterConfigOp(new ConfigEntry("log.segment.bytes", "1073741"), AlterConfigOp.OpType.SET);
            AlterConfigOp alterConfigOp2 = new AlterConfigOp(new ConfigEntry("compression.type", "gzip"), AlterConfigOp.OpType.APPEND);
            HashMap<ConfigResource, List<AlterConfigOp>> configs = new HashMap<ConfigResource, List<AlterConfigOp>>();
            configs.put(brokerResource, Collections.singletonList(alterConfigOp1));
            configs.put(topicResource, Collections.singletonList(alterConfigOp2));
            AlterConfigsResult result = env.adminClient().incrementalAlterConfigs(configs);
            TestUtils.assertFutureError((Future)result.values().get(brokerResource), ClusterAuthorizationException.class);
            TestUtils.assertFutureError((Future)result.values().get(topicResource), InvalidRequestException.class);
            responseData = new IncrementalAlterConfigsResponseData();
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(ApiError.NONE.message()));
            env.kafkaClient().prepareResponse((AbstractResponse)new IncrementalAlterConfigsResponse(responseData));
            env.adminClient().incrementalAlterConfigs(Collections.singletonMap(brokerResource, Collections.singletonList(alterConfigOp1))).all().get();
        }
    }

    @Test
    public void testRemoveMembersFromGroupNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            List<MemberToRemove> membersToRemove = Arrays.asList(new MemberToRemove("instance-1"), new MemberToRemove("instance-2"));
            RemoveMembersFromConsumerGroupResult result = env.adminClient().removeMembersFromConsumerGroup("groupId", new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            TestUtils.assertFutureError(result.all(), TimeoutException.class);
        }
    }

    @Test
    public void testRemoveMembersFromGroupRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code())));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            LeaveGroupResponseData.MemberResponse responseOne = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(responseOne))));
            List<MemberToRemove> membersToRemove = Collections.singletonList(new MemberToRemove("instance-1"));
            KafkaFuture future = env.adminClient().removeMembersFromConsumerGroup("groupId", new RemoveMembersFromConsumerGroupOptions(membersToRemove)).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting RemoveMembersFromGroup first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry RemoveMembersFromGroup call on first failure");
            time.sleep(retryBackoff);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assert.assertEquals((String)"RemoveMembersFromGroup retry did not await expected backoff!", (long)retryBackoff, (long)actualRetryBackoff);
        }
    }

    @Test
    public void testRemoveMembersFromGroup() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            String instanceOne = "instance-1";
            String instanceTwo = "instance-2";
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse(null, true);
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code())));
            String groupId = "groupId";
            List<MemberToRemove> membersToRemove = Arrays.asList(new MemberToRemove("instance-1"), new MemberToRemove("instance-2"));
            RemoveMembersFromConsumerGroupResult unknownErrorResult = env.adminClient().removeMembersFromConsumerGroup(groupId, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            MemberToRemove memberOne = new MemberToRemove("instance-1");
            MemberToRemove memberTwo = new MemberToRemove("instance-2");
            TestUtils.assertFutureError(unknownErrorResult.all(), UnknownServerException.class);
            TestUtils.assertFutureError(unknownErrorResult.memberResult(memberOne), UnknownServerException.class);
            TestUtils.assertFutureError(unknownErrorResult.memberResult(memberTwo), UnknownServerException.class);
            LeaveGroupResponseData.MemberResponse responseOne = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code());
            LeaveGroupResponseData.MemberResponse responseTwo = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-2").setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseOne, responseTwo))));
            RemoveMembersFromConsumerGroupResult memberLevelErrorResult = env.adminClient().removeMembersFromConsumerGroup(groupId, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            TestUtils.assertFutureError(memberLevelErrorResult.all(), UnknownMemberIdException.class);
            TestUtils.assertFutureError(memberLevelErrorResult.memberResult(memberOne), UnknownMemberIdException.class);
            Assert.assertNull((Object)memberLevelErrorResult.memberResult(memberTwo).get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(responseTwo))));
            RemoveMembersFromConsumerGroupResult missingMemberResult = env.adminClient().removeMembersFromConsumerGroup(groupId, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            TestUtils.assertFutureError(missingMemberResult.all(), IllegalArgumentException.class);
            TestUtils.assertFutureError(missingMemberResult.memberResult(memberOne), IllegalArgumentException.class);
            Assert.assertNull((Object)missingMemberResult.memberResult(memberTwo).get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseTwo, new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.NONE.code())))));
            RemoveMembersFromConsumerGroupResult noErrorResult = env.adminClient().removeMembersFromConsumerGroup(groupId, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            Assert.assertNull((Object)noErrorResult.all().get());
            Assert.assertNull((Object)noErrorResult.memberResult(memberOne).get());
            Assert.assertNull((Object)noErrorResult.memberResult(memberTwo).get());
            List<TopicPartition> topicPartitions = Arrays.asList(1, 2, 3).stream().map(partition -> new TopicPartition("my_topic", partition.intValue())).collect(Collectors.toList());
            DescribeGroupsResponseData data = KafkaAdminClientTest.prepareDescribeGroupsResponseData(groupId, Arrays.asList("instance-1", "instance-2"), topicPartitions);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseOne, responseTwo))));
            RemoveMembersFromConsumerGroupResult partialFailureResults = env.adminClient().removeMembersFromConsumerGroup(groupId, new RemoveMembersFromConsumerGroupOptions());
            ExecutionException exception = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> {
                Void cfr_ignored_0 = (Void)partialFailureResults.all().get();
            });
            Assert.assertTrue((boolean)(exception.getCause() instanceof KafkaException));
            Assert.assertTrue((boolean)(exception.getCause().getCause() instanceof UnknownMemberIdException));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseTwo, new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.NONE.code())))));
            RemoveMembersFromConsumerGroupResult successResult = env.adminClient().removeMembersFromConsumerGroup(groupId, new RemoveMembersFromConsumerGroupOptions());
            Assert.assertNull((Object)successResult.all().get());
        }
    }

    @Test
    public void testAlterPartitionReassignments() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition tp1 = new TopicPartition("A", 0);
            TopicPartition tp2 = new TopicPartition("B", 0);
            HashMap reassignments = new HashMap();
            reassignments.put(tp1, Optional.empty());
            reassignments.put(tp2, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            AlterPartitionReassignmentsResponseData responseData1 = new AlterPartitionReassignmentsResponseData();
            AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse normalPartitionResponse = new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(0);
            responseData1.setResponses(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(responseData1));
            AlterPartitionReassignmentsResult result1 = env.adminClient().alterPartitionReassignments(reassignments);
            KafkaFuture future1 = result1.all();
            Future future2 = (Future)result1.values().get(tp1);
            TestUtils.assertFutureError(future1, UnknownServerException.class);
            TestUtils.assertFutureError(future2, UnknownServerException.class);
            AlterPartitionReassignmentsResponseData controllerErrResponseData = new AlterPartitionReassignmentsResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage(Errors.NOT_CONTROLLER.message()).setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            MetadataResponse controllerNodeResponse = MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)1, Collections.emptyList());
            AlterPartitionReassignmentsResponseData normalResponse = new AlterPartitionReassignmentsResponseData().setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(controllerErrResponseData));
            env.kafkaClient().prepareResponse((AbstractResponse)controllerNodeResponse);
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(normalResponse));
            AlterPartitionReassignmentsResult controllerErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            controllerErrResult.all().get();
            ((KafkaFuture)controllerErrResult.values().get(tp1)).get();
            ((KafkaFuture)controllerErrResult.values().get(tp2)).get();
            AlterPartitionReassignmentsResponseData partitionLevelErrData = new AlterPartitionReassignmentsResponseData().setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(0).setErrorMessage(Errors.INVALID_REPLICA_ASSIGNMENT.message()).setErrorCode(Errors.INVALID_REPLICA_ASSIGNMENT.code()))), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(partitionLevelErrData));
            AlterPartitionReassignmentsResult partitionLevelErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            TestUtils.assertFutureError((Future)partitionLevelErrResult.values().get(tp1), Errors.INVALID_REPLICA_ASSIGNMENT.exception().getClass());
            ((KafkaFuture)partitionLevelErrResult.values().get(tp2)).get();
            AlterPartitionReassignmentsResponseData topLevelErrResponseData = new AlterPartitionReassignmentsResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.CLUSTER_AUTHORIZATION_FAILED.message()).setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(topLevelErrResponseData));
            AlterPartitionReassignmentsResult topLevelErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            TestUtils.assertFutureError(topLevelErrResult.all(), Errors.CLUSTER_AUTHORIZATION_FAILED.exception().getClass());
            TestUtils.assertFutureError((Future)topLevelErrResult.values().get(tp1), Errors.CLUSTER_AUTHORIZATION_FAILED.exception().getClass());
            TestUtils.assertFutureError((Future)topLevelErrResult.values().get(tp2), Errors.CLUSTER_AUTHORIZATION_FAILED.exception().getClass());
            TopicPartition invalidTopicTP = new TopicPartition("", 0);
            TopicPartition invalidPartitionTP = new TopicPartition("ABC", -1);
            HashMap<TopicPartition, Optional<NewPartitionReassignment>> invalidTopicReassignments = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
            invalidTopicReassignments.put(invalidPartitionTP, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            invalidTopicReassignments.put(invalidTopicTP, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            invalidTopicReassignments.put(tp1, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            AlterPartitionReassignmentsResponseData singlePartResponseData = new AlterPartitionReassignmentsResponseData().setResponses(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(singlePartResponseData));
            AlterPartitionReassignmentsResult unrepresentableTopicResult = env.adminClient().alterPartitionReassignments(invalidTopicReassignments);
            TestUtils.assertFutureError((Future)unrepresentableTopicResult.values().get(invalidTopicTP), InvalidTopicException.class);
            TestUtils.assertFutureError((Future)unrepresentableTopicResult.values().get(invalidPartitionTP), InvalidTopicException.class);
            ((KafkaFuture)unrepresentableTopicResult.values().get(tp1)).get();
            AlterPartitionReassignmentsResponseData noErrResponseData = new AlterPartitionReassignmentsResponseData().setErrorCode(Errors.NONE.code()).setErrorMessage(Errors.NONE.message()).setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(noErrResponseData));
            AlterPartitionReassignmentsResult noErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            noErrResult.all().get();
            ((KafkaFuture)noErrResult.values().get(tp1)).get();
            ((KafkaFuture)noErrResult.values().get(tp2)).get();
        }
    }

    @Test
    public void testListPartitionReassignments() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition tp1 = new TopicPartition("A", 0);
            ListPartitionReassignmentsResponseData.OngoingPartitionReassignment tp1PartitionReassignment = new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setRemovingReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Arrays.asList(4, 5, 6)).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6));
            ListPartitionReassignmentsResponseData.OngoingTopicReassignment tp1Reassignment = new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("A").setPartitions(Collections.singletonList(tp1PartitionReassignment));
            TopicPartition tp2 = new TopicPartition("B", 0);
            ListPartitionReassignmentsResponseData.OngoingPartitionReassignment tp2PartitionReassignment = new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setRemovingReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Arrays.asList(4, 5, 6)).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6));
            ListPartitionReassignmentsResponseData.OngoingTopicReassignment tp2Reassignment = new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("B").setPartitions(Collections.singletonList(tp2PartitionReassignment));
            ListPartitionReassignmentsResponseData notControllerData = new ListPartitionReassignmentsResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage(Errors.NOT_CONTROLLER.message());
            MetadataResponse controllerNodeResponse = MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)1, Collections.emptyList());
            ListPartitionReassignmentsResponseData reassignmentsData = new ListPartitionReassignmentsResponseData().setTopics(Arrays.asList(tp1Reassignment, tp2Reassignment));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(notControllerData));
            env.kafkaClient().prepareResponse((AbstractResponse)controllerNodeResponse);
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(reassignmentsData));
            ListPartitionReassignmentsResult noControllerResult = env.adminClient().listPartitionReassignments();
            noControllerResult.reassignments().get();
            ListPartitionReassignmentsResponseData unknownTpData = new ListPartitionReassignmentsResponseData().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_OR_PARTITION.message());
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(unknownTpData));
            ListPartitionReassignmentsResult unknownTpResult = env.adminClient().listPartitionReassignments(new HashSet<TopicPartition>(Arrays.asList(tp1, tp2)));
            TestUtils.assertFutureError(unknownTpResult.reassignments(), UnknownTopicOrPartitionException.class);
            ListPartitionReassignmentsResponseData responseData = new ListPartitionReassignmentsResponseData().setTopics(Arrays.asList(tp1Reassignment, tp2Reassignment));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(responseData));
            ListPartitionReassignmentsResult responseResult = env.adminClient().listPartitionReassignments();
            Map reassignments = (Map)responseResult.reassignments().get();
            PartitionReassignment tp1Result = (PartitionReassignment)reassignments.get(tp1);
            Assert.assertEquals(tp1PartitionReassignment.addingReplicas(), (Object)tp1Result.addingReplicas());
            Assert.assertEquals(tp1PartitionReassignment.removingReplicas(), (Object)tp1Result.removingReplicas());
            Assert.assertEquals(tp1PartitionReassignment.replicas(), (Object)tp1Result.replicas());
            Assert.assertEquals(tp1PartitionReassignment.replicas(), (Object)tp1Result.replicas());
            PartitionReassignment tp2Result = (PartitionReassignment)reassignments.get(tp2);
            Assert.assertEquals(tp2PartitionReassignment.addingReplicas(), (Object)tp2Result.addingReplicas());
            Assert.assertEquals(tp2PartitionReassignment.removingReplicas(), (Object)tp2Result.removingReplicas());
            Assert.assertEquals(tp2PartitionReassignment.replicas(), (Object)tp2Result.replicas());
            Assert.assertEquals(tp2PartitionReassignment.replicas(), (Object)tp2Result.replicas());
        }
    }

    @Test
    public void testAlterConsumerGroupOffsets() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("foobar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
            responseData.put(tp1, Errors.NONE);
            responseData.put(tp2, Errors.NONE);
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetCommitResponse(0, responseData));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            offsets.put(tp2, new OffsetAndMetadata(456L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets("group-0", offsets);
            Assert.assertNull((Object)result.all().get());
            Assert.assertNull((Object)result.partitionResult(tp1).get());
            Assert.assertNull((Object)result.partitionResult(tp2).get());
            TestUtils.assertFutureError(result.partitionResult(tp3), IllegalArgumentException.class);
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.COORDINATOR_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.COORDINATOR_LOAD_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult result1 = env.adminClient().alterConsumerGroupOffsets("group-0", offsets);
            Assert.assertNull((Object)result1.all().get());
            Assert.assertNull((Object)result1.partitionResult(tp1).get());
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsNonRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, error));
                HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
                offsets.put(tp1, new OffsetAndMetadata(123L));
                AlterConsumerGroupOffsetsResult errorResult = env.adminClient().alterConsumerGroupOffsets("group-0", offsets);
                TestUtils.assertFutureError(errorResult.all(), error.exception().getClass());
                TestUtils.assertFutureError(errorResult.partitionResult(tp1), error.exception().getClass());
            }
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsFindCoordinatorRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets("group-0", offsets);
            Assert.assertNull((Object)result.all().get());
            Assert.assertNull((Object)result.partitionResult(tp1).get());
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsFindCoordinatorNonRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult errorResult = env.adminClient().alterConsumerGroupOffsets("group-0", offsets);
            TestUtils.assertFutureError(errorResult.all(), GroupAuthorizationException.class);
            TestUtils.assertFutureError(errorResult.partitionResult(tp1), GroupAuthorizationException.class);
        }
    }

    @Test
    public void testListOffsets() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("bar", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("baz", 0, node0, new Node[]{node0}, new Node[]{node0}));
        Cluster cluster = new Cluster("mockClusterId", Arrays.asList(node0), pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("bar", 0);
        TopicPartition tp2 = new TopicPartition("baz", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetResponseData.ListOffsetTopicResponse t0 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)123L, (int)321);
            ListOffsetResponseData.ListOffsetTopicResponse t1 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)234L, (int)432);
            ListOffsetResponseData.ListOffsetTopicResponse t2 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp2, (Errors)Errors.NONE, (long)123456789L, (long)345L, (int)543);
            ListOffsetResponseData responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0, t1, t2));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetResponse(responseData));
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.earliest());
            partitions.put(tp2, OffsetSpec.forTimestamp((long)System.currentTimeMillis()));
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assert.assertFalse((boolean)offsets.isEmpty());
            Assert.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assert.assertEquals((long)321L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assert.assertEquals((long)234L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assert.assertEquals((long)432L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
            Assert.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).offset());
            Assert.assertEquals((long)543L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)123456789L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).timestamp());
            Assert.assertEquals(offsets.get(tp0), (Object)result.partitionResult(tp0).get());
            Assert.assertEquals(offsets.get(tp1), (Object)result.partitionResult(tp1).get());
            Assert.assertEquals(offsets.get(tp2), (Object)result.partitionResult(tp2).get());
            try {
                result.partitionResult(new TopicPartition("unknown", 0)).get();
                Assert.fail((String)"should have thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testListOffsetsRetriableErrorOnMetadata() throws Exception {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        Cluster cluster = new Cluster("mockClusterId", nodes, Collections.singleton(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node})), Collections.emptySet(), Collections.emptySet(), node);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.NONE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetResponseData.ListOffsetTopicResponse t0 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)123L, (int)321);
            ListOffsetResponseData responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetResponse(responseData));
            ListOffsetsResult result = env.adminClient().listOffsets(Collections.singletonMap(tp0, OffsetSpec.latest()));
            Map offsets = (Map)result.all().get(3L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)offsets.size());
            Assert.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assert.assertEquals((long)321L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
        }
    }

    @Test
    public void testListOffsetsRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        pInfos.add(new PartitionInfo("foo", 1, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        pInfos.add(new PartitionInfo("bar", 0, node1, new Node[]{node1, node0}, new Node[]{node1, node0}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetResponseData.ListOffsetTopicResponse t0 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp0, (Errors)Errors.LEADER_NOT_AVAILABLE, (long)-1L, (long)123L, (int)321);
            ListOffsetResponseData.ListOffsetTopicResponse t1 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)987L, (int)789);
            ListOffsetResponseData responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0, t1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node0);
            ListOffsetResponseData.ListOffsetTopicResponse t2 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp2, (Errors)Errors.NONE, (long)-1L, (long)456L, (int)654);
            responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t2));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node1);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            t0 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node0);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            partitions.put(tp2, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assert.assertFalse((boolean)offsets.isEmpty());
            Assert.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assert.assertEquals((long)543L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assert.assertEquals((long)987L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assert.assertEquals((long)789L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
            Assert.assertEquals((long)456L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).offset());
            Assert.assertEquals((long)654L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).timestamp());
        }
    }

    @Test
    public void testListOffsetsNonRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetResponseData.ListOffsetTopicResponse t0 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp0, (Errors)Errors.TOPIC_AUTHORIZATION_FAILED, (long)-1L, (long)-1L, (int)-1);
            ListOffsetResponseData responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetResponse(responseData));
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            TestUtils.assertFutureError(result.all(), TopicAuthorizationException.class);
        }
    }

    private Map<String, FeatureUpdate> makeTestFeatureUpdates() {
        return Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)new FeatureUpdate(2, false)), Utils.mkEntry((Object)"test_feature_2", (Object)new FeatureUpdate(3, true))});
    }

    private Map<String, ApiError> makeTestFeatureUpdateErrors(Map<String, FeatureUpdate> updates, Errors error) {
        HashMap<String, ApiError> errors = new HashMap<String, ApiError>();
        for (Map.Entry<String, FeatureUpdate> entry : updates.entrySet()) {
            errors.put(entry.getKey(), new ApiError(error));
        }
        return errors;
    }

    private void testUpdateFeatures(Map<String, FeatureUpdate> featureUpdates, ApiError topLevelError, Map<String, ApiError> featureUpdateErrors) throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponse(body -> body instanceof UpdateFeaturesRequest, (AbstractResponse)UpdateFeaturesResponse.createWithErrors((ApiError)topLevelError, featureUpdateErrors, (int)0));
            Map futures = env.adminClient().updateFeatures(featureUpdates, (UpdateFeaturesOptions)new UpdateFeaturesOptions().timeoutMs(Integer.valueOf(10000))).values();
            for (Map.Entry entry : futures.entrySet()) {
                ExecutionException e;
                KafkaFuture future = (KafkaFuture)entry.getValue();
                ApiError error = featureUpdateErrors.get(entry.getKey());
                if (topLevelError.error() == Errors.NONE) {
                    Assert.assertNotNull((Object)error);
                    if (error.error() == Errors.NONE) {
                        future.get();
                        continue;
                    }
                    e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> {
                        Void cfr_ignored_0 = (Void)future.get();
                    });
                    Assert.assertEquals(e.getCause().getClass(), error.exception().getClass());
                    continue;
                }
                e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> {
                    Void cfr_ignored_0 = (Void)future.get();
                });
                Assert.assertEquals(e.getCause().getClass(), topLevelError.exception().getClass());
            }
        }
    }

    @Test
    public void testUpdateFeaturesDuringSuccess() throws Exception {
        Map<String, FeatureUpdate> updates = this.makeTestFeatureUpdates();
        this.testUpdateFeatures(updates, ApiError.NONE, this.makeTestFeatureUpdateErrors(updates, Errors.NONE));
    }

    @Test
    public void testUpdateFeaturesTopLevelError() throws Exception {
        Map<String, FeatureUpdate> updates = this.makeTestFeatureUpdates();
        this.testUpdateFeatures(updates, new ApiError(Errors.INVALID_REQUEST), new HashMap<String, ApiError>());
    }

    @Test
    public void testUpdateFeaturesInvalidRequestError() throws Exception {
        Map<String, FeatureUpdate> updates = this.makeTestFeatureUpdates();
        this.testUpdateFeatures(updates, ApiError.NONE, this.makeTestFeatureUpdateErrors(updates, Errors.INVALID_REQUEST));
    }

    @Test
    public void testUpdateFeaturesUpdateFailedError() throws Exception {
        Map<String, FeatureUpdate> updates = this.makeTestFeatureUpdates();
        this.testUpdateFeatures(updates, ApiError.NONE, this.makeTestFeatureUpdateErrors(updates, Errors.FEATURE_UPDATE_FAILED));
    }

    @Test
    public void testUpdateFeaturesPartialSuccess() throws Exception {
        Map<String, ApiError> errors = this.makeTestFeatureUpdateErrors(this.makeTestFeatureUpdates(), Errors.NONE);
        errors.put("test_feature_2", new ApiError(Errors.INVALID_REQUEST));
        this.testUpdateFeatures(this.makeTestFeatureUpdates(), ApiError.NONE, errors);
    }

    @Test
    public void testUpdateFeaturesHandleNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponseFrom(request -> request instanceof UpdateFeaturesRequest, (AbstractResponse)UpdateFeaturesResponse.createWithErrors((ApiError)new ApiError(Errors.NOT_CONTROLLER), (Map)Utils.mkMap((Map.Entry[])new Map.Entry[0]), (int)0), env.cluster().nodeById(0));
            boolean controllerId = true;
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)1, Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom(request -> request instanceof UpdateFeaturesRequest, (AbstractResponse)UpdateFeaturesResponse.createWithErrors((ApiError)ApiError.NONE, (Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)ApiError.NONE), Utils.mkEntry((Object)"test_feature_2", (Object)ApiError.NONE)}), (int)0), env.cluster().nodeById(1));
            KafkaFuture future = env.adminClient().updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)new FeatureUpdate(2, false)), Utils.mkEntry((Object)"test_feature_2", (Object)new FeatureUpdate(3, true))}), (UpdateFeaturesOptions)new UpdateFeaturesOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testUpdateFeaturesShouldFailRequestForEmptyUpdates() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            Assert.assertThrows(IllegalArgumentException.class, () -> env.adminClient().updateFeatures(new HashMap(), new UpdateFeaturesOptions()));
        }
    }

    @Test
    public void testUpdateFeaturesShouldFailRequestForInvalidFeatureName() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            Assert.assertThrows(IllegalArgumentException.class, () -> env.adminClient().updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature", (Object)new FeatureUpdate(2, false)), Utils.mkEntry((Object)"", (Object)new FeatureUpdate(2, false))}), new UpdateFeaturesOptions()));
        }
    }

    @Test
    public void testUpdateFeaturesShouldFailRequestInClientWhenDowngradeFlagIsNotSetDuringDeletion() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new FeatureUpdate(0, false));
    }

    @Test
    public void testDescribeFeaturesSuccess() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponse(body -> body instanceof ApiVersionsRequest, (AbstractResponse)KafkaAdminClientTest.prepareApiVersionsResponseForDescribeFeatures(Errors.NONE));
            KafkaFuture future = env.adminClient().describeFeatures((DescribeFeaturesOptions)new DescribeFeaturesOptions().timeoutMs(Integer.valueOf(10000))).featureMetadata();
            FeatureMetadata metadata = (FeatureMetadata)future.get();
            Assert.assertEquals((Object)KafkaAdminClientTest.defaultFeatureMetadata(), (Object)metadata);
        }
    }

    @Test
    public void testDescribeFeaturesHandleNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareApiVersionsResponseForDescribeFeatures(Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)1, Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareApiVersionsResponseForDescribeFeatures(Errors.NONE), env.cluster().nodeById(1));
            DescribeFeaturesOptions options = new DescribeFeaturesOptions();
            options.sendRequestToController(true);
            options.timeoutMs(Integer.valueOf(10000));
            KafkaFuture future = env.adminClient().describeFeatures(options).featureMetadata();
            future.get();
        }
    }

    @Test
    public void testListOffsetsMetadataRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("foo", 1, node1, new Node[]{node1}, new Node[]{node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.LEADER_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.UNKNOWN_TOPIC_OR_PARTITION));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetResponseData.ListOffsetTopicResponse t0 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            ListOffsetResponseData responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node0);
            ListOffsetResponseData.ListOffsetTopicResponse t1 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)789L, (int)987);
            responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node1);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assert.assertFalse((boolean)offsets.isEmpty());
            Assert.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assert.assertEquals((long)543L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assert.assertEquals((long)789L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assert.assertEquals((long)987L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
        }
    }

    @Test
    public void testListOffsetsWithMultiplePartitionsLeaderChange() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        Node node2 = new Node(2, "localhost", 8122);
        List<Node> nodes = Arrays.asList(node0, node1, node2);
        PartitionInfo oldPInfo1 = new PartitionInfo("foo", 0, node0, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
        PartitionInfo oldPnfo2 = new PartitionInfo("foo", 1, node0, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
        List<PartitionInfo> oldPInfos = Arrays.asList(oldPInfo1, oldPnfo2);
        Cluster oldCluster = new Cluster("mockClusterId", nodes, oldPInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(oldCluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(oldCluster, Errors.NONE));
            ListOffsetResponseData.ListOffsetTopicResponse t0 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp0, (Errors)Errors.NOT_LEADER_OR_FOLLOWER, (long)-1L, (long)345L, (int)543);
            ListOffsetResponseData.ListOffsetTopicResponse t1 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp1, (Errors)Errors.LEADER_NOT_AVAILABLE, (long)-2L, (long)123L, (int)456);
            ListOffsetResponseData responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0, t1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node0);
            PartitionInfo newPInfo1 = new PartitionInfo("foo", 0, node1, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
            PartitionInfo newPInfo2 = new PartitionInfo("foo", 1, node2, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
            List<PartitionInfo> newPInfos = Arrays.asList(newPInfo1, newPInfo2);
            Cluster newCluster = new Cluster("mockClusterId", nodes, newPInfos, Collections.emptySet(), Collections.emptySet(), node0);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(newCluster, Errors.NONE));
            t0 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node1);
            t1 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-2L, (long)123L, (int)456);
            responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node2);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assert.assertFalse((boolean)offsets.isEmpty());
            Assert.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assert.assertEquals((long)543L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assert.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assert.assertEquals((long)456L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-2L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
        }
    }

    @Test
    public void testListOffsetsWithLeaderChange() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        Node node2 = new Node(2, "localhost", 8122);
        List<Node> nodes = Arrays.asList(node0, node1, node2);
        PartitionInfo oldPartitionInfo = new PartitionInfo("foo", 0, node0, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
        Cluster oldCluster = new Cluster("mockClusterId", nodes, Collections.singletonList(oldPartitionInfo), Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(oldCluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(oldCluster, Errors.NONE));
            ListOffsetResponseData.ListOffsetTopicResponse t0 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp0, (Errors)Errors.NOT_LEADER_OR_FOLLOWER, (long)-1L, (long)345L, (int)543);
            ListOffsetResponseData responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node0);
            PartitionInfo newPartitionInfo = new PartitionInfo("foo", 0, node1, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
            Cluster newCluster = new Cluster("mockClusterId", nodes, Collections.singletonList(newPartitionInfo), Collections.emptySet(), Collections.emptySet(), node0);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(newCluster, Errors.NONE));
            t0 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-2L, (long)123L, (int)456);
            responseData = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node1);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assert.assertFalse((boolean)offsets.isEmpty());
            Assert.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assert.assertEquals((long)456L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-2L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
        }
    }

    @Test
    public void testListOffsetsMetadataNonRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.TOPIC_AUTHORIZATION_FAILED));
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            TestUtils.assertFutureError(result.all(), TopicAuthorizationException.class);
        }
    }

    @Test
    public void testListOffsetsPartialResponse() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        pInfos.add(new PartitionInfo("foo", 1, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetResponseData.ListOffsetTopicResponse t0 = ListOffsetResponse.singletonListOffsetTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-2L, (long)123L, (int)456);
            ListOffsetResponseData data = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(data), node0);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Assert.assertNotNull((Object)result.partitionResult(tp0).get());
            TestUtils.assertFutureThrows(result.partitionResult(tp1), ApiException.class);
            TestUtils.assertFutureThrows(result.all(), ApiException.class);
        }
    }

    @Test
    public void testGetSubLevelError() {
        List<LeaveGroupRequestData.MemberIdentity> memberIdentities = Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("instance-0"), new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("instance-1"));
        HashMap<LeaveGroupRequestData.MemberIdentity, Errors> errorsMap = new HashMap<LeaveGroupRequestData.MemberIdentity, Errors>();
        errorsMap.put(memberIdentities.get(0), Errors.NONE);
        errorsMap.put(memberIdentities.get(1), Errors.FENCED_INSTANCE_ID);
        Assert.assertEquals(IllegalArgumentException.class, KafkaAdminClient.getSubLevelError(errorsMap, (Object)new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("non-exist-id"), (String)"For unit test").getClass());
        Assert.assertNull((Object)KafkaAdminClient.getSubLevelError(errorsMap, (Object)memberIdentities.get(0), (String)"For unit test"));
        Assert.assertEquals(FencedInstanceIdException.class, KafkaAdminClient.getSubLevelError(errorsMap, (Object)memberIdentities.get(1), (String)"For unit test").getClass());
    }

    @Test
    public void testSuccessfulRetryAfterRequestTimeout() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        Node node0 = new Node(0, "localhost", 8121);
        nodes.put(0, node0);
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Arrays.asList(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0})), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        int requestTimeoutMs = 1000;
        int retryBackoffMs = 100;
        int apiTimeoutMs = 3000;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", String.valueOf(100), "request.timeout.ms", String.valueOf(1000));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ListTopicsResult result = env.adminClient().listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(3000)));
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Timed out waiting for Metadata request to be sent");
            time.sleep(1001L);
            TestUtils.waitForCondition(() -> !env.kafkaClient().hasInFlightRequests(), "Timed out waiting for inFlightRequests to be timed out");
            time.sleep(100L);
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Failed to retry Metadata request");
            env.kafkaClient().respond((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            Assert.assertEquals((long)1L, (long)((Collection)result.listings().get()).size());
            Assert.assertEquals((Object)"foo", (Object)((TopicListing)((Collection)result.listings().get()).iterator().next()).name());
        }
    }

    @Test
    public void testDefaultApiTimeout() throws Exception {
        this.testApiTimeout(1500, 3000, OptionalInt.empty());
    }

    @Test
    public void testDefaultApiTimeoutOverride() throws Exception {
        this.testApiTimeout(1500, 10000, OptionalInt.of(3000));
    }

    private void testApiTimeout(int requestTimeoutMs, int defaultApiTimeoutMs, OptionalInt overrideApiTimeoutMs) throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        Node node0 = new Node(0, "localhost", 8121);
        nodes.put(0, node0);
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Arrays.asList(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0})), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        int retryBackoffMs = 100;
        int effectiveTimeoutMs = overrideApiTimeoutMs.orElse(defaultApiTimeoutMs);
        Assert.assertEquals((String)"This test expects the effective timeout to be twice the request timeout", (long)(2 * requestTimeoutMs), (long)effectiveTimeoutMs);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", String.valueOf(100), "request.timeout.ms", String.valueOf(requestTimeoutMs), "default.api.timeout.ms", String.valueOf(defaultApiTimeoutMs));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ListTopicsOptions options = new ListTopicsOptions();
            overrideApiTimeoutMs.ifPresent(arg_0 -> ((ListTopicsOptions)options).timeoutMs(arg_0));
            ListTopicsResult result = env.adminClient().listTopics(options);
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Timed out waiting for Metadata request to be sent");
            time.sleep(requestTimeoutMs + 1);
            TestUtils.waitForCondition(() -> !env.kafkaClient().hasInFlightRequests(), "Timed out waiting for inFlightRequests to be timed out");
            TestUtils.waitForCondition(() -> {
                boolean hasInflightRequests = env.kafkaClient().hasInFlightRequests();
                if (!hasInflightRequests) {
                    time.sleep(100L);
                }
                return hasInflightRequests;
            }, "Timed out waiting for Metadata request to be sent");
            time.sleep(requestTimeoutMs + 1);
            TestUtils.assertFutureThrows(result.future, TimeoutException.class);
        }
    }

    @Test
    public void testRequestTimeoutExceedingDefaultApiTimeout() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        Node node0 = new Node(0, "localhost", 8121);
        nodes.put(0, node0);
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Arrays.asList(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0})), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        int retryBackoffMs = 100;
        int requestTimeoutMs = 120000;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", String.valueOf(100), "request.timeout.ms", String.valueOf(120000));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ListTopicsOptions options = new ListTopicsOptions();
            ListTopicsResult result = env.adminClient().listTopics(options);
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Timed out waiting for Metadata request to be sent");
            time.sleep(60001L);
            Assert.assertTrue((boolean)env.kafkaClient().hasInFlightRequests());
            time.sleep(60000L);
            TestUtils.assertFutureThrows(result.future, TimeoutException.class);
        }
    }

    private ClientQuotaEntity newClientQuotaEntity(String ... args) {
        Assert.assertTrue((args.length % 2 == 0 ? 1 : 0) != 0);
        HashMap<String, String> entityMap = new HashMap<String, String>(args.length / 2);
        for (int index = 0; index < args.length; index += 2) {
            entityMap.put(args[index], args[index + 1]);
        }
        return new ClientQuotaEntity(entityMap);
    }

    @Test
    public void testDescribeClientQuotas() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String value = "value";
            HashMap<ClientQuotaEntity, Map<String, Double>> responseData = new HashMap<ClientQuotaEntity, Map<String, Double>>();
            ClientQuotaEntity entity1 = this.newClientQuotaEntity("user", "user-1", "client-id", "value");
            ClientQuotaEntity entity2 = this.newClientQuotaEntity("user", "user-2", "client-id", "value");
            responseData.put(entity1, Collections.singletonMap("consumer_byte_rate", 10000.0));
            responseData.put(entity2, Collections.singletonMap("producer_byte_rate", 20000.0));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClientQuotasResponse(responseData, 0));
            ClientQuotaFilter filter = ClientQuotaFilter.contains(Arrays.asList(ClientQuotaFilterComponent.ofEntity((String)"user", (String)"value")));
            DescribeClientQuotasResult result = env.adminClient().describeClientQuotas(filter);
            Map resultData = (Map)result.entities().get();
            Assert.assertEquals((long)resultData.size(), (long)2L);
            Assert.assertTrue((boolean)resultData.containsKey(entity1));
            Map config1 = (Map)resultData.get(entity1);
            Assert.assertEquals((long)config1.size(), (long)1L);
            Assert.assertEquals((double)((Double)config1.get("consumer_byte_rate")), (double)10000.0, (double)1.0E-6);
            Assert.assertTrue((boolean)resultData.containsKey(entity2));
            Map config2 = (Map)resultData.get(entity2);
            Assert.assertEquals((long)config2.size(), (long)1L);
            Assert.assertEquals((double)((Double)config2.get("producer_byte_rate")), (double)20000.0, (double)1.0E-6);
        }
    }

    @Test
    public void testEqualsOfClientQuotaFilterComponent() {
        Assert.assertEquals((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"), (Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"));
        Assert.assertEquals((Object)ClientQuotaFilterComponent.ofEntityType((String)"user"), (Object)ClientQuotaFilterComponent.ofEntityType((String)"user"));
        Assert.assertNotEquals((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"), (Object)ClientQuotaFilterComponent.ofEntityType((String)"user"));
        Assert.assertEquals((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user"), (Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user"));
        Assert.assertNotEquals((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user"), (Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"));
        Assert.assertNotEquals((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user"), (Object)ClientQuotaFilterComponent.ofEntityType((String)"user"));
    }

    @Test
    public void testAlterClientQuotas() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ClientQuotaEntity goodEntity = this.newClientQuotaEntity("user", "user-1");
            ClientQuotaEntity unauthorizedEntity = this.newClientQuotaEntity("user", "user-0");
            ClientQuotaEntity invalidEntity = this.newClientQuotaEntity("", "user-0");
            HashMap<ClientQuotaEntity, ApiError> responseData = new HashMap<ClientQuotaEntity, ApiError>(2);
            responseData.put(goodEntity, new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED, "Authorization failed"));
            responseData.put(unauthorizedEntity, new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED, "Authorization failed"));
            responseData.put(invalidEntity, new ApiError(Errors.INVALID_REQUEST, "Invalid quota entity"));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterClientQuotasResponse(responseData, 0));
            ArrayList<ClientQuotaAlteration> entries = new ArrayList<ClientQuotaAlteration>(3);
            entries.add(new ClientQuotaAlteration(goodEntity, Collections.singleton(new ClientQuotaAlteration.Op("consumer_byte_rate", Double.valueOf(10000.0)))));
            entries.add(new ClientQuotaAlteration(unauthorizedEntity, Collections.singleton(new ClientQuotaAlteration.Op("producer_byte_rate", Double.valueOf(10000.0)))));
            entries.add(new ClientQuotaAlteration(invalidEntity, Collections.singleton(new ClientQuotaAlteration.Op("producer_byte_rate", Double.valueOf(100.0)))));
            AlterClientQuotasResult result = env.adminClient().alterClientQuotas(entries);
            result.values().get(goodEntity);
            TestUtils.assertFutureError((Future)result.values().get(unauthorizedEntity), ClusterAuthorizationException.class);
            TestUtils.assertFutureError((Future)result.values().get(invalidEntity), InvalidRequestException.class);
        }
    }

    @Test
    public void testAlterReplicaLogDirsSuccess() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(0), Errors.NONE, 0);
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(1), Errors.NONE, 0);
            TopicPartitionReplica tpr0 = new TopicPartitionReplica("topic", 0, 0);
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 0, 1);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr0, "/data0");
            logDirs.put(tpr1, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            Assert.assertNull((Object)((KafkaFuture)result.values().get(tpr0)).get());
            Assert.assertNull((Object)((KafkaFuture)result.values().get(tpr1)).get());
        }
    }

    @Test
    public void testAlterReplicaLogDirsLogDirNotFound() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(0), Errors.NONE, 0);
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(1), Errors.LOG_DIR_NOT_FOUND, 0);
            TopicPartitionReplica tpr0 = new TopicPartitionReplica("topic", 0, 0);
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 0, 1);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr0, "/data0");
            logDirs.put(tpr1, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            Assert.assertNull((Object)((KafkaFuture)result.values().get(tpr0)).get());
            TestUtils.assertFutureError((Future)result.values().get(tpr1), LogDirNotFoundException.class);
        }
    }

    @Test
    public void testAlterReplicaLogDirsUnrequested() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(0), Errors.NONE, 1, 2);
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 1, 0);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr1, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            Assert.assertNull((Object)((KafkaFuture)result.values().get(tpr1)).get());
        }
    }

    @Test
    public void testAlterReplicaLogDirsPartialResponse() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(0), Errors.NONE, 1);
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 1, 0);
            TopicPartitionReplica tpr2 = new TopicPartitionReplica("topic", 2, 0);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr1, "/data1");
            logDirs.put(tpr2, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            Assert.assertNull((Object)((KafkaFuture)result.values().get(tpr1)).get());
            TestUtils.assertFutureThrows((Future)result.values().get(tpr2), ApiException.class);
        }
    }

    @Test
    public void testAlterReplicaLogDirsPartialFailure() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "retries", "0");){
            env.kafkaClient().prepareResponseFrom((AbstractResponse)this.prepareAlterLogDirsResponse(Errors.NONE, "topic", 2), env.cluster().nodeById(1));
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 1, 0);
            TopicPartitionReplica tpr2 = new TopicPartitionReplica("topic", 2, 1);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr1, "/data1");
            logDirs.put(tpr2, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting request");
            time.sleep(defaultApiTimeout + 1L);
            TestUtils.assertFutureThrows((Future)result.values().get(tpr1), ApiException.class);
            Assert.assertNull((Object)((KafkaFuture)result.values().get(tpr2)).get());
        }
    }

    @Test
    public void testDescribeUserScramCredentials() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String user0Name = "user0";
            ScramMechanism user0ScramMechanism0 = ScramMechanism.SCRAM_SHA_256;
            int user0Iterations0 = 4096;
            ScramMechanism user0ScramMechanism1 = ScramMechanism.SCRAM_SHA_512;
            int user0Iterations1 = 8192;
            DescribeUserScramCredentialsResponseData.CredentialInfo user0CredentialInfo0 = new DescribeUserScramCredentialsResponseData.CredentialInfo();
            user0CredentialInfo0.setMechanism(user0ScramMechanism0.type());
            user0CredentialInfo0.setIterations(4096);
            DescribeUserScramCredentialsResponseData.CredentialInfo user0CredentialInfo1 = new DescribeUserScramCredentialsResponseData.CredentialInfo();
            user0CredentialInfo1.setMechanism(user0ScramMechanism1.type());
            user0CredentialInfo1.setIterations(8192);
            String user1Name = "user1";
            ScramMechanism user1ScramMechanism = ScramMechanism.SCRAM_SHA_256;
            int user1Iterations = 4096;
            DescribeUserScramCredentialsResponseData.CredentialInfo user1CredentialInfo = new DescribeUserScramCredentialsResponseData.CredentialInfo();
            user1CredentialInfo.setMechanism(user1ScramMechanism.type());
            user1CredentialInfo.setIterations(4096);
            DescribeUserScramCredentialsResponseData responseData = new DescribeUserScramCredentialsResponseData();
            responseData.setResults(Arrays.asList(new DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult().setUser("user0").setCredentialInfos(Arrays.asList(user0CredentialInfo0, user0CredentialInfo1)), new DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult().setUser("user1").setCredentialInfos(Collections.singletonList(user1CredentialInfo))));
            DescribeUserScramCredentialsResponse response = new DescribeUserScramCredentialsResponse(responseData);
            HashSet<String> usersRequestedSet = new HashSet<String>();
            usersRequestedSet.add("user0");
            usersRequestedSet.add("user1");
            for (List users : Arrays.asList(null, new ArrayList(), Arrays.asList("user0", null, "user1"))) {
                env.kafkaClient().prepareResponse((AbstractResponse)response);
                DescribeUserScramCredentialsResult result = env.adminClient().describeUserScramCredentials(users);
                Map descriptionResults = (Map)result.all().get();
                KafkaFuture user0DescriptionFuture = result.description("user0");
                KafkaFuture user1DescriptionFuture = result.description("user1");
                HashSet usersDescribedFromUsersSet = new HashSet((Collection)result.users().get());
                Assert.assertEquals(usersRequestedSet, usersDescribedFromUsersSet);
                Set usersDescribedFromMapKeySet = descriptionResults.keySet();
                Assert.assertEquals(usersRequestedSet, usersDescribedFromMapKeySet);
                UserScramCredentialsDescription userScramCredentialsDescription0 = (UserScramCredentialsDescription)descriptionResults.get("user0");
                Assert.assertEquals((Object)"user0", (Object)userScramCredentialsDescription0.name());
                Assert.assertEquals((long)2L, (long)userScramCredentialsDescription0.credentialInfos().size());
                Assert.assertEquals((Object)user0ScramMechanism0, (Object)((ScramCredentialInfo)userScramCredentialsDescription0.credentialInfos().get(0)).mechanism());
                Assert.assertEquals((long)4096L, (long)((ScramCredentialInfo)userScramCredentialsDescription0.credentialInfos().get(0)).iterations());
                Assert.assertEquals((Object)user0ScramMechanism1, (Object)((ScramCredentialInfo)userScramCredentialsDescription0.credentialInfos().get(1)).mechanism());
                Assert.assertEquals((long)8192L, (long)((ScramCredentialInfo)userScramCredentialsDescription0.credentialInfos().get(1)).iterations());
                Assert.assertEquals((Object)userScramCredentialsDescription0, (Object)user0DescriptionFuture.get());
                UserScramCredentialsDescription userScramCredentialsDescription1 = (UserScramCredentialsDescription)descriptionResults.get("user1");
                Assert.assertEquals((Object)"user1", (Object)userScramCredentialsDescription1.name());
                Assert.assertEquals((long)1L, (long)userScramCredentialsDescription1.credentialInfos().size());
                Assert.assertEquals((Object)user1ScramMechanism, (Object)((ScramCredentialInfo)userScramCredentialsDescription1.credentialInfos().get(0)).mechanism());
                Assert.assertEquals((long)4096L, (long)((ScramCredentialInfo)userScramCredentialsDescription1.credentialInfos().get(0)).iterations());
                Assert.assertEquals((Object)userScramCredentialsDescription1, (Object)user1DescriptionFuture.get());
            }
        }
    }

    @Test
    public void testAlterUserScramCredentialsUnknownMechanism() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String user0Name = "user0";
            ScramMechanism user0ScramMechanism0 = ScramMechanism.UNKNOWN;
            String user1Name = "user1";
            ScramMechanism user1ScramMechanism0 = ScramMechanism.UNKNOWN;
            String user2Name = "user2";
            ScramMechanism user2ScramMechanism0 = ScramMechanism.SCRAM_SHA_256;
            AlterUserScramCredentialsResponseData responseData = new AlterUserScramCredentialsResponseData();
            responseData.setResults(Arrays.asList(new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser("user2")));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterUserScramCredentialsResponse(responseData));
            AlterUserScramCredentialsResult result = env.adminClient().alterUserScramCredentials(Arrays.asList(new UserScramCredentialDeletion("user0", user0ScramMechanism0), new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(user1ScramMechanism0, 8192), "password"), new UserScramCredentialUpsertion("user2", new ScramCredentialInfo(user2ScramMechanism0, 4096), "password")));
            Map resultData = result.values();
            Assert.assertEquals((long)3L, (long)resultData.size());
            Arrays.asList("user0", "user1").stream().forEach(u -> {
                Assert.assertTrue((boolean)resultData.containsKey(u));
                try {
                    ((KafkaFuture)resultData.get(u)).get();
                    Assert.fail((String)("Expected request for user " + u + " to complete exceptionally, but it did not"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            Assert.assertTrue((boolean)resultData.containsKey("user2"));
            try {
                ((KafkaFuture)resultData.get("user2")).get();
            }
            catch (Exception e) {
                Assert.fail((String)"Expected request for user user2 to NOT complete excdptionally, but it did");
            }
            try {
                result.all().get();
                Assert.fail((String)"Expected 'result.all().get()' to throw an exception since at least one user failed, but it did not");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAlterUserScramCredentials() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String user0Name = "user0";
            ScramMechanism user0ScramMechanism0 = ScramMechanism.SCRAM_SHA_256;
            ScramMechanism user0ScramMechanism1 = ScramMechanism.SCRAM_SHA_512;
            String user1Name = "user1";
            ScramMechanism user1ScramMechanism0 = ScramMechanism.SCRAM_SHA_256;
            String user2Name = "user2";
            ScramMechanism user2ScramMechanism0 = ScramMechanism.SCRAM_SHA_512;
            AlterUserScramCredentialsResponseData responseData = new AlterUserScramCredentialsResponseData();
            responseData.setResults(Arrays.asList("user0", "user1", "user2").stream().map(u -> new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser((String)u).setErrorCode(Errors.NONE.code())).collect(Collectors.toList()));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterUserScramCredentialsResponse(responseData));
            AlterUserScramCredentialsResult result = env.adminClient().alterUserScramCredentials(Arrays.asList(new UserScramCredentialDeletion("user0", user0ScramMechanism0), new UserScramCredentialUpsertion("user0", new ScramCredentialInfo(user0ScramMechanism1, 8192), "password"), new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(user1ScramMechanism0, 8192), "password"), new UserScramCredentialDeletion("user2", user2ScramMechanism0)));
            Map resultData = result.values();
            Assert.assertEquals((long)3L, (long)resultData.size());
            Arrays.asList("user0", "user1", "user2").stream().forEach(u -> {
                Assert.assertTrue((boolean)resultData.containsKey(u));
                Assert.assertFalse((boolean)((KafkaFuture)resultData.get(u)).isCompletedExceptionally());
            });
        }
    }

    private void createAlterLogDirsResponse(AdminClientUnitTestEnv env, Node node, Errors error, int ... partitions) {
        env.kafkaClient().prepareResponseFrom((AbstractResponse)this.prepareAlterLogDirsResponse(error, "topic", partitions), node);
    }

    private AlterReplicaLogDirsResponse prepareAlterLogDirsResponse(Errors error, String topic, int ... partitions) {
        return new AlterReplicaLogDirsResponse(new AlterReplicaLogDirsResponseData().setResults(Collections.singletonList(new AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult().setTopicName(topic).setPartitions(Arrays.stream(partitions).boxed().map(partitionId -> new AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult().setPartitionIndex((int)partitionId).setErrorCode(error.code())).collect(Collectors.toList())))));
    }

    @Test
    public void testDescribeLogDirsPartialFailure() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "retries", "0");){
            env.kafkaClient().prepareResponseFrom((AbstractResponse)this.prepareDescribeLogDirsResponse(Errors.NONE, "/data"), env.cluster().nodeById(1));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(Arrays.asList(0, 1));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting request");
            time.sleep(defaultApiTimeout + 1L);
            TestUtils.assertFutureThrows((Future)result.descriptions().get(0), ApiException.class);
            Assert.assertNotNull((Object)((KafkaFuture)result.descriptions().get(1)).get());
        }
    }

    private DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir) {
        return new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(error.code()).setLogDir(logDir))));
    }

    private static MemberDescription convertToMemberDescriptions(DescribeGroupsResponseData.DescribedGroupMember member, MemberAssignment assignment) {
        return new MemberDescription(member.memberId(), Optional.ofNullable(member.groupInstanceId()), member.clientId(), member.clientHost(), assignment);
    }

    @SafeVarargs
    private static <T> void assertCollectionIs(Collection<T> collection, T ... elements) {
        for (T element : elements) {
            Assert.assertTrue((String)("Did not find " + element), (boolean)collection.contains(element));
        }
        Assert.assertEquals((String)"There are unexpected extra elements in the collection.", (long)elements.length, (long)collection.size());
    }

    public static KafkaAdminClient createInternal(AdminClientConfig config, KafkaAdminClient.TimeoutProcessorFactory timeoutProcessorFactory) {
        return KafkaAdminClient.createInternal((AdminClientConfig)config, (KafkaAdminClient.TimeoutProcessorFactory)timeoutProcessorFactory);
    }

    public static class FailureInjectingTimeoutProcessorFactory
    extends KafkaAdminClient.TimeoutProcessorFactory {
        private int numTries = 0;
        private int failuresInjected = 0;

        public KafkaAdminClient.TimeoutProcessor create(long now) {
            return new FailureInjectingTimeoutProcessor(now);
        }

        synchronized boolean shouldInjectFailure() {
            ++this.numTries;
            if (this.numTries == 1) {
                ++this.failuresInjected;
                return true;
            }
            return false;
        }

        public synchronized int failuresInjected() {
            return this.failuresInjected;
        }

        public final class FailureInjectingTimeoutProcessor
        extends KafkaAdminClient.TimeoutProcessor {
            public FailureInjectingTimeoutProcessor(long now) {
                super(now);
            }

            boolean callHasExpired(KafkaAdminClient.Call call) {
                if (!call.isInternal() && FailureInjectingTimeoutProcessorFactory.this.shouldInjectFailure()) {
                    log.debug("Injecting timeout for {}.", (Object)call);
                    return true;
                }
                boolean ret = super.callHasExpired(call);
                log.debug("callHasExpired({}) = {}", (Object)call, (Object)ret);
                return ret;
            }
        }
    }
}

