/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collections;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;

public class AdminClientTestUtils {
    public static ListPartitionReassignmentsResult listPartitionReassignmentsResult(Throwable t) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(t);
        return new ListPartitionReassignmentsResult((KafkaFuture)future);
    }

    public static CreateTopicsResult createTopicsResult(String topic, Throwable t) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(t);
        return new CreateTopicsResult(Collections.singletonMap(topic, future));
    }

    public static DeleteTopicsResult deleteTopicsResult(String topic, Throwable t) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(t);
        return new DeleteTopicsResult(Collections.singletonMap(topic, future));
    }

    public static ListTopicsResult listTopicsResult(String topic) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(topic, new TopicListing(topic, false)));
        return new ListTopicsResult((KafkaFuture)future);
    }

    public static CreatePartitionsResult createPartitionsResult(String topic, Throwable t) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(t);
        return new CreatePartitionsResult(Collections.singletonMap(topic, future));
    }

    public static DescribeTopicsResult describeTopicsResult(String topic, TopicDescription description) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)description);
        return new DescribeTopicsResult(Collections.singletonMap(topic, future));
    }
}

