/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiSet;
import org.apache.kafka.common.utils.ImplicitLinkedHashSet;
import org.apache.kafka.common.utils.ImplicitLinkedHashSetTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ImplicitLinkedHashMultiSetTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testNullForbidden() {
        ImplicitLinkedHashMultiSet multiSet = new ImplicitLinkedHashMultiSet();
        Assert.assertFalse((boolean)multiSet.add(null));
    }

    @Test
    public void testInsertDelete() {
        ImplicitLinkedHashMultiSet multiSet = new ImplicitLinkedHashMultiSet(100);
        ImplicitLinkedHashSetTest.TestElement e1 = new ImplicitLinkedHashSetTest.TestElement(1);
        ImplicitLinkedHashSetTest.TestElement e2 = new ImplicitLinkedHashSetTest.TestElement(1);
        ImplicitLinkedHashSetTest.TestElement e3 = new ImplicitLinkedHashSetTest.TestElement(2);
        multiSet.mustAdd((ImplicitLinkedHashSet.Element)e1);
        multiSet.mustAdd((ImplicitLinkedHashSet.Element)e2);
        multiSet.mustAdd((ImplicitLinkedHashSet.Element)e3);
        Assert.assertFalse((boolean)multiSet.add((ImplicitLinkedHashSet.Element)e3));
        Assert.assertEquals((long)3L, (long)multiSet.size());
        ImplicitLinkedHashMultiSetTest.expectExactTraversal(multiSet.findAll((ImplicitLinkedHashSet.Element)e1).iterator(), e1, e2);
        ImplicitLinkedHashMultiSetTest.expectExactTraversal(multiSet.findAll((ImplicitLinkedHashSet.Element)e3).iterator(), e3);
        multiSet.remove((Object)e2);
        ImplicitLinkedHashMultiSetTest.expectExactTraversal(multiSet.findAll((ImplicitLinkedHashSet.Element)e1).iterator(), e1);
        Assert.assertTrue((boolean)multiSet.contains((Object)e2));
    }

    @Test
    public void testTraversal() {
        ImplicitLinkedHashMultiSet multiSet = new ImplicitLinkedHashMultiSet();
        ImplicitLinkedHashMultiSetTest.expectExactTraversal(multiSet.iterator(), new ImplicitLinkedHashSetTest.TestElement[0]);
        ImplicitLinkedHashSetTest.TestElement e1 = new ImplicitLinkedHashSetTest.TestElement(1);
        ImplicitLinkedHashSetTest.TestElement e2 = new ImplicitLinkedHashSetTest.TestElement(1);
        ImplicitLinkedHashSetTest.TestElement e3 = new ImplicitLinkedHashSetTest.TestElement(2);
        Assert.assertTrue((boolean)multiSet.add((ImplicitLinkedHashSet.Element)e1));
        Assert.assertTrue((boolean)multiSet.add((ImplicitLinkedHashSet.Element)e2));
        Assert.assertTrue((boolean)multiSet.add((ImplicitLinkedHashSet.Element)e3));
        ImplicitLinkedHashMultiSetTest.expectExactTraversal(multiSet.iterator(), e1, e2, e3);
        Assert.assertTrue((boolean)multiSet.remove((Object)e2));
        ImplicitLinkedHashMultiSetTest.expectExactTraversal(multiSet.iterator(), e1, e3);
        Assert.assertTrue((boolean)multiSet.remove((Object)e1));
        ImplicitLinkedHashMultiSetTest.expectExactTraversal(multiSet.iterator(), e3);
    }

    static void expectExactTraversal(Iterator<ImplicitLinkedHashSetTest.TestElement> iterator, ImplicitLinkedHashSetTest.TestElement ... sequence) {
        int i = 0;
        while (iterator.hasNext()) {
            ImplicitLinkedHashSetTest.TestElement element = iterator.next();
            Assert.assertTrue((String)("Iterator yieled " + (i + 1) + " elements, but only " + sequence.length + " were expected."), (i < sequence.length ? 1 : 0) != 0);
            if (sequence[i] != element) {
                Assert.fail((String)("Iterator value number " + (i + 1) + " was incorrect."));
            }
            ++i;
        }
        Assert.assertTrue((String)("Iterator yieled " + (i + 1) + " elements, but " + sequence.length + " were expected."), (i == sequence.length ? 1 : 0) != 0);
    }

    @Test
    public void testEnlargement() {
        int i;
        ImplicitLinkedHashMultiSet multiSet = new ImplicitLinkedHashMultiSet(5);
        Assert.assertEquals((long)11L, (long)multiSet.numSlots());
        ImplicitLinkedHashSetTest.TestElement[] testElements = new ImplicitLinkedHashSetTest.TestElement[]{new ImplicitLinkedHashSetTest.TestElement(100), new ImplicitLinkedHashSetTest.TestElement(101), new ImplicitLinkedHashSetTest.TestElement(102), new ImplicitLinkedHashSetTest.TestElement(100), new ImplicitLinkedHashSetTest.TestElement(101), new ImplicitLinkedHashSetTest.TestElement(105)};
        for (i = 0; i < testElements.length; ++i) {
            Assert.assertTrue((boolean)multiSet.add((ImplicitLinkedHashSet.Element)testElements[i]));
        }
        for (i = 0; i < testElements.length; ++i) {
            Assert.assertFalse((boolean)multiSet.add((ImplicitLinkedHashSet.Element)testElements[i]));
        }
        Assert.assertEquals((long)23L, (long)multiSet.numSlots());
        Assert.assertEquals((long)testElements.length, (long)multiSet.size());
        ImplicitLinkedHashMultiSetTest.expectExactTraversal(multiSet.iterator(), testElements);
        multiSet.remove((Object)testElements[1]);
        Assert.assertEquals((long)23L, (long)multiSet.numSlots());
        Assert.assertEquals((long)5L, (long)multiSet.size());
        ImplicitLinkedHashMultiSetTest.expectExactTraversal(multiSet.iterator(), testElements[0], testElements[2], testElements[3], testElements[4], testElements[5]);
    }

    @Test
    public void testManyInsertsAndDeletes() {
        Random random = new Random(123L);
        LinkedList<ImplicitLinkedHashSetTest.TestElement> existing = new LinkedList<ImplicitLinkedHashSetTest.TestElement>();
        ImplicitLinkedHashMultiSet multiSet = new ImplicitLinkedHashMultiSet();
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 4; ++j) {
                ImplicitLinkedHashSetTest.TestElement testElement = new ImplicitLinkedHashSetTest.TestElement(random.nextInt());
                multiSet.mustAdd((ImplicitLinkedHashSet.Element)testElement);
                existing.add(testElement);
            }
            int elementToRemove = random.nextInt(multiSet.size());
            Iterator iter1 = multiSet.iterator();
            Iterator iter2 = existing.iterator();
            for (int j = 0; j <= elementToRemove; ++j) {
                iter1.next();
                iter2.next();
            }
            iter1.remove();
            iter2.remove();
            this.expectTraversal(multiSet.iterator(), existing.iterator());
        }
    }

    void expectTraversal(Iterator<ImplicitLinkedHashSetTest.TestElement> iter, Iterator<ImplicitLinkedHashSetTest.TestElement> expectedIter) {
        int i = 0;
        while (iter.hasNext()) {
            ImplicitLinkedHashSetTest.TestElement element = iter.next();
            Assert.assertTrue((String)("Iterator yieled " + (i + 1) + " elements, but only " + i + " were expected."), (boolean)expectedIter.hasNext());
            ImplicitLinkedHashSetTest.TestElement expected = expectedIter.next();
            Assert.assertTrue((String)("Iterator value number " + (i + 1) + " was incorrect."), (expected == element ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertFalse((String)("Iterator yieled " + i + " elements, but at least " + (i + 1) + " were expected."), (boolean)expectedIter.hasNext());
    }
}

