/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiSet;
import org.apache.kafka.common.utils.ImplicitLinkedHashSet;

public class AlterReplicaLogDirsRequestData
implements ApiMessage {
    private AlterReplicaLogDirSet dirs = new AlterReplicaLogDirSet(0);
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public AlterReplicaLogDirsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public AlterReplicaLogDirsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public AlterReplicaLogDirsRequestData() {
    }

    public short apiKey() {
        return 34;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.dirs = null;
        } else {
            this.dirs.clear(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.dirs.add(new AlterReplicaLogDir(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        writable.writeInt(this.dirs.size());
        Iterator iterator = this.dirs.iterator();
        while (iterator.hasNext()) {
            AlterReplicaLogDir element = (AlterReplicaLogDir)iterator.next();
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("dirs");
        this.dirs = new AlterReplicaLogDirSet(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.dirs.add(new AlterReplicaLogDir((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        Struct[] nestedObjects = new Struct[this.dirs.size()];
        int i = 0;
        Iterator iterator = this.dirs.iterator();
        while (iterator.hasNext()) {
            AlterReplicaLogDir element = (AlterReplicaLogDir)iterator.next();
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("dirs", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        Iterator iterator = this.dirs.iterator();
        while (iterator.hasNext()) {
            AlterReplicaLogDir element = (AlterReplicaLogDir)iterator.next();
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterReplicaLogDirsRequestData)) {
            return false;
        }
        AlterReplicaLogDirsRequestData other = (AlterReplicaLogDirsRequestData)obj;
        return !(this.dirs == null ? other.dirs != null : !this.dirs.equals((Object)other.dirs));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.dirs == null ? 0 : this.dirs.hashCode());
        return hashCode;
    }

    public String toString() {
        return "AlterReplicaLogDirsRequestData(dirs=" + MessageUtil.deepToString((Iterator)this.dirs.iterator()) + ")";
    }

    public AlterReplicaLogDirSet dirs() {
        return this.dirs;
    }

    public AlterReplicaLogDirsRequestData setDirs(AlterReplicaLogDirSet v) {
        this.dirs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("dirs", (Type)new ArrayOf((Type)AlterReplicaLogDir.SCHEMA_0), "The alterations to make for each directory.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class AlterReplicaLogDirSet
    extends ImplicitLinkedHashMultiSet<AlterReplicaLogDir> {
        public AlterReplicaLogDirSet() {
        }

        public AlterReplicaLogDirSet(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterReplicaLogDirSet(Iterator<AlterReplicaLogDir> iterator) {
            super(iterator);
        }

        public AlterReplicaLogDir find(String path) {
            AlterReplicaLogDir key = new AlterReplicaLogDir();
            key.setPath(path);
            return (AlterReplicaLogDir)this.find(key);
        }

        public List<AlterReplicaLogDir> findAll(String path) {
            AlterReplicaLogDir key = new AlterReplicaLogDir();
            key.setPath(path);
            return this.findAll(key);
        }
    }

    public static class AlterReplicaLogDirTopicSet
    extends ImplicitLinkedHashMultiSet<AlterReplicaLogDirTopic> {
        public AlterReplicaLogDirTopicSet() {
        }

        public AlterReplicaLogDirTopicSet(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterReplicaLogDirTopicSet(Iterator<AlterReplicaLogDirTopic> iterator) {
            super(iterator);
        }

        public AlterReplicaLogDirTopic find(String name) {
            AlterReplicaLogDirTopic key = new AlterReplicaLogDirTopic();
            key.setName(name);
            return (AlterReplicaLogDirTopic)this.find(key);
        }

        public List<AlterReplicaLogDirTopic> findAll(String name) {
            AlterReplicaLogDirTopic key = new AlterReplicaLogDirTopic();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class AlterReplicaLogDirTopic
    implements Message,
    ImplicitLinkedHashSet.Element {
        private String name;
        private List<Integer> partitions;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AlterReplicaLogDirTopic(Readable readable, short version) {
            this.partitions = new ArrayList<Integer>();
            this.read(readable, version);
        }

        public AlterReplicaLogDirTopic(Struct struct, short version) {
            this.partitions = new ArrayList<Integer>();
            this.fromStruct(struct, version);
        }

        public AlterReplicaLogDirTopic() {
            this.name = "";
            this.partitions = new ArrayList<Integer>();
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions = null;
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(readable.readInt());
                }
            }
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (Integer element : this.partitions) {
                writable.writeInt(element.intValue());
            }
        }

        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add((Integer)nestedObject);
            }
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Integer[] nestedObjects = new Integer[this.partitions.size()];
            int i = 0;
            for (Integer element : this.partitions) {
                nestedObjects[i++] = element;
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.name);
            size += 4;
            return size += this.partitions.size() * 4;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterReplicaLogDirTopic)) {
                return false;
            }
            AlterReplicaLogDirTopic other = (AlterReplicaLogDirTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AlterReplicaLogDirTopic(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public AlterReplicaLogDirTopic setName(String v) {
            this.name = v;
            return this;
        }

        public AlterReplicaLogDirTopic setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)Type.INT32), "The partition indexes.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class AlterReplicaLogDir
    implements Message,
    ImplicitLinkedHashSet.Element {
        private String path;
        private AlterReplicaLogDirTopicSet topics;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AlterReplicaLogDir(Readable readable, short version) {
            this.topics = new AlterReplicaLogDirTopicSet(0);
            this.read(readable, version);
        }

        public AlterReplicaLogDir(Struct struct, short version) {
            this.topics = new AlterReplicaLogDirTopicSet(0);
            this.fromStruct(struct, version);
        }

        public AlterReplicaLogDir() {
            this.path = "";
            this.topics = new AlterReplicaLogDirTopicSet(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable readable, short version) {
            this.path = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.topics = null;
            } else {
                this.topics.clear(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    this.topics.add(new AlterReplicaLogDirTopic(readable, version));
                }
            }
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.path);
            writable.writeInt(this.topics.size());
            Iterator iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDirTopic element = (AlterReplicaLogDirTopic)iterator.next();
                element.write(writable, version);
            }
        }

        public void fromStruct(Struct struct, short version) {
            this.path = struct.getString("path");
            Object[] nestedObjects = struct.getArray("topics");
            this.topics = new AlterReplicaLogDirTopicSet(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.topics.add(new AlterReplicaLogDirTopic((Struct)nestedObject, version));
            }
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("path", (Object)this.path);
            Struct[] nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            Iterator iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDirTopic element = (AlterReplicaLogDirTopic)iterator.next();
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("topics", (Object)nestedObjects);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.path);
            size += 4;
            Iterator iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDirTopic element = (AlterReplicaLogDirTopic)iterator.next();
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterReplicaLogDir)) {
                return false;
            }
            AlterReplicaLogDir other = (AlterReplicaLogDir)obj;
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.path == null ? 0 : this.path.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AlterReplicaLogDir(path='" + this.path + "', topics=" + MessageUtil.deepToString((Iterator)this.topics.iterator()) + ")";
        }

        public String path() {
            return this.path;
        }

        public AlterReplicaLogDirTopicSet topics() {
            return this.topics;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public AlterReplicaLogDir setPath(String v) {
            this.path = v;
            return this;
        }

        public AlterReplicaLogDir setTopics(AlterReplicaLogDirTopicSet v) {
            this.topics = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("path", (Type)Type.STRING, "The absolute directory path."), new Field("topics", (Type)new ArrayOf((Type)AlterReplicaLogDirTopic.SCHEMA_0), "The topics to add to the directory.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

