/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiSet;
import org.apache.kafka.common.utils.ImplicitLinkedHashSet;

public class AddPartitionsToTxnRequestData
implements ApiMessage {
    private String transactionalId;
    private long producerId;
    private short producerEpoch;
    private AddPartitionsToTxnTopicSet topics;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public AddPartitionsToTxnRequestData(Readable readable, short version) {
        this.topics = new AddPartitionsToTxnTopicSet(0);
        this.read(readable, version);
    }

    public AddPartitionsToTxnRequestData(Struct struct, short version) {
        this.topics = new AddPartitionsToTxnTopicSet(0);
        this.fromStruct(struct, version);
    }

    public AddPartitionsToTxnRequestData() {
        this.transactionalId = "";
        this.producerId = 0L;
        this.producerEpoch = 0;
        this.topics = new AddPartitionsToTxnTopicSet(0);
    }

    public short apiKey() {
        return 24;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        this.transactionalId = readable.readNullableString();
        this.producerId = readable.readLong();
        this.producerEpoch = readable.readShort();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics = null;
        } else {
            this.topics.clear(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new AddPartitionsToTxnTopic(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        writable.writeString(this.transactionalId);
        writable.writeLong(this.producerId);
        writable.writeShort(this.producerEpoch);
        writable.writeInt(this.topics.size());
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            AddPartitionsToTxnTopic element = (AddPartitionsToTxnTopic)iterator.next();
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        this.transactionalId = struct.getString("transactional_id");
        this.producerId = struct.getLong("producer_id");
        this.producerEpoch = struct.getShort("producer_epoch");
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new AddPartitionsToTxnTopicSet(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new AddPartitionsToTxnTopic((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("transactional_id", (Object)this.transactionalId);
        struct.set("producer_id", (Object)this.producerId);
        struct.set("producer_epoch", (Object)this.producerEpoch);
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            AddPartitionsToTxnTopic element = (AddPartitionsToTxnTopic)iterator.next();
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 2;
        size += MessageUtil.serializedUtf8Length((CharSequence)this.transactionalId);
        size += 8;
        size += 2;
        size += 4;
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            AddPartitionsToTxnTopic element = (AddPartitionsToTxnTopic)iterator.next();
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddPartitionsToTxnRequestData)) {
            return false;
        }
        AddPartitionsToTxnRequestData other = (AddPartitionsToTxnRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        if (this.producerId != other.producerId) {
            return false;
        }
        if (this.producerEpoch != other.producerEpoch) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals((Object)other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "AddPartitionsToTxnRequestData(transactionalId='" + this.transactionalId + "', producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", topics=" + MessageUtil.deepToString((Iterator)this.topics.iterator()) + ")";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public AddPartitionsToTxnTopicSet topics() {
        return this.topics;
    }

    public AddPartitionsToTxnRequestData setTransactionalId(String v) {
        this.transactionalId = v;
        return this;
    }

    public AddPartitionsToTxnRequestData setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public AddPartitionsToTxnRequestData setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    public AddPartitionsToTxnRequestData setTopics(AddPartitionsToTxnTopicSet v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("transactional_id", (Type)Type.STRING, "The transactional id corresponding to the transaction."), new Field("producer_id", (Type)Type.INT64, "Current producer id in use by the transactional id."), new Field("producer_epoch", (Type)Type.INT16, "Current epoch associated with the producer id."), new Field("topics", (Type)new ArrayOf((Type)AddPartitionsToTxnTopic.SCHEMA_0), "The partitions to add to the transation.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class AddPartitionsToTxnTopicSet
    extends ImplicitLinkedHashMultiSet<AddPartitionsToTxnTopic> {
        public AddPartitionsToTxnTopicSet() {
        }

        public AddPartitionsToTxnTopicSet(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnTopicSet(Iterator<AddPartitionsToTxnTopic> iterator) {
            super(iterator);
        }

        public AddPartitionsToTxnTopic find(String name) {
            AddPartitionsToTxnTopic key = new AddPartitionsToTxnTopic();
            key.setName(name);
            return (AddPartitionsToTxnTopic)this.find(key);
        }

        public List<AddPartitionsToTxnTopic> findAll(String name) {
            AddPartitionsToTxnTopic key = new AddPartitionsToTxnTopic();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class AddPartitionsToTxnTopic
    implements Message,
    ImplicitLinkedHashSet.Element {
        private String name;
        private List<Integer> partitions;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AddPartitionsToTxnTopic(Readable readable, short version) {
            this.partitions = new ArrayList<Integer>();
            this.read(readable, version);
        }

        public AddPartitionsToTxnTopic(Struct struct, short version) {
            this.partitions = new ArrayList<Integer>();
            this.fromStruct(struct, version);
        }

        public AddPartitionsToTxnTopic() {
            this.name = "";
            this.partitions = new ArrayList<Integer>();
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions = null;
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(readable.readInt());
                }
            }
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (Integer element : this.partitions) {
                writable.writeInt(element.intValue());
            }
        }

        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add((Integer)nestedObject);
            }
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Integer[] nestedObjects = new Integer[this.partitions.size()];
            int i = 0;
            for (Integer element : this.partitions) {
                nestedObjects[i++] = element;
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.name);
            size += 4;
            return size += this.partitions.size() * 4;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTopic)) {
                return false;
            }
            AddPartitionsToTxnTopic other = (AddPartitionsToTxnTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AddPartitionsToTxnTopic(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public AddPartitionsToTxnTopic setName(String v) {
            this.name = v;
            return this;
        }

        public AddPartitionsToTxnTopic setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The name of the topic."), new Field("partitions", (Type)new ArrayOf((Type)Type.INT32), "The partition indexes to add to the transaction")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

