/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.acl;

import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Test;

public class ResourcePatternFilterTest {
    @Test
    public void shouldBeUnknownIfResourceTypeUnknown() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.UNKNOWN, null, PatternType.LITERAL).isUnknown());
    }

    @Test
    public void shouldBeUnknownIfPatternTypeUnknown() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.GROUP, null, PatternType.UNKNOWN).isUnknown());
    }

    @Test
    public void shouldNotMatchIfDifferentResourceType() {
        Assert.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.GROUP, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldNotMatchIfDifferentName() {
        Assert.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Different", PatternType.PREFIXED).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldNotMatchIfDifferentNameCase() {
        Assert.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "NAME", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldNotMatchIfDifferentPatternType() {
        Assert.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldMatchWhereResourceTypeIsAny() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.ANY, "Name", PatternType.PREFIXED).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldMatchWhereResourceNameIsAny() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.PREFIXED).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldMatchWherePatternTypeIsAny() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.ANY).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldMatchWherePatternTypeIsMatch() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.MATCH).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldMatchLiteralIfExactMatch() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldMatchLiteralIfNameMatchesAndFilterIsOnPatternTypeAny() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.ANY).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldMatchLiteralIfNameMatchesAndFilterIsOnPatternTypeMatch() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.MATCH).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldNotMatchLiteralIfNamePrefixed() {
        Assert.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name-something", PatternType.MATCH).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldMatchLiteralWildcardIfExactMatch() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "*", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)));
    }

    @Test
    public void shouldNotMatchLiteralWildcardAgainstOtherName() {
        Assert.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)));
    }

    @Test
    public void shouldNotMatchLiteralWildcardTheWayAround() {
        Assert.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "*", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldNotMatchLiteralWildcardIfFilterHasPatternTypeOfAny() {
        Assert.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.ANY).matches(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)));
    }

    @Test
    public void shouldMatchLiteralWildcardIfFilterHasPatternTypeOfMatch() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.MATCH).matches(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)));
    }

    @Test
    public void shouldMatchPrefixedIfExactMatch() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.PREFIXED).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldNotMatchIfBothPrefixedAndFilterIsPrefixOfResource() {
        Assert.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.PREFIXED).matches(new ResourcePattern(ResourceType.TOPIC, "Name-something", PatternType.PREFIXED)));
    }

    @Test
    public void shouldNotMatchIfBothPrefixedAndResourceIsPrefixOfFilter() {
        Assert.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name-something", PatternType.PREFIXED).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldNotMatchPrefixedIfNamePrefixedAnyFilterTypeIsAny() {
        Assert.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name-something", PatternType.ANY).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldMatchPrefixedIfNamePrefixedAnyFilterTypeIsMatch() {
        Assert.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name-something", PatternType.MATCH).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }
}

