/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.io.BufferedWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.kafka.message.ClauseGenerator;
import org.apache.kafka.message.CodeBuffer;
import org.apache.kafka.message.FieldSpec;
import org.apache.kafka.message.FieldType;
import org.apache.kafka.message.HeaderGenerator;
import org.apache.kafka.message.IsNullConditional;
import org.apache.kafka.message.MessageClassGenerator;
import org.apache.kafka.message.MessageGenerator;
import org.apache.kafka.message.MessageSpec;
import org.apache.kafka.message.SchemaGenerator;
import org.apache.kafka.message.StructRegistry;
import org.apache.kafka.message.StructSpec;
import org.apache.kafka.message.Target;
import org.apache.kafka.message.VersionConditional;
import org.apache.kafka.message.Versions;

public final class MessageDataGenerator
implements MessageClassGenerator {
    private final StructRegistry structRegistry = new StructRegistry();
    private final HeaderGenerator headerGenerator;
    private final SchemaGenerator schemaGenerator;
    private final CodeBuffer buffer;
    private Versions messageFlexibleVersions;

    MessageDataGenerator(String packageName) {
        this.headerGenerator = new HeaderGenerator(packageName);
        this.schemaGenerator = new SchemaGenerator(this.headerGenerator, this.structRegistry);
        this.buffer = new CodeBuffer();
    }

    @Override
    public String outputName(MessageSpec spec) {
        return spec.dataClassName();
    }

    @Override
    public void generateAndWrite(MessageSpec message, BufferedWriter writer) throws Exception {
        this.generate(message);
        this.write(writer);
    }

    void generate(MessageSpec message) throws Exception {
        if (message.struct().versions().contains((short)Short.MAX_VALUE)) {
            throw new RuntimeException("Message " + message.name() + " does not specify a maximum version.");
        }
        this.structRegistry.register(message);
        this.schemaGenerator.generateSchemas(message);
        this.messageFlexibleVersions = message.flexibleVersions();
        this.generateClass(Optional.of(message), message.dataClassName(), message.struct(), message.struct().versions());
        this.headerGenerator.generate();
    }

    void write(BufferedWriter writer) throws Exception {
        this.headerGenerator.buffer().write(writer);
        this.buffer.write(writer);
    }

    private void generateClass(Optional<MessageSpec> topLevelMessageSpec, String className, StructSpec struct, Versions parentVersions) throws Exception {
        this.buffer.printf("%n", new Object[0]);
        boolean isTopLevel = topLevelMessageSpec.isPresent();
        boolean isSetElement = struct.hasKeys();
        if (isTopLevel && isSetElement) {
            throw new RuntimeException("Cannot set mapKey on top level fields.");
        }
        this.generateClassHeader(className, isTopLevel, isSetElement);
        this.buffer.incrementIndent();
        this.generateFieldDeclarations(struct, isSetElement);
        this.buffer.printf("%n", new Object[0]);
        this.schemaGenerator.writeSchema(className, this.buffer);
        this.generateClassConstructors(className, struct, isSetElement);
        this.buffer.printf("%n", new Object[0]);
        if (isTopLevel) {
            this.generateShortAccessor("apiKey", topLevelMessageSpec.get().apiKey().orElse((short)-1));
        }
        this.buffer.printf("%n", new Object[0]);
        this.generateShortAccessor("lowestSupportedVersion", parentVersions.lowest());
        this.buffer.printf("%n", new Object[0]);
        this.generateShortAccessor("highestSupportedVersion", parentVersions.highest());
        this.buffer.printf("%n", new Object[0]);
        this.generateClassReader(className, struct, parentVersions);
        this.buffer.printf("%n", new Object[0]);
        this.generateClassWriter(className, struct, parentVersions);
        this.buffer.printf("%n", new Object[0]);
        this.generateClassMessageSize(className, struct, parentVersions);
        if (isSetElement) {
            this.buffer.printf("%n", new Object[0]);
            this.generateClassEquals(className, struct, true);
        }
        this.buffer.printf("%n", new Object[0]);
        this.generateClassEquals(className, struct, false);
        this.buffer.printf("%n", new Object[0]);
        this.generateClassHashCode(struct, isSetElement);
        this.buffer.printf("%n", new Object[0]);
        this.generateClassDuplicate(className, struct);
        this.buffer.printf("%n", new Object[0]);
        this.generateClassToString(className, struct);
        this.generateFieldAccessors(struct, isSetElement);
        this.buffer.printf("%n", new Object[0]);
        this.generateUnknownTaggedFieldsAccessor();
        this.generateFieldMutators(struct, className, isSetElement);
        if (!isTopLevel) {
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
        }
        this.generateSubclasses(className, struct, parentVersions, isSetElement);
        if (isTopLevel) {
            Iterator<StructSpec> iter = this.structRegistry.commonStructs();
            while (iter.hasNext()) {
                StructSpec commonStruct = iter.next();
                this.generateClass(Optional.empty(), commonStruct.name(), commonStruct, commonStruct.versions());
            }
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
        }
    }

    private void generateClassHeader(String className, boolean isTopLevel, boolean isSetElement) {
        HashSet<String> implementedInterfaces = new HashSet<String>();
        if (isTopLevel) {
            implementedInterfaces.add("ApiMessage");
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.ApiMessage");
        } else {
            implementedInterfaces.add("Message");
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.Message");
        }
        if (isSetElement) {
            this.headerGenerator.addImport("org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection");
            implementedInterfaces.add("ImplicitLinkedHashMultiCollection.Element");
        }
        LinkedHashSet<String> classModifiers = new LinkedHashSet<String>();
        classModifiers.add("public");
        if (!isTopLevel) {
            classModifiers.add("static");
        }
        this.buffer.printf("%s class %s implements %s {%n", String.join((CharSequence)" ", classModifiers), className, String.join((CharSequence)", ", implementedInterfaces));
    }

    private void generateSubclasses(String className, StructSpec struct, Versions parentVersions, boolean isSetElement) throws Exception {
        for (FieldSpec field : struct.fields()) {
            if (field.type().isStructArray()) {
                FieldType.ArrayType arrayType = (FieldType.ArrayType)field.type();
                if (this.structRegistry.commonStructNames().contains(arrayType.elementName())) continue;
                this.generateClass(Optional.empty(), arrayType.elementType().toString(), this.structRegistry.findStruct(field), parentVersions.intersect(struct.versions()));
                continue;
            }
            if (!field.type().isStruct() || this.structRegistry.commonStructNames().contains(field.typeString())) continue;
            this.generateClass(Optional.empty(), field.typeString(), this.structRegistry.findStruct(field), parentVersions.intersect(struct.versions()));
        }
        if (isSetElement) {
            this.generateHashSet(className, struct);
        }
    }

    private void generateHashSet(String className, StructSpec struct) {
        this.buffer.printf("%n", new Object[0]);
        this.headerGenerator.addImport("org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection");
        this.buffer.printf("public static class %s extends ImplicitLinkedHashMultiCollection<%s> {%n", FieldSpec.collectionType(className), className);
        this.buffer.incrementIndent();
        this.generateHashSetZeroArgConstructor(className);
        this.buffer.printf("%n", new Object[0]);
        this.generateHashSetSizeArgConstructor(className);
        this.buffer.printf("%n", new Object[0]);
        this.generateHashSetIteratorConstructor(className);
        this.buffer.printf("%n", new Object[0]);
        this.generateHashSetFindMethod(className, struct);
        this.buffer.printf("%n", new Object[0]);
        this.generateHashSetFindAllMethod(className, struct);
        this.buffer.printf("%n", new Object[0]);
        this.generateCollectionDuplicateMethod(className);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateHashSetZeroArgConstructor(String className) {
        this.buffer.printf("public %s() {%n", FieldSpec.collectionType(className));
        this.buffer.incrementIndent();
        this.buffer.printf("super();%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateHashSetSizeArgConstructor(String className) {
        this.buffer.printf("public %s(int expectedNumElements) {%n", FieldSpec.collectionType(className));
        this.buffer.incrementIndent();
        this.buffer.printf("super(expectedNumElements);%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateHashSetIteratorConstructor(String className) {
        this.headerGenerator.addImport("java.util.Iterator");
        this.buffer.printf("public %s(Iterator<%s> iterator) {%n", FieldSpec.collectionType(className), className);
        this.buffer.incrementIndent();
        this.buffer.printf("super(iterator);%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateHashSetFindMethod(String className, StructSpec struct) {
        this.headerGenerator.addImport("java.util.List");
        this.buffer.printf("public %s find(%s) {%n", className, this.commaSeparatedHashSetFieldAndTypes(struct));
        this.buffer.incrementIndent();
        this.generateKeyElement(className, struct);
        this.headerGenerator.addImport("org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection");
        this.buffer.printf("return find(_key);%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateHashSetFindAllMethod(String className, StructSpec struct) {
        this.headerGenerator.addImport("java.util.List");
        this.buffer.printf("public List<%s> findAll(%s) {%n", className, this.commaSeparatedHashSetFieldAndTypes(struct));
        this.buffer.incrementIndent();
        this.generateKeyElement(className, struct);
        this.headerGenerator.addImport("org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection");
        this.buffer.printf("return findAll(_key);%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateKeyElement(String className, StructSpec struct) {
        this.buffer.printf("%s _key = new %s();%n", className, className);
        for (FieldSpec field : struct.fields()) {
            if (!field.mapKey()) continue;
            this.buffer.printf("_key.set%s(%s);%n", field.capitalizedCamelCaseName(), field.camelCaseName());
        }
    }

    private String commaSeparatedHashSetFieldAndTypes(StructSpec struct) {
        return struct.fields().stream().filter(f -> f.mapKey()).map(f -> String.format("%s %s", f.concreteJavaType(this.headerGenerator, this.structRegistry), f.camelCaseName())).collect(Collectors.joining(", "));
    }

    private void generateCollectionDuplicateMethod(String className) {
        this.headerGenerator.addImport("java.util.List");
        this.buffer.printf("public %s duplicate() {%n", FieldSpec.collectionType(className));
        this.buffer.incrementIndent();
        this.buffer.printf("%s _duplicate = new %s(size());%n", FieldSpec.collectionType(className), FieldSpec.collectionType(className));
        this.buffer.printf("for (%s _element : this) {%n", className);
        this.buffer.incrementIndent();
        this.buffer.printf("_duplicate.add(_element.duplicate());%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.printf("return _duplicate;%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateFieldDeclarations(StructSpec struct, boolean isSetElement) {
        for (FieldSpec field : struct.fields()) {
            this.generateFieldDeclaration(field);
        }
        this.headerGenerator.addImport("java.util.List");
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.RawTaggedField");
        this.buffer.printf("private List<RawTaggedField> _unknownTaggedFields;%n", new Object[0]);
        if (isSetElement) {
            this.buffer.printf("private int next;%n", new Object[0]);
            this.buffer.printf("private int prev;%n", new Object[0]);
        }
    }

    private void generateFieldDeclaration(FieldSpec field) {
        this.buffer.printf("%s %s;%n", field.fieldAbstractJavaType(this.headerGenerator, this.structRegistry), field.camelCaseName());
    }

    private void generateFieldAccessors(StructSpec struct, boolean isSetElement) {
        for (FieldSpec field : struct.fields()) {
            this.generateFieldAccessor(field);
        }
        if (isSetElement) {
            this.buffer.printf("%n", new Object[0]);
            this.buffer.printf("@Override%n", new Object[0]);
            this.generateAccessor("int", "next", "next");
            this.buffer.printf("%n", new Object[0]);
            this.buffer.printf("@Override%n", new Object[0]);
            this.generateAccessor("int", "prev", "prev");
        }
    }

    private void generateUnknownTaggedFieldsAccessor() {
        this.buffer.printf("@Override%n", new Object[0]);
        this.headerGenerator.addImport("java.util.List");
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.RawTaggedField");
        this.buffer.printf("public List<RawTaggedField> unknownTaggedFields() {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("if (_unknownTaggedFields == null) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.headerGenerator.addImport("java.util.ArrayList");
        this.buffer.printf("_unknownTaggedFields = new ArrayList<>(0);%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.printf("return _unknownTaggedFields;%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateFieldMutators(StructSpec struct, String className, boolean isSetElement) {
        for (FieldSpec field : struct.fields()) {
            this.generateFieldMutator(className, field);
        }
        if (isSetElement) {
            this.buffer.printf("%n", new Object[0]);
            this.buffer.printf("@Override%n", new Object[0]);
            this.generateSetter("int", "setNext", "next");
            this.buffer.printf("%n", new Object[0]);
            this.buffer.printf("@Override%n", new Object[0]);
            this.generateSetter("int", "setPrev", "prev");
        }
    }

    private void generateClassConstructors(String className, StructSpec struct, boolean isSetElement) {
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.Readable");
        this.buffer.printf("public %s(Readable _readable, short _version) {%n", className);
        this.buffer.incrementIndent();
        this.buffer.printf("read(_readable, _version);%n", new Object[0]);
        this.generateConstructorEpilogue(isSetElement);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.printf("%n", new Object[0]);
        this.buffer.printf("public %s() {%n", className);
        this.buffer.incrementIndent();
        for (FieldSpec field : struct.fields()) {
            this.buffer.printf("this.%s = %s;%n", field.camelCaseName(), field.fieldDefault(this.headerGenerator, this.structRegistry));
        }
        this.generateConstructorEpilogue(isSetElement);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateConstructorEpilogue(boolean isSetElement) {
        if (isSetElement) {
            this.headerGenerator.addImport("org.apache.kafka.common.utils.ImplicitLinkedHashCollection");
            this.buffer.printf("this.prev = ImplicitLinkedHashCollection.INVALID_INDEX;%n", new Object[0]);
            this.buffer.printf("this.next = ImplicitLinkedHashCollection.INVALID_INDEX;%n", new Object[0]);
        }
    }

    private void generateShortAccessor(String name, short val) {
        this.buffer.printf("@Override%n", new Object[0]);
        this.buffer.printf("public short %s() {%n", name);
        this.buffer.incrementIndent();
        this.buffer.printf("return %d;%n", val);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateClassReader(String className, StructSpec struct, Versions parentVersions) {
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.Readable");
        this.buffer.printf("@Override%n", new Object[0]);
        this.buffer.printf("public void read(Readable _readable, short _version) {%n", new Object[0]);
        this.buffer.incrementIndent();
        VersionConditional.forVersions(parentVersions, struct.versions()).allowMembershipCheckAlwaysFalse(false).ifNotMember(__ -> {
            this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
            this.buffer.printf("throw new UnsupportedVersionException(\"Can't read version \" + _version + \" of %s\");%n", className);
        }).generate(this.buffer);
        Versions curVersions = parentVersions.intersect(struct.versions());
        for (FieldSpec field : struct.fields()) {
            Versions fieldFlexibleVersions = this.fieldFlexibleVersions(field);
            if (!field.taggedVersions().intersect(fieldFlexibleVersions).equals(field.taggedVersions())) {
                throw new RuntimeException("Field " + field.name() + " specifies tagged versions " + field.taggedVersions() + " that are not a subset of the flexible versions " + fieldFlexibleVersions);
            }
            Versions mandatoryVersions = field.versions().subtract(field.taggedVersions());
            VersionConditional.forVersions(mandatoryVersions, curVersions).alwaysEmitBlockScope(field.type().isVariableLength()).ifNotMember(__ -> this.buffer.printf("this.%s = %s;%n", field.camelCaseName(), field.fieldDefault(this.headerGenerator, this.structRegistry))).ifMember(presentAndUntaggedVersions -> {
                if (field.type().isVariableLength() && !field.type().isStruct()) {
                    ClauseGenerator callGenerateVariableLengthReader = versions -> this.generateVariableLengthReader(this.fieldFlexibleVersions(field), field.camelCaseName(), field.type(), versions, field.nullableVersions(), String.format("this.%s = ", field.camelCaseName()), String.format(";%n", new Object[0]), this.structRegistry.isStructArrayWithKeys(field), field.zeroCopy());
                    if (field.type().isArray() && ((FieldType.ArrayType)field.type()).elementType().serializationIsDifferentInFlexibleVersions()) {
                        VersionConditional.forVersions(this.fieldFlexibleVersions(field), presentAndUntaggedVersions).ifMember(callGenerateVariableLengthReader).ifNotMember(callGenerateVariableLengthReader).generate(this.buffer);
                    } else {
                        callGenerateVariableLengthReader.generate(presentAndUntaggedVersions);
                    }
                } else {
                    this.buffer.printf("this.%s = %s;%n", field.camelCaseName(), this.primitiveReadExpression(field.type()));
                }
            }).generate(this.buffer);
        }
        this.buffer.printf("this._unknownTaggedFields = null;%n", new Object[0]);
        VersionConditional.forVersions(this.messageFlexibleVersions, curVersions).ifMember(curFlexibleVersions -> {
            this.buffer.printf("int _numTaggedFields = _readable.readUnsignedVarint();%n", new Object[0]);
            this.buffer.printf("for (int _i = 0; _i < _numTaggedFields; _i++) {%n", new Object[0]);
            this.buffer.incrementIndent();
            this.buffer.printf("int _tag = _readable.readUnsignedVarint();%n", new Object[0]);
            this.buffer.printf("int _size = _readable.readUnsignedVarint();%n", new Object[0]);
            this.buffer.printf("switch (_tag) {%n", new Object[0]);
            this.buffer.incrementIndent();
            for (FieldSpec field : struct.fields()) {
                Versions validTaggedVersions = field.versions().intersect(field.taggedVersions());
                if (validTaggedVersions.empty()) continue;
                if (!field.tag().isPresent()) {
                    throw new RuntimeException("Field " + field.name() + " has tagged versions, but no tag.");
                }
                this.buffer.printf("case %d: {%n", field.tag().get());
                this.buffer.incrementIndent();
                VersionConditional.forVersions(validTaggedVersions, curFlexibleVersions).ifMember(presentAndTaggedVersions -> {
                    if (field.type().isVariableLength() && !field.type().isStruct()) {
                        this.generateVariableLengthReader(this.fieldFlexibleVersions(field), field.camelCaseName(), field.type(), presentAndTaggedVersions, field.nullableVersions(), String.format("this.%s = ", field.camelCaseName()), String.format(";%n", new Object[0]), this.structRegistry.isStructArrayWithKeys(field), field.zeroCopy());
                    } else {
                        this.buffer.printf("this.%s = %s;%n", field.camelCaseName(), this.primitiveReadExpression(field.type()));
                    }
                    this.buffer.printf("break;%n", new Object[0]);
                }).ifNotMember(__ -> this.buffer.printf("throw new RuntimeException(\"Tag %d is not valid for version \" + _version);%n", field.tag().get())).generate(this.buffer);
                this.buffer.decrementIndent();
                this.buffer.printf("}%n", new Object[0]);
            }
            this.buffer.printf("default:%n", new Object[0]);
            this.buffer.incrementIndent();
            this.buffer.printf("this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);%n", new Object[0]);
            this.buffer.printf("break;%n", new Object[0]);
            this.buffer.decrementIndent();
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
        }).generate(this.buffer);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private String primitiveReadExpression(FieldType type) {
        if (type instanceof FieldType.BoolFieldType) {
            return "_readable.readByte() != 0";
        }
        if (type instanceof FieldType.Int8FieldType) {
            return "_readable.readByte()";
        }
        if (type instanceof FieldType.Int16FieldType) {
            return "_readable.readShort()";
        }
        if (type instanceof FieldType.Uint16FieldType) {
            return "_readable.readUnsignedShort()";
        }
        if (type instanceof FieldType.Int32FieldType) {
            return "_readable.readInt()";
        }
        if (type instanceof FieldType.Int64FieldType) {
            return "_readable.readLong()";
        }
        if (type instanceof FieldType.UUIDFieldType) {
            return "_readable.readUuid()";
        }
        if (type instanceof FieldType.Float64FieldType) {
            return "_readable.readDouble()";
        }
        if (type.isStruct()) {
            return String.format("new %s(_readable, _version)", type.toString());
        }
        throw new RuntimeException("Unsupported field type " + type);
    }

    private void generateVariableLengthReader(Versions fieldFlexibleVersions, String name, FieldType type, Versions possibleVersions, Versions nullableVersions, String assignmentPrefix, String assignmentSuffix, boolean isStructArrayWithKeys, boolean zeroCopy) {
        String lengthVar = type.isArray() ? "arrayLength" : "length";
        this.buffer.printf("int %s;%n", lengthVar);
        VersionConditional.forVersions(fieldFlexibleVersions, possibleVersions).ifMember(__ -> this.buffer.printf("%s = _readable.readUnsignedVarint() - 1;%n", lengthVar)).ifNotMember(__ -> {
            if (type.isString()) {
                this.buffer.printf("%s = _readable.readShort();%n", lengthVar);
            } else if (type.isBytes() || type.isArray() || type.isRecords()) {
                this.buffer.printf("%s = _readable.readInt();%n", lengthVar);
            } else {
                throw new RuntimeException("Can't handle variable length type " + type);
            }
        }).generate(this.buffer);
        this.buffer.printf("if (%s < 0) {%n", lengthVar);
        this.buffer.incrementIndent();
        VersionConditional.forVersions(nullableVersions, possibleVersions).ifNotMember(__ -> this.buffer.printf("throw new RuntimeException(\"non-nullable field %s was serialized as null\");%n", name)).ifMember(__ -> this.buffer.printf("%snull%s", assignmentPrefix, assignmentSuffix)).generate(this.buffer);
        this.buffer.decrementIndent();
        if (type.isString()) {
            this.buffer.printf("} else if (%s > 0x7fff) {%n", lengthVar);
            this.buffer.incrementIndent();
            this.buffer.printf("throw new RuntimeException(\"string field %s had invalid length \" + %s);%n", name, lengthVar);
            this.buffer.decrementIndent();
        }
        this.buffer.printf("} else {%n", new Object[0]);
        this.buffer.incrementIndent();
        if (type.isString()) {
            this.buffer.printf("%s_readable.readString(%s)%s", assignmentPrefix, lengthVar, assignmentSuffix);
        } else if (type.isBytes()) {
            if (zeroCopy) {
                this.buffer.printf("%s_readable.readByteBuffer(%s)%s", assignmentPrefix, lengthVar, assignmentSuffix);
            } else {
                this.buffer.printf("byte[] newBytes = new byte[%s];%n", lengthVar);
                this.buffer.printf("_readable.readArray(newBytes);%n", new Object[0]);
                this.buffer.printf("%snewBytes%s", assignmentPrefix, assignmentSuffix);
            }
        } else if (type.isRecords()) {
            this.buffer.printf("%s_readable.readRecords(%s)%s", assignmentPrefix, lengthVar, assignmentSuffix);
        } else if (type.isArray()) {
            FieldType.ArrayType arrayType = (FieldType.ArrayType)type;
            if (isStructArrayWithKeys) {
                this.headerGenerator.addImport("org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection");
                this.buffer.printf("%s newCollection = new %s(%s);%n", FieldSpec.collectionType(arrayType.elementType().toString()), FieldSpec.collectionType(arrayType.elementType().toString()), lengthVar);
            } else {
                this.headerGenerator.addImport("java.util.ArrayList");
                String boxedArrayType = arrayType.elementType().getBoxedJavaType(this.headerGenerator);
                this.buffer.printf("ArrayList<%s> newCollection = new ArrayList<>(%s);%n", boxedArrayType, lengthVar);
            }
            this.buffer.printf("for (int i = 0; i < %s; i++) {%n", lengthVar);
            this.buffer.incrementIndent();
            if (arrayType.elementType().isArray()) {
                throw new RuntimeException("Nested arrays are not supported.  Use an array of structures containing another array.");
            }
            if (arrayType.elementType().isBytes() || arrayType.elementType().isString()) {
                this.generateVariableLengthReader(fieldFlexibleVersions, name + " element", arrayType.elementType(), possibleVersions, Versions.NONE, "newCollection.add(", String.format(");%n", new Object[0]), false, false);
            } else {
                this.buffer.printf("newCollection.add(%s);%n", this.primitiveReadExpression(arrayType.elementType()));
            }
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
            this.buffer.printf("%snewCollection%s", assignmentPrefix, assignmentSuffix);
        } else {
            throw new RuntimeException("Can't handle variable length type " + type);
        }
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateClassWriter(String className, StructSpec struct, Versions parentVersions) {
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.Writable");
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.ObjectSerializationCache");
        this.buffer.printf("@Override%n", new Object[0]);
        this.buffer.printf("public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {%n", new Object[0]);
        this.buffer.incrementIndent();
        VersionConditional.forVersions(struct.versions(), parentVersions).allowMembershipCheckAlwaysFalse(false).ifNotMember(__ -> {
            this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
            this.buffer.printf("throw new UnsupportedVersionException(\"Can't write version \" + _version + \" of %s\");%n", className);
        }).generate(this.buffer);
        this.buffer.printf("int _numTaggedFields = 0;%n", new Object[0]);
        Versions curVersions = parentVersions.intersect(struct.versions());
        TreeMap taggedFields = new TreeMap();
        for (FieldSpec field : struct.fields()) {
            VersionConditional cond = VersionConditional.forVersions(field.versions(), curVersions).ifMember(presentVersions -> VersionConditional.forVersions(field.taggedVersions(), presentVersions).ifNotMember(presentAndUntaggedVersions -> {
                if (field.type().isVariableLength() && !field.type().isStruct()) {
                    ClauseGenerator callGenerateVariableLengthWriter = versions -> this.generateVariableLengthWriter(this.fieldFlexibleVersions(field), field.camelCaseName(), field.type(), versions, field.nullableVersions(), field.zeroCopy());
                    if (field.type().isArray() && ((FieldType.ArrayType)field.type()).elementType().serializationIsDifferentInFlexibleVersions()) {
                        VersionConditional.forVersions(this.fieldFlexibleVersions(field), presentAndUntaggedVersions).ifMember(callGenerateVariableLengthWriter).ifNotMember(callGenerateVariableLengthWriter).generate(this.buffer);
                    } else {
                        callGenerateVariableLengthWriter.generate(presentAndUntaggedVersions);
                    }
                } else {
                    this.buffer.printf("%s;%n", this.primitiveWriteExpression(field.type(), field.camelCaseName()));
                }
            }).ifMember(__ -> {
                field.generateNonDefaultValueCheck(this.headerGenerator, this.structRegistry, this.buffer, "this.", field.nullableVersions());
                this.buffer.incrementIndent();
                this.buffer.printf("_numTaggedFields++;%n", new Object[0]);
                this.buffer.decrementIndent();
                this.buffer.printf("}%n", new Object[0]);
                if (taggedFields.put(field.tag().get(), field) != null) {
                    throw new RuntimeException("Field " + field.name() + " has tag " + field.tag() + ", but another field already used that tag.");
                }
            }).generate(this.buffer));
            if (!field.ignorable()) {
                cond.ifNotMember(__ -> field.generateNonIgnorableFieldCheck(this.headerGenerator, this.structRegistry, "this.", this.buffer));
            }
            cond.generate(this.buffer);
        }
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.RawTaggedFieldWriter");
        this.buffer.printf("RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);%n", new Object[0]);
        this.buffer.printf("_numTaggedFields += _rawWriter.numFields();%n", new Object[0]);
        VersionConditional.forVersions(this.messageFlexibleVersions, curVersions).ifNotMember(__ -> this.generateCheckForUnsupportedNumTaggedFields("_numTaggedFields > 0")).ifMember(__ -> {
            this.buffer.printf("_writable.writeUnsignedVarint(_numTaggedFields);%n", new Object[0]);
            int prevTag = -1;
            for (FieldSpec field : taggedFields.values()) {
                if (prevTag + 1 != field.tag().get()) {
                    this.buffer.printf("_rawWriter.writeRawTags(_writable, %d);%n", field.tag().get());
                }
                VersionConditional.forVersions(field.versions(), field.taggedVersions().intersect(field.versions())).allowMembershipCheckAlwaysFalse(false).ifMember(presentAndTaggedVersions -> {
                    IsNullConditional cond = IsNullConditional.forName(field.camelCaseName()).nullableVersions(field.nullableVersions()).possibleVersions(presentAndTaggedVersions).alwaysEmitBlockScope(true).ifShouldNotBeNull(() -> {
                        if (!field.defaultString().equals("null")) {
                            field.generateNonDefaultValueCheck(this.headerGenerator, this.structRegistry, this.buffer, "this.", Versions.NONE);
                            this.buffer.incrementIndent();
                        }
                        this.buffer.printf("_writable.writeUnsignedVarint(%d);%n", field.tag().get());
                        if (field.type().isString()) {
                            this.buffer.printf("byte[] _stringBytes = _cache.getSerializedValue(this.%s);%n", field.camelCaseName());
                            this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
                            this.buffer.printf("_writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));%n", new Object[0]);
                            this.buffer.printf("_writable.writeUnsignedVarint(_stringBytes.length + 1);%n", new Object[0]);
                            this.buffer.printf("_writable.writeByteArray(_stringBytes);%n", new Object[0]);
                        } else if (field.type().isBytes()) {
                            this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
                            this.buffer.printf("_writable.writeUnsignedVarint(this.%s.length + ByteUtils.sizeOfUnsignedVarint(this.%s.length + 1));%n", field.camelCaseName(), field.camelCaseName());
                            this.buffer.printf("_writable.writeUnsignedVarint(this.%s.length + 1);%n", field.camelCaseName());
                            this.buffer.printf("_writable.writeByteArray(this.%s);%n", field.camelCaseName());
                        } else if (field.type().isArray()) {
                            this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
                            this.buffer.printf("_writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.%s));%n", field.camelCaseName());
                            this.generateVariableLengthWriter(this.fieldFlexibleVersions(field), field.camelCaseName(), field.type(), presentAndTaggedVersions, Versions.NONE, field.zeroCopy());
                        } else if (field.type().isStruct()) {
                            this.buffer.printf("_writable.writeUnsignedVarint(this.%s.size(_cache, _version));%n", field.camelCaseName());
                            this.buffer.printf("%s;%n", this.primitiveWriteExpression(field.type(), field.camelCaseName()));
                        } else {
                            if (field.type().isRecords()) {
                                throw new RuntimeException("Unsupported attempt to declare field `" + field.name() + "` with `records` type as a tagged field.");
                            }
                            this.buffer.printf("_writable.writeUnsignedVarint(%d);%n", field.type().fixedLength().get());
                            this.buffer.printf("%s;%n", this.primitiveWriteExpression(field.type(), field.camelCaseName()));
                        }
                        if (!field.defaultString().equals("null")) {
                            this.buffer.decrementIndent();
                            this.buffer.printf("}%n", new Object[0]);
                        }
                    });
                    if (!field.defaultString().equals("null")) {
                        cond.ifNull(() -> {
                            this.buffer.printf("_writable.writeUnsignedVarint(%d);%n", field.tag().get());
                            this.buffer.printf("_writable.writeUnsignedVarint(1);%n", new Object[0]);
                            this.buffer.printf("_writable.writeUnsignedVarint(0);%n", new Object[0]);
                        });
                    }
                    cond.generate(this.buffer);
                }).generate(this.buffer);
                prevTag = field.tag().get();
            }
            if (prevTag < Integer.MAX_VALUE) {
                this.buffer.printf("_rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);%n", new Object[0]);
            }
        }).generate(this.buffer);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateCheckForUnsupportedNumTaggedFields(String conditional) {
        this.buffer.printf("if (%s) {%n", conditional);
        this.buffer.incrementIndent();
        this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
        this.buffer.printf("throw new UnsupportedVersionException(\"Tagged fields were set, but version \" + _version + \" of this message does not support them.\");%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private String primitiveWriteExpression(FieldType type, String name) {
        if (type instanceof FieldType.BoolFieldType) {
            return String.format("_writable.writeByte(%s ? (byte) 1 : (byte) 0)", name);
        }
        if (type instanceof FieldType.Int8FieldType) {
            return String.format("_writable.writeByte(%s)", name);
        }
        if (type instanceof FieldType.Int16FieldType) {
            return String.format("_writable.writeShort(%s)", name);
        }
        if (type instanceof FieldType.Uint16FieldType) {
            return String.format("_writable.writeUnsignedShort(%s)", name);
        }
        if (type instanceof FieldType.Int32FieldType) {
            return String.format("_writable.writeInt(%s)", name);
        }
        if (type instanceof FieldType.Int64FieldType) {
            return String.format("_writable.writeLong(%s)", name);
        }
        if (type instanceof FieldType.UUIDFieldType) {
            return String.format("_writable.writeUuid(%s)", name);
        }
        if (type instanceof FieldType.Float64FieldType) {
            return String.format("_writable.writeDouble(%s)", name);
        }
        if (type instanceof FieldType.StructType) {
            return String.format("%s.write(_writable, _cache, _version)", name);
        }
        throw new RuntimeException("Unsupported field type " + type);
    }

    private void generateVariableLengthWriter(Versions fieldFlexibleVersions, String name, FieldType type, Versions possibleVersions, Versions nullableVersions, boolean zeroCopy) {
        IsNullConditional.forName(name).possibleVersions(possibleVersions).nullableVersions(nullableVersions).alwaysEmitBlockScope(type.isString()).ifNull(() -> VersionConditional.forVersions(nullableVersions, possibleVersions).ifMember(presentVersions -> VersionConditional.forVersions(fieldFlexibleVersions, presentVersions).ifMember(___ -> this.buffer.printf("_writable.writeUnsignedVarint(0);%n", new Object[0])).ifNotMember(___ -> {
            if (type.isString()) {
                this.buffer.printf("_writable.writeShort((short) -1);%n", new Object[0]);
            } else {
                this.buffer.printf("_writable.writeInt(-1);%n", new Object[0]);
            }
        }).generate(this.buffer)).ifNotMember(__ -> this.buffer.printf("throw new NullPointerException();%n", new Object[0])).generate(this.buffer)).ifShouldNotBeNull(() -> {
            String lengthExpression;
            if (type.isString()) {
                this.buffer.printf("byte[] _stringBytes = _cache.getSerializedValue(%s);%n", name);
                lengthExpression = "_stringBytes.length";
            } else if (type.isBytes()) {
                lengthExpression = zeroCopy ? String.format("%s.remaining()", name) : String.format("%s.length", name);
            } else if (type.isRecords()) {
                lengthExpression = String.format("%s.sizeInBytes()", name);
            } else if (type.isArray()) {
                lengthExpression = String.format("%s.size()", name);
            } else {
                throw new RuntimeException("Unhandled type " + type);
            }
            VersionConditional.forVersions(fieldFlexibleVersions, possibleVersions).ifMember(ifMemberVersions -> this.buffer.printf("_writable.writeUnsignedVarint(%s + 1);%n", lengthExpression)).ifNotMember(ifNotMemberVersions -> {
                if (type.isString()) {
                    this.buffer.printf("_writable.writeShort((short) %s);%n", lengthExpression);
                } else {
                    this.buffer.printf("_writable.writeInt(%s);%n", lengthExpression);
                }
            }).generate(this.buffer);
            if (type.isString()) {
                this.buffer.printf("_writable.writeByteArray(_stringBytes);%n", new Object[0]);
            } else if (type.isBytes()) {
                if (zeroCopy) {
                    this.buffer.printf("_writable.writeByteBuffer(%s);%n", name);
                } else {
                    this.buffer.printf("_writable.writeByteArray(%s);%n", name);
                }
            } else if (type.isRecords()) {
                this.buffer.printf("_writable.writeRecords(%s);%n", name);
            } else if (type.isArray()) {
                FieldType.ArrayType arrayType = (FieldType.ArrayType)type;
                FieldType elementType = arrayType.elementType();
                String elementName = String.format("%sElement", name);
                this.buffer.printf("for (%s %s : %s) {%n", elementType.getBoxedJavaType(this.headerGenerator), elementName, name);
                this.buffer.incrementIndent();
                if (elementType.isArray()) {
                    throw new RuntimeException("Nested arrays are not supported.  Use an array of structures containing another array.");
                }
                if (elementType.isBytes() || elementType.isString()) {
                    this.generateVariableLengthWriter(fieldFlexibleVersions, elementName, elementType, possibleVersions, Versions.NONE, false);
                } else {
                    this.buffer.printf("%s;%n", this.primitiveWriteExpression(elementType, elementName));
                }
                this.buffer.decrementIndent();
                this.buffer.printf("}%n", new Object[0]);
            }
        }).generate(this.buffer);
    }

    private void generateClassMessageSize(String className, StructSpec struct, Versions parentVersions) {
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.ObjectSerializationCache");
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageSizeAccumulator");
        this.buffer.printf("@Override%n", new Object[0]);
        this.buffer.printf("public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("int _numTaggedFields = 0;%n", new Object[0]);
        VersionConditional.forVersions(parentVersions, struct.versions()).allowMembershipCheckAlwaysFalse(false).ifNotMember(__ -> {
            this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
            this.buffer.printf("throw new UnsupportedVersionException(\"Can't size version \" + _version + \" of %s\");%n", className);
        }).generate(this.buffer);
        Versions curVersions = parentVersions.intersect(struct.versions());
        for (FieldSpec field : struct.fields()) {
            VersionConditional.forVersions(field.versions(), curVersions).ifMember(presentVersions -> VersionConditional.forVersions(field.taggedVersions(), presentVersions).ifMember(presentAndTaggedVersions -> this.generateFieldSize(field, presentAndTaggedVersions, true)).ifNotMember(presentAndUntaggedVersions -> this.generateFieldSize(field, presentAndUntaggedVersions, false)).generate(this.buffer)).generate(this.buffer);
        }
        this.buffer.printf("if (_unknownTaggedFields != null) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("_numTaggedFields += _unknownTaggedFields.size();%n", new Object[0]);
        this.buffer.printf("for (RawTaggedField _field : _unknownTaggedFields) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
        this.buffer.printf("_size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));%n", new Object[0]);
        this.buffer.printf("_size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));%n", new Object[0]);
        this.buffer.printf("_size.addBytes(_field.size());%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        VersionConditional.forVersions(this.messageFlexibleVersions, curVersions).ifNotMember(__ -> this.generateCheckForUnsupportedNumTaggedFields("_numTaggedFields > 0")).ifMember(__ -> {
            this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
            this.buffer.printf("_size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));%n", new Object[0]);
        }).generate(this.buffer);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateVariableLengthArrayElementSize(Versions flexibleVersions, String fieldName, FieldType type, Versions versions) {
        if (type instanceof FieldType.StringFieldType) {
            this.generateStringToBytes(fieldName);
            VersionConditional.forVersions(flexibleVersions, versions).ifNotMember(__ -> this.buffer.printf("_size.addBytes(_stringBytes.length + 2);%n", new Object[0])).ifMember(__ -> {
                this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
                this.buffer.printf("_size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));%n", new Object[0]);
            }).generate(this.buffer);
        } else if (type instanceof FieldType.BytesFieldType) {
            this.buffer.printf("_size.addBytes(%s.length);%n", fieldName);
            VersionConditional.forVersions(flexibleVersions, versions).ifNotMember(__ -> this.buffer.printf("_size.addBytes(4);%n", new Object[0])).ifMember(__ -> {
                this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
                this.buffer.printf("_size.addBytes(ByteUtils.sizeOfUnsignedVarint(%s.length + 1));%n", fieldName);
            }).generate(this.buffer);
        } else if (type instanceof FieldType.StructType) {
            this.buffer.printf("%s.addSize(_size, _cache, _version);%n", fieldName);
        } else {
            throw new RuntimeException("Unsupported type " + type);
        }
    }

    private void generateFieldSize(FieldSpec field, Versions possibleVersions, boolean tagged) {
        if (field.type().fixedLength().isPresent()) {
            this.generateFixedLengthFieldSize(field, tagged);
        } else {
            this.generateVariableLengthFieldSize(field, possibleVersions, tagged);
        }
    }

    private void generateFixedLengthFieldSize(FieldSpec field, boolean tagged) {
        if (tagged) {
            field.generateNonDefaultValueCheck(this.headerGenerator, this.structRegistry, this.buffer, "this.", field.nullableVersions());
            this.buffer.incrementIndent();
            this.buffer.printf("_numTaggedFields++;%n", new Object[0]);
            this.buffer.printf("_size.addBytes(%d);%n", MessageGenerator.sizeOfUnsignedVarint(field.tag().get()));
            this.buffer.printf("_size.addBytes(%d);%n", MessageGenerator.sizeOfUnsignedVarint(field.type().fixedLength().get()));
            this.buffer.printf("_size.addBytes(%d);%n", field.type().fixedLength().get());
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
        } else {
            this.buffer.printf("_size.addBytes(%d);%n", field.type().fixedLength().get());
        }
    }

    private void generateVariableLengthFieldSize(FieldSpec field, Versions possibleVersions, boolean tagged) {
        IsNullConditional.forField(field).alwaysEmitBlockScope(true).possibleVersions(possibleVersions).nullableVersions(field.nullableVersions()).ifNull(() -> {
            if (!tagged || !field.defaultString().equals("null")) {
                VersionConditional.forVersions(this.fieldFlexibleVersions(field), possibleVersions).ifMember(__ -> {
                    if (tagged) {
                        this.buffer.printf("_numTaggedFields++;%n", new Object[0]);
                        this.buffer.printf("_size.addBytes(%d);%n", MessageGenerator.sizeOfUnsignedVarint(field.tag().get()));
                        this.buffer.printf("_size.addBytes(%d);%n", MessageGenerator.sizeOfUnsignedVarint(MessageGenerator.sizeOfUnsignedVarint(0)));
                    }
                    this.buffer.printf("_size.addBytes(%d);%n", MessageGenerator.sizeOfUnsignedVarint(0));
                }).ifNotMember(__ -> {
                    if (tagged) {
                        throw new RuntimeException("Tagged field " + field.name() + " should not be present in non-flexible versions.");
                    }
                    if (field.type().isString()) {
                        this.buffer.printf("_size.addBytes(2);%n", new Object[0]);
                    } else {
                        this.buffer.printf("_size.addBytes(4);%n", new Object[0]);
                    }
                }).generate(this.buffer);
            }
        }).ifShouldNotBeNull(() -> {
            if (tagged) {
                if (!field.defaultString().equals("null")) {
                    field.generateNonDefaultValueCheck(this.headerGenerator, this.structRegistry, this.buffer, "this.", Versions.NONE);
                    this.buffer.incrementIndent();
                }
                this.buffer.printf("_numTaggedFields++;%n", new Object[0]);
                this.buffer.printf("_size.addBytes(%d);%n", MessageGenerator.sizeOfUnsignedVarint(field.tag().get()));
            }
            if (field.type().isString()) {
                this.generateStringToBytes(field.camelCaseName());
                VersionConditional.forVersions(this.fieldFlexibleVersions(field), possibleVersions).ifMember(__ -> {
                    this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
                    if (tagged) {
                        this.buffer.printf("int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);%n", new Object[0]);
                        this.buffer.printf("_size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes.length));%n", new Object[0]);
                    } else {
                        this.buffer.printf("_size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));%n", new Object[0]);
                    }
                }).ifNotMember(__ -> {
                    if (tagged) {
                        throw new RuntimeException("Tagged field " + field.name() + " should not be present in non-flexible versions.");
                    }
                    this.buffer.printf("_size.addBytes(_stringBytes.length + 2);%n", new Object[0]);
                }).generate(this.buffer);
            } else if (field.type().isArray()) {
                if (tagged) {
                    this.buffer.printf("int _sizeBeforeArray = _size.totalSize();%n", new Object[0]);
                }
                VersionConditional.forVersions(this.fieldFlexibleVersions(field), possibleVersions).ifMember(__ -> {
                    this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
                    this.buffer.printf("_size.addBytes(ByteUtils.sizeOfUnsignedVarint(%s.size() + 1));%n", field.camelCaseName());
                }).ifNotMember(__ -> this.buffer.printf("_size.addBytes(4);%n", new Object[0])).generate(this.buffer);
                FieldType.ArrayType arrayType = (FieldType.ArrayType)field.type();
                FieldType elementType = arrayType.elementType();
                if (elementType.fixedLength().isPresent()) {
                    this.buffer.printf("_size.addBytes(%s.size() * %d);%n", field.camelCaseName(), elementType.fixedLength().get());
                } else {
                    if (elementType instanceof FieldType.ArrayType) {
                        throw new RuntimeException("Arrays of arrays are not supported (use a struct).");
                    }
                    this.buffer.printf("for (%s %sElement : %s) {%n", elementType.getBoxedJavaType(this.headerGenerator), field.camelCaseName(), field.camelCaseName());
                    this.buffer.incrementIndent();
                    this.generateVariableLengthArrayElementSize(this.fieldFlexibleVersions(field), String.format("%sElement", field.camelCaseName()), elementType, possibleVersions);
                    this.buffer.decrementIndent();
                    this.buffer.printf("}%n", new Object[0]);
                }
                if (tagged) {
                    this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
                    this.buffer.printf("int _arraySize = _size.totalSize() - _sizeBeforeArray;%n", new Object[0]);
                    this.buffer.printf("_cache.setArraySizeInBytes(%s, _arraySize);%n", field.camelCaseName());
                    this.buffer.printf("_size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));%n", new Object[0]);
                }
            } else if (field.type().isBytes()) {
                if (tagged) {
                    this.buffer.printf("int _sizeBeforeBytes = _size.totalSize();%n", new Object[0]);
                }
                if (field.zeroCopy()) {
                    this.buffer.printf("_size.addZeroCopyBytes(%s.remaining());%n", field.camelCaseName());
                } else {
                    this.buffer.printf("_size.addBytes(%s.length);%n", field.camelCaseName());
                }
                VersionConditional.forVersions(this.fieldFlexibleVersions(field), possibleVersions).ifMember(__ -> {
                    this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
                    if (field.zeroCopy()) {
                        this.buffer.printf("_size.addBytes(ByteUtils.sizeOfUnsignedVarint(%s.remaining() + 1));%n", field.camelCaseName());
                    } else {
                        this.buffer.printf("_size.addBytes(ByteUtils.sizeOfUnsignedVarint(%s.length + 1));%n", field.camelCaseName());
                    }
                }).ifNotMember(__ -> this.buffer.printf("_size.addBytes(4);%n", new Object[0])).generate(this.buffer);
                if (tagged) {
                    this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
                    this.buffer.printf("int _bytesSize = _size.totalSize() - _sizeBeforeBytes;%n", new Object[0]);
                    this.buffer.printf("_size.addBytes(ByteUtils.sizeOfUnsignedVarint(_bytesSize));%n", new Object[0]);
                }
            } else if (field.type().isRecords()) {
                this.buffer.printf("_size.addZeroCopyBytes(%s.sizeInBytes());%n", field.camelCaseName());
                VersionConditional.forVersions(this.fieldFlexibleVersions(field), possibleVersions).ifMember(__ -> {
                    this.headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
                    this.buffer.printf("_size.addBytes(ByteUtils.sizeOfUnsignedVarint(%s.sizeInBytes() + 1));%n", field.camelCaseName());
                }).ifNotMember(__ -> this.buffer.printf("_size.addBytes(4);%n", new Object[0])).generate(this.buffer);
            } else if (field.type().isStruct()) {
                this.buffer.printf("int _sizeBeforeStruct = _size.totalSize();%n", field.camelCaseName());
                this.buffer.printf("this.%s.addSize(_size, _cache, _version);%n", field.camelCaseName());
                this.buffer.printf("int _structSize = _size.totalSize() - _sizeBeforeStruct;%n", field.camelCaseName());
                if (tagged) {
                    this.buffer.printf("_size.addBytes(ByteUtils.sizeOfUnsignedVarint(_structSize));%n", new Object[0]);
                }
            } else {
                throw new RuntimeException("unhandled type " + field.type());
            }
            if (tagged && !field.defaultString().equals("null")) {
                this.buffer.decrementIndent();
                this.buffer.printf("}%n", new Object[0]);
            }
        }).generate(this.buffer);
    }

    private void generateStringToBytes(String name) {
        this.headerGenerator.addImport("java.nio.charset.StandardCharsets");
        this.buffer.printf("byte[] _stringBytes = %s.getBytes(StandardCharsets.UTF_8);%n", name);
        this.buffer.printf("if (_stringBytes.length > 0x7fff) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("throw new RuntimeException(\"'%s' field is too long to be serialized\");%n", name);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.printf("_cache.cacheSerializedValue(%s, _stringBytes);%n", name);
    }

    private void generateClassEquals(String className, StructSpec struct, boolean elementKeysAreEqual) {
        this.buffer.printf("@Override%n", new Object[0]);
        this.buffer.printf("public boolean %s(Object obj) {%n", elementKeysAreEqual ? "elementKeysAreEqual" : "equals");
        this.buffer.incrementIndent();
        this.buffer.printf("if (!(obj instanceof %s)) return false;%n", className);
        this.buffer.printf("%s other = (%s) obj;%n", className, className);
        if (!struct.fields().isEmpty()) {
            for (FieldSpec field : struct.fields()) {
                if (elementKeysAreEqual && !field.mapKey()) continue;
                this.generateFieldEquals(field);
            }
        }
        if (elementKeysAreEqual) {
            this.buffer.printf("return true;%n", new Object[0]);
        } else {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
            this.buffer.printf("return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);%n", new Object[0]);
        }
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateFieldEquals(FieldSpec field) {
        if (field.type() instanceof FieldType.UUIDFieldType) {
            this.buffer.printf("if (!this.%s.equals(other.%s)) return false;%n", field.camelCaseName(), field.camelCaseName());
        } else if (field.type().isString() || field.type().isArray() || field.type().isStruct()) {
            this.buffer.printf("if (this.%s == null) {%n", field.camelCaseName());
            this.buffer.incrementIndent();
            this.buffer.printf("if (other.%s != null) return false;%n", field.camelCaseName());
            this.buffer.decrementIndent();
            this.buffer.printf("} else {%n", new Object[0]);
            this.buffer.incrementIndent();
            this.buffer.printf("if (!this.%s.equals(other.%s)) return false;%n", field.camelCaseName(), field.camelCaseName());
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
        } else if (field.type().isBytes()) {
            if (field.zeroCopy()) {
                this.headerGenerator.addImport("java.util.Objects");
                this.buffer.printf("if (!Objects.equals(this.%s, other.%s)) return false;%n", field.camelCaseName(), field.camelCaseName());
            } else {
                this.headerGenerator.addImport("java.util.Arrays");
                this.buffer.printf("if (!Arrays.equals(this.%s, other.%s)) return false;%n", field.camelCaseName(), field.camelCaseName());
            }
        } else if (field.type().isRecords()) {
            this.headerGenerator.addImport("java.util.Objects");
            this.buffer.printf("if (!Objects.equals(this.%s, other.%s)) return false;%n", field.camelCaseName(), field.camelCaseName());
        } else {
            this.buffer.printf("if (%s != other.%s) return false;%n", field.camelCaseName(), field.camelCaseName());
        }
    }

    private void generateClassHashCode(StructSpec struct, boolean onlyMapKeys) {
        this.buffer.printf("@Override%n", new Object[0]);
        this.buffer.printf("public int hashCode() {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("int hashCode = 0;%n", new Object[0]);
        for (FieldSpec field : struct.fields()) {
            if (onlyMapKeys && !field.mapKey()) continue;
            this.generateFieldHashCode(field);
        }
        this.buffer.printf("return hashCode;%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateFieldHashCode(FieldSpec field) {
        if (field.type() instanceof FieldType.BoolFieldType) {
            this.buffer.printf("hashCode = 31 * hashCode + (%s ? 1231 : 1237);%n", field.camelCaseName());
        } else if (field.type() instanceof FieldType.Int8FieldType || field.type() instanceof FieldType.Int16FieldType || field.type() instanceof FieldType.Uint16FieldType || field.type() instanceof FieldType.Int32FieldType) {
            this.buffer.printf("hashCode = 31 * hashCode + %s;%n", field.camelCaseName());
        } else if (field.type() instanceof FieldType.Int64FieldType) {
            this.buffer.printf("hashCode = 31 * hashCode + ((int) (%s >> 32) ^ (int) %s);%n", field.camelCaseName(), field.camelCaseName());
        } else if (field.type() instanceof FieldType.UUIDFieldType) {
            this.buffer.printf("hashCode = 31 * hashCode + %s.hashCode();%n", field.camelCaseName());
        } else if (field.type() instanceof FieldType.Float64FieldType) {
            this.buffer.printf("hashCode = 31 * hashCode + Double.hashCode(%s);%n", field.camelCaseName(), field.camelCaseName());
        } else if (field.type().isBytes()) {
            if (field.zeroCopy()) {
                this.headerGenerator.addImport("java.util.Objects");
                this.buffer.printf("hashCode = 31 * hashCode + Objects.hashCode(%s);%n", field.camelCaseName());
            } else {
                this.headerGenerator.addImport("java.util.Arrays");
                this.buffer.printf("hashCode = 31 * hashCode + Arrays.hashCode(%s);%n", field.camelCaseName());
            }
        } else if (field.type().isRecords()) {
            this.headerGenerator.addImport("java.util.Objects");
            this.buffer.printf("hashCode = 31 * hashCode + Objects.hashCode(%s);%n", field.camelCaseName());
        } else if (field.type().isStruct() || field.type().isArray() || field.type().isString()) {
            this.buffer.printf("hashCode = 31 * hashCode + (%s == null ? 0 : %s.hashCode());%n", field.camelCaseName(), field.camelCaseName());
        } else {
            throw new RuntimeException("Unsupported field type " + field.type());
        }
    }

    private void generateClassDuplicate(String className, StructSpec struct) {
        this.buffer.printf("@Override%n", new Object[0]);
        this.buffer.printf("public %s duplicate() {%n", className);
        this.buffer.incrementIndent();
        this.buffer.printf("%s _duplicate = new %s();%n", className, className);
        for (FieldSpec field : struct.fields()) {
            this.generateFieldDuplicate(new Target(field, field.camelCaseName(), field.camelCaseName(), input -> String.format("_duplicate.%s = %s", field.camelCaseName(), input)));
        }
        this.buffer.printf("return _duplicate;%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateFieldDuplicate(Target target) {
        FieldSpec field = target.field();
        if (field.type() instanceof FieldType.BoolFieldType || field.type() instanceof FieldType.Int8FieldType || field.type() instanceof FieldType.Int16FieldType || field.type() instanceof FieldType.Uint16FieldType || field.type() instanceof FieldType.Int32FieldType || field.type() instanceof FieldType.Int64FieldType || field.type() instanceof FieldType.Float64FieldType || field.type() instanceof FieldType.UUIDFieldType) {
            this.buffer.printf("%s;%n", target.assignmentStatement(target.sourceVariable()));
        } else {
            IsNullConditional cond = IsNullConditional.forName(target.sourceVariable()).nullableVersions(target.field().nullableVersions()).ifNull(() -> this.buffer.printf("%s;%n", target.assignmentStatement("null")));
            if (field.type().isBytes()) {
                if (field.zeroCopy()) {
                    cond.ifShouldNotBeNull(() -> this.buffer.printf("%s;%n", target.assignmentStatement(String.format("%s.duplicate()", target.sourceVariable()))));
                } else {
                    cond.ifShouldNotBeNull(() -> {
                        this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
                        this.buffer.printf("%s;%n", target.assignmentStatement(String.format("MessageUtil.duplicate(%s)", target.sourceVariable())));
                    });
                }
            } else if (field.type().isRecords()) {
                cond.ifShouldNotBeNull(() -> {
                    this.headerGenerator.addImport("org.apache.kafka.common.record.MemoryRecords");
                    this.buffer.printf("%s;%n", target.assignmentStatement(String.format("MemoryRecords.readableRecords(((MemoryRecords) %s).buffer().duplicate())", target.sourceVariable())));
                });
            } else if (field.type().isStruct()) {
                cond.ifShouldNotBeNull(() -> this.buffer.printf("%s;%n", target.assignmentStatement(String.format("%s.duplicate()", target.sourceVariable()))));
            } else if (field.type().isString()) {
                cond.ifShouldNotBeNull(() -> this.buffer.printf("%s;%n", target.assignmentStatement(target.sourceVariable())));
            } else if (field.type().isArray()) {
                cond.ifShouldNotBeNull(() -> {
                    String newArrayName = String.format("new%s", field.capitalizedCamelCaseName());
                    String type = field.concreteJavaType(this.headerGenerator, this.structRegistry);
                    this.buffer.printf("%s %s = new %s(%s.size());%n", type, newArrayName, type, target.sourceVariable());
                    FieldType.ArrayType arrayType = (FieldType.ArrayType)field.type();
                    this.buffer.printf("for (%s _element : %s) {%n", arrayType.elementType().getBoxedJavaType(this.headerGenerator), target.sourceVariable());
                    this.buffer.incrementIndent();
                    this.generateFieldDuplicate(target.arrayElementTarget(input -> String.format("%s.add(%s)", newArrayName, input)));
                    this.buffer.decrementIndent();
                    this.buffer.printf("}%n", new Object[0]);
                    this.buffer.printf("%s;%n", target.assignmentStatement(String.format("new%s", field.capitalizedCamelCaseName())));
                });
            } else {
                throw new RuntimeException("Unhandled field type " + field.type());
            }
            cond.generate(this.buffer);
        }
    }

    private void generateClassToString(String className, StructSpec struct) {
        this.buffer.printf("@Override%n", new Object[0]);
        this.buffer.printf("public String toString() {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("return \"%s(\"%n", className);
        this.buffer.incrementIndent();
        String prefix = "";
        for (FieldSpec field : struct.fields()) {
            this.generateFieldToString(prefix, field);
            prefix = ", ";
        }
        this.buffer.printf("+ \")\";%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateFieldToString(String prefix, FieldSpec field) {
        if (field.type() instanceof FieldType.BoolFieldType) {
            this.buffer.printf("+ \"%s%s=\" + (%s ? \"true\" : \"false\")%n", prefix, field.camelCaseName(), field.camelCaseName());
        } else if (field.type() instanceof FieldType.Int8FieldType || field.type() instanceof FieldType.Int16FieldType || field.type() instanceof FieldType.Uint16FieldType || field.type() instanceof FieldType.Int32FieldType || field.type() instanceof FieldType.Int64FieldType || field.type() instanceof FieldType.Float64FieldType) {
            this.buffer.printf("+ \"%s%s=\" + %s%n", prefix, field.camelCaseName(), field.camelCaseName());
        } else if (field.type().isString()) {
            this.buffer.printf("+ \"%s%s=\" + ((%s == null) ? \"null\" : \"'\" + %s.toString() + \"'\")%n", prefix, field.camelCaseName(), field.camelCaseName(), field.camelCaseName());
        } else if (field.type().isBytes()) {
            if (field.zeroCopy()) {
                this.buffer.printf("+ \"%s%s=\" + %s%n", prefix, field.camelCaseName(), field.camelCaseName());
            } else {
                this.headerGenerator.addImport("java.util.Arrays");
                this.buffer.printf("+ \"%s%s=\" + Arrays.toString(%s)%n", prefix, field.camelCaseName(), field.camelCaseName());
            }
        } else if (field.type().isRecords()) {
            this.buffer.printf("+ \"%s%s=\" + %s%n", prefix, field.camelCaseName(), field.camelCaseName());
        } else if (field.type() instanceof FieldType.UUIDFieldType || field.type().isStruct()) {
            this.buffer.printf("+ \"%s%s=\" + %s.toString()%n", prefix, field.camelCaseName(), field.camelCaseName());
        } else if (field.type().isArray()) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
            if (field.nullableVersions().empty()) {
                this.buffer.printf("+ \"%s%s=\" + MessageUtil.deepToString(%s.iterator())%n", prefix, field.camelCaseName(), field.camelCaseName());
            } else {
                this.buffer.printf("+ \"%s%s=\" + ((%s == null) ? \"null\" : MessageUtil.deepToString(%s.iterator()))%n", prefix, field.camelCaseName(), field.camelCaseName(), field.camelCaseName());
            }
        } else {
            throw new RuntimeException("Unsupported field type " + field.type());
        }
    }

    private void generateFieldAccessor(FieldSpec field) {
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor(field.fieldAbstractJavaType(this.headerGenerator, this.structRegistry), field.camelCaseName(), field.camelCaseName());
    }

    private void generateAccessor(String javaType, String functionName, String memberName) {
        this.buffer.printf("public %s %s() {%n", javaType, functionName);
        this.buffer.incrementIndent();
        this.buffer.printf("return this.%s;%n", memberName);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateFieldMutator(String className, FieldSpec field) {
        this.buffer.printf("%n", new Object[0]);
        this.buffer.printf("public %s set%s(%s v) {%n", className, field.capitalizedCamelCaseName(), field.fieldAbstractJavaType(this.headerGenerator, this.structRegistry));
        this.buffer.incrementIndent();
        if (field.type() instanceof FieldType.Uint16FieldType) {
            this.buffer.printf("if (v < 0 || v > 65535) {%n", new Object[0]);
            this.buffer.incrementIndent();
            this.buffer.printf("throw new RuntimeException(\"Invalid value \" + v + \" for unsigned short field.\");%n", new Object[0]);
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
        }
        this.buffer.printf("this.%s = v;%n", field.camelCaseName());
        this.buffer.printf("return this;%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateSetter(String javaType, String functionName, String memberName) {
        this.buffer.printf("public void %s(%s v) {%n", functionName, javaType);
        this.buffer.incrementIndent();
        this.buffer.printf("this.%s = v;%n", memberName);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private Versions fieldFlexibleVersions(FieldSpec field) {
        if (field.flexibleVersions().isPresent()) {
            if (!this.messageFlexibleVersions.intersect(field.flexibleVersions().get()).equals(field.flexibleVersions().get())) {
                throw new RuntimeException("The flexible versions for field " + field.name() + " are " + field.flexibleVersions().get() + ", which are not a subset of the flexible versions for the message as a whole, which are " + this.messageFlexibleVersions);
            }
            return field.flexibleVersions().get();
        }
        return this.messageFlexibleVersions;
    }
}

