/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class CodeBuffer {
    private final ArrayList<String> lines = new ArrayList();
    private int indent = 0;

    public void incrementIndent() {
        ++this.indent;
    }

    public void decrementIndent() {
        --this.indent;
        if (this.indent < 0) {
            throw new RuntimeException("Indent < 0");
        }
    }

    public void printf(String format, Object ... args) {
        this.lines.add(String.format(this.indentSpaces() + format, args));
    }

    public void write(Writer writer) throws IOException {
        for (String line : this.lines) {
            writer.write(line);
        }
    }

    public void write(CodeBuffer other) {
        for (String line : this.lines) {
            other.lines.add(other.indentSpaces() + line);
        }
    }

    private String indentSpaces() {
        StringBuilder bld = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            bld.append("    ");
        }
        return bld.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CodeBuffer)) {
            return false;
        }
        CodeBuffer o = (CodeBuffer)other;
        return this.lines.equals(o.lines);
    }

    public int hashCode() {
        return this.lines.hashCode();
    }
}

