/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.AbstractHerder;
import org.apache.kafka.connect.runtime.CloseableConnectorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HerderConnectorContext
implements CloseableConnectorContext {
    private static final Logger log = LoggerFactory.getLogger(HerderConnectorContext.class);
    private final AbstractHerder herder;
    private final String connectorName;
    private volatile boolean closed;

    public HerderConnectorContext(AbstractHerder herder, String connectorName) {
        this.herder = herder;
        this.connectorName = connectorName;
        this.closed = false;
    }

    public void requestTaskReconfiguration() {
        if (this.closed) {
            throw new ConnectException("The request for task reconfiguration has been rejected because this instance of the connector '" + this.connectorName + "' has already been shut down.");
        }
        this.herder.requestTaskReconfiguration(this.connectorName);
    }

    public void raiseError(Exception e) {
        if (this.closed) {
            log.warn("Connector {} attempted to raise error after shutdown:", (Object)this.connectorName, (Object)e);
            throw new ConnectException("The request to fail the connector has been rejected because this instance of the connector '" + this.connectorName + "' has already been shut down.");
        }
        this.herder.onFailure(this.connectorName, (Throwable)e);
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

