/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.storage.MemoryOffsetBackingStore;
import org.apache.kafka.connect.util.SafeObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOffsetBackingStore
extends MemoryOffsetBackingStore {
    private static final Logger log = LoggerFactory.getLogger(FileOffsetBackingStore.class);
    private File file;

    @Override
    public void configure(WorkerConfig config) {
        super.configure(config);
        this.file = new File(config.getString("offset.storage.file.filename"));
    }

    @Override
    public synchronized void start() {
        super.start();
        log.info("Starting FileOffsetBackingStore with file {}", (Object)this.file);
        this.load();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        log.info("Stopped FileOffsetBackingStore");
    }

    private void load() {
        try (SafeObjectInputStream is = new SafeObjectInputStream(new FileInputStream(this.file));){
            Object obj = is.readObject();
            if (!(obj instanceof HashMap)) {
                throw new ConnectException("Expected HashMap but found " + obj.getClass());
            }
            Map raw = (Map)obj;
            this.data = new HashMap();
            for (Map.Entry mapEntry : raw.entrySet()) {
                ByteBuffer key = mapEntry.getKey() != null ? ByteBuffer.wrap((byte[])mapEntry.getKey()) : null;
                ByteBuffer value = mapEntry.getValue() != null ? ByteBuffer.wrap((byte[])mapEntry.getValue()) : null;
                this.data.put(key, value);
            }
        }
        catch (EOFException | FileNotFoundException e) {
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    protected void save() {
        try (ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(this.file));){
            HashMap<byte[], byte[]> raw = new HashMap<byte[], byte[]>();
            for (Map.Entry mapEntry : this.data.entrySet()) {
                byte[] key = mapEntry.getKey() != null ? ((ByteBuffer)mapEntry.getKey()).array() : null;
                byte[] value = mapEntry.getValue() != null ? ((ByteBuffer)mapEntry.getValue()).array() : null;
                raw.put(key, value);
            }
            os.writeObject(raw);
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }
}

